/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLUtils.class);
    private static final Map<ClassLoader, DocumentBuilderFactory> DOCUMENT_BUILDER_FACTORIES = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<ClassLoader, TransformerFactory> TRANSFORMER_FACTORIES = Collections.synchronizedMap(new WeakHashMap());

    private XMLUtils() {
    }

    private static TransformerFactory getTransformerFactory() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = XMLUtils.class.getClassLoader();
        }
        if (loader == null) {
            return TransformerFactory.newInstance();
        }
        TransformerFactory factory = TRANSFORMER_FACTORIES.get(loader);
        if (factory == null) {
            factory = TransformerFactory.newInstance();
            TRANSFORMER_FACTORIES.put(loader, factory);
        }
        return factory;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = XMLUtils.class.getClassLoader();
        }
        if (loader == null) {
            return DocumentBuilderFactory.newInstance();
        }
        DocumentBuilderFactory factory = DOCUMENT_BUILDER_FACTORIES.get(loader);
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DOCUMENT_BUILDER_FACTORIES.put(loader, factory);
        }
        return factory;
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        return XMLUtils.getTransformerFactory().newTransformer();
    }

    public static Transformer newTransformer(int indent2) throws TransformerConfigurationException {
        if (indent2 > 0) {
            TransformerFactory f2 = TransformerFactory.newInstance();
            try {
                f2.setAttribute("indent-number", Integer.toString(indent2));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return f2.newTransformer();
        }
        return XMLUtils.getTransformerFactory().newTransformer();
    }

    public static DocumentBuilder getParser() throws ParserConfigurationException {
        return XMLUtils.getDocumentBuilderFactory().newDocumentBuilder();
    }

    public static Document parse(InputSource is2) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.getParser().parse(is2);
    }

    public static Document parse(File is2) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.getParser().parse(is2);
    }

    public static Document parse(InputStream in2) throws ParserConfigurationException, SAXException, IOException {
        if (in2 == null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("XMLUtils trying to parse a null inputstream");
        }
        return XMLUtils.getParser().parse(in2);
    }

    public static Document parse(String in2) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.parse(in2.getBytes());
    }

    public static Document parse(byte[] in2) throws ParserConfigurationException, SAXException, IOException {
        if (in2 == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("XMLUtils trying to parse a null bytes");
            }
            return null;
        }
        return XMLUtils.getParser().parse(new ByteArrayInputStream(in2));
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XMLUtils.getParser().newDocument();
    }

    public static void writeTo(Node node4, OutputStream os2) {
        XMLUtils.writeTo((Source)new DOMSource(node4), os2);
    }

    public static void writeTo(Node node4, OutputStream os2, int indent2) {
        XMLUtils.writeTo((Source)new DOMSource(node4), os2, indent2);
    }

    public static void writeTo(Source src, OutputStream os2) {
        XMLUtils.writeTo(src, os2, -1);
    }

    public static void writeTo(Node node4, Writer os2) {
        XMLUtils.writeTo((Source)new DOMSource(node4), os2);
    }

    public static void writeTo(Node node4, Writer os2, int indent2) {
        XMLUtils.writeTo((Source)new DOMSource(node4), os2, indent2);
    }

    public static void writeTo(Source src, Writer os2) {
        XMLUtils.writeTo(src, os2, -1);
    }

    public static void writeTo(Source src, OutputStream os2, int indent2) {
        String enc = null;
        if (src instanceof DOMSource && ((DOMSource)src).getNode() instanceof Document) {
            try {
                enc = ((Document)((DOMSource)src).getNode()).getXmlEncoding();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        XMLUtils.writeTo(src, os2, indent2, enc, "no");
    }

    public static void writeTo(Source src, Writer os2, int indent2) {
        String enc = null;
        if (src instanceof DOMSource && ((DOMSource)src).getNode() instanceof Document) {
            try {
                enc = ((Document)((DOMSource)src).getNode()).getXmlEncoding();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        XMLUtils.writeTo(src, os2, indent2, enc, "no");
    }

    public static void writeTo(Source src, OutputStream os2, int indent2, String charset, String omitXmlDecl) {
        try {
            if (StringUtils.isEmpty(charset)) {
                charset = "utf-8";
            }
            Transformer it = XMLUtils.newTransformer(indent2);
            it.setOutputProperty("method", "xml");
            if (indent2 > -1) {
                it.setOutputProperty("indent", "yes");
                it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent2));
            }
            it.setOutputProperty("omit-xml-declaration", omitXmlDecl);
            it.setOutputProperty("encoding", charset);
            it.transform(src, new StreamResult(os2));
        }
        catch (TransformerException e2) {
            throw new RuntimeException("Failed to configure TRaX", e2);
        }
    }

    public static void writeTo(Source src, Writer os2, int indent2, String charset, String omitXmlDecl) {
        try {
            if (StringUtils.isEmpty(charset)) {
                charset = "utf-8";
            }
            Transformer it = XMLUtils.newTransformer(indent2);
            it.setOutputProperty("method", "xml");
            if (indent2 > -1) {
                it.setOutputProperty("indent", "yes");
                it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent2));
            }
            it.setOutputProperty("omit-xml-declaration", omitXmlDecl);
            it.setOutputProperty("encoding", charset);
            it.transform(src, new StreamResult(os2));
        }
        catch (TransformerException e2) {
            throw new RuntimeException("Failed to configure TRaX", e2);
        }
    }

    public static String toString(Source source) throws TransformerException, IOException {
        return XMLUtils.toString(source, null);
    }

    public static String toString(Source source, Properties props) throws TransformerException, IOException {
        StringWriter bos = new StringWriter();
        StreamResult sr = new StreamResult(bos);
        Transformer trans2 = XMLUtils.newTransformer();
        if (props == null) {
            props = new Properties();
            props.put("omit-xml-declaration", "yes");
        }
        trans2.setOutputProperties(props);
        trans2.transform(source, sr);
        bos.close();
        return bos.toString();
    }

    public static String toString(Node node4, int indent2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtils.writeTo(node4, (OutputStream)out, indent2);
        return out.toString();
    }

    public static String toString(Node node4) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtils.writeTo(node4, (OutputStream)out);
        return out.toString();
    }

    public static void printDOM(Node node4) {
        XMLUtils.printDOM("", node4);
    }

    public static void printDOM(String words2, Node node4) {
        System.out.println(words2);
        System.out.println(XMLUtils.toString(node4));
    }

    public static Attr getAttribute(Element el, String attrName) {
        return el.getAttributeNode(attrName);
    }

    public static void replaceAttribute(Element element2, String attr, String value2) {
        if (element2.hasAttribute(attr)) {
            element2.removeAttribute(attr);
        }
        element2.setAttribute(attr, value2);
    }

    public static boolean hasAttribute(Element element2, String value2) {
        NamedNodeMap attributes2 = element2.getAttributes();
        for (int i = 0; i < attributes2.getLength(); ++i) {
            Node node4 = attributes2.item(i);
            if (!value2.equals(node4.getNodeValue())) continue;
            return true;
        }
        return false;
    }

    public static void printAttributes(Element element2) {
        NamedNodeMap attributes2 = element2.getAttributes();
        for (int i = 0; i < attributes2.getLength(); ++i) {
            Node node4 = attributes2.item(i);
            System.err.println("## prefix=" + node4.getPrefix() + " localname:" + node4.getLocalName() + " value=" + node4.getNodeValue());
        }
    }

    public static QName getNamespace(Map<String, String> namespaces, String str, String defaultNamespace) {
        String prefix2 = null;
        String localName = null;
        StringTokenizer tokenizer = new StringTokenizer(str, ":");
        if (tokenizer.countTokens() == 2) {
            prefix2 = tokenizer.nextToken();
            localName = tokenizer.nextToken();
        } else if (tokenizer.countTokens() == 1) {
            localName = tokenizer.nextToken();
        }
        String namespceURI = defaultNamespace;
        if (prefix2 != null) {
            namespceURI = namespaces.get(prefix2);
        }
        return new QName(namespceURI, localName);
    }

    public static void generateXMLFile(Element element2, Writer writer) {
        try {
            Transformer it = XMLUtils.newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            it.setOutputProperty("encoding", "UTF-8");
            it.transform(new DOMSource(element2), new StreamResult(writer));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static Element createElementNS(Node node4, QName name) {
        return XMLUtils.createElementNS(node4.getOwnerDocument(), name.getNamespaceURI(), name.getLocalPart());
    }

    public static Element createElementNS(Document root2, QName name) {
        return XMLUtils.createElementNS(root2, name.getNamespaceURI(), name.getLocalPart());
    }

    public static Element createElementNS(Document root2, String namespaceURI, String qualifiedName) {
        return root2.createElementNS(namespaceURI, qualifiedName);
    }

    public static Text createTextNode(Document root2, String data2) {
        return root2.createTextNode(data2);
    }

    public static Text createTextNode(Node node4, String data2) {
        return XMLUtils.createTextNode(node4.getOwnerDocument(), data2);
    }

    public static void removeContents(Node parent2) {
        for (Node node4 = parent2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            parent2.removeChild(node4);
        }
    }

    public static InputStream getInputStream(Document doc) throws Exception {
        DOMImplementationLS impl = null;
        DOMImplementation docImpl = doc.getImplementation();
        if (docImpl != null && docImpl.hasFeature("LS", "3.0")) {
            impl = (DOMImplementationLS)docImpl.getFeature("LS", "3.0");
        } else {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            if (impl == null) {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
                registry = DOMImplementationRegistry.newInstance();
                impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            }
        }
        LSOutput output = impl.createLSOutput();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        output.setByteStream(byteArrayOutputStream);
        LSSerializer writer = impl.createLSSerializer();
        writer.write(doc, output);
        byte[] buf = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(buf);
    }

    public static Element fetchElementByNameAttribute(Element parent2, String targetName, String nameValue) {
        List<Element> elemList = DOMUtils.findAllElementsByTagName(parent2, targetName);
        for (Element elem2 : elemList) {
            if (!elem2.getAttribute("name").equals(nameValue)) continue;
            return elem2;
        }
        return null;
    }

    public static QName getQName(String value2, Node node4) {
        if (value2 == null) {
            return null;
        }
        int index2 = value2.indexOf(":");
        if (index2 == -1) {
            return new QName(value2);
        }
        String prefix2 = value2.substring(0, index2);
        String localName = value2.substring(index2 + 1);
        String ns = node4.lookupNamespaceURI(prefix2);
        if (ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value2);
        }
        return new QName(ns, localName, prefix2);
    }

    public static Node fromSource(Source src) throws Exception {
        Transformer trans2 = TransformerFactory.newInstance().newTransformer();
        DOMResult res = new DOMResult();
        trans2.transform(src, res);
        return res.getNode();
    }

    public static QName convertStringToQName(String expandedQName) {
        return XMLUtils.convertStringToQName(expandedQName, "");
    }

    public static QName convertStringToQName(String expandedQName, String prefix2) {
        int ind1 = expandedQName.indexOf(123);
        if (ind1 != 0) {
            return new QName(expandedQName);
        }
        int ind2 = expandedQName.indexOf(125);
        if (ind2 <= ind1 + 1 || ind2 >= expandedQName.length() - 1) {
            return null;
        }
        String ns = expandedQName.substring(ind1 + 1, ind2);
        String localName = expandedQName.substring(ind2 + 1);
        return new QName(ns, localName, prefix2);
    }

    public static Set<QName> convertStringsToQNames(List<String> expandedQNames) {
        Set<QName> dropElements = Collections.emptySet();
        if (expandedQNames != null) {
            dropElements = new LinkedHashSet<QName>(expandedQNames.size());
            for (String val : expandedQNames) {
                dropElements.add(XMLUtils.convertStringToQName(val));
            }
        }
        return dropElements;
    }
}

