/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Set;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointSelectionInterceptor
extends AbstractPhaseInterceptor<Message> {
    public AbstractEndpointSelectionInterceptor() {
        super(null);
    }

    public AbstractEndpointSelectionInterceptor(String phase) {
        super(phase);
    }

    public AbstractEndpointSelectionInterceptor(String id2, String phase) {
        super(id2, phase);
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Exchange ex2 = message.getExchange();
        Set<Endpoint> endpoints = CastUtils.cast((Set)ex2.get("multipleEndpointObserver.endpoints"));
        Endpoint ep = this.selectEndpoint(message, endpoints);
        if (ep == null) {
            return;
        }
        ex2.put(Endpoint.class, ep);
        ex2.put(Binding.class, ep.getBinding());
        ex2.put(Service.class, ep.getService());
        InterceptorChain chain2 = message.getInterceptorChain();
        chain2.add(ep.getInInterceptors());
        chain2.add(ep.getBinding().getInInterceptors());
        chain2.add(ep.getService().getInInterceptors());
        chain2.setFaultObserver(ep.getOutFaultObserver());
    }

    protected abstract Endpoint selectEndpoint(Message var1, Set<Endpoint> var2);
}

