/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.Features;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InFaultInterceptors;
import org.apache.cxf.interceptor.InInterceptors;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutFaultInterceptors;
import org.apache.cxf.interceptor.OutInterceptors;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInterceptors {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AnnotationInterceptors.class);
    private Class<?>[] clazzes;

    public AnnotationInterceptors(Class<?> ... clz) {
        this.clazzes = clz;
    }

    private <T> List<T> getAnnotationObject(Class<? extends Annotation> annotationClazz, Class<T> type) {
        for (Class<?> cls : this.clazzes) {
            Annotation annotation2 = cls.getAnnotation(annotationClazz);
            if (annotation2 == null) continue;
            return this.initializeAnnotationObjects(this.getAnnotationObjectNames(annotation2), type);
        }
        return null;
    }

    private String[] getAnnotationObjectNames(Annotation ann) {
        if (ann instanceof InFaultInterceptors) {
            return ((InFaultInterceptors)ann).interceptors();
        }
        if (ann instanceof InInterceptors) {
            return ((InInterceptors)ann).interceptors();
        }
        if (ann instanceof OutFaultInterceptors) {
            return ((OutFaultInterceptors)ann).interceptors();
        }
        if (ann instanceof OutInterceptors) {
            return ((OutInterceptors)ann).interceptors();
        }
        if (ann instanceof Features) {
            return ((Features)ann).features();
        }
        throw new UnsupportedOperationException("Doesn't support the annotation: " + ann);
    }

    private <T> List<T> initializeAnnotationObjects(String[] annotationObjects, Class<T> type) {
        ArrayList<T> theAnnotationObjects = new ArrayList<T>();
        if (annotationObjects != null && annotationObjects.length > 0) {
            for (String annObjectName : annotationObjects) {
                Object object = null;
                try {
                    object = ClassLoaderUtils.loadClass(annObjectName, this.getClass()).newInstance();
                    theAnnotationObjects.add(type.cast(object));
                }
                catch (ClassNotFoundException e2) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, annObjectName), (Throwable)e2);
                }
                catch (InstantiationException ie) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, annObjectName), (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, annObjectName), (Throwable)iae);
                }
                catch (ClassCastException ex2) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, annObjectName), (Throwable)ex2);
                }
            }
        }
        return theAnnotationObjects;
    }

    private List<Interceptor<? extends Message>> getAnnotationInterceptorList(Class<? extends Annotation> t2) {
        List<Interceptor> i = this.getAnnotationObject(t2, Interceptor.class);
        if (i == null) {
            return null;
        }
        ArrayList<Interceptor<? extends Message>> m = new ArrayList<Interceptor<? extends Message>>();
        for (Interceptor i2 : i) {
            m.add(i2);
        }
        return m;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.getAnnotationInterceptorList(InFaultInterceptors.class);
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.getAnnotationInterceptorList(InInterceptors.class);
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.getAnnotationInterceptorList(OutFaultInterceptors.class);
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.getAnnotationInterceptorList(OutInterceptors.class);
    }

    public List<AbstractFeature> getFeatures() {
        return this.getAnnotationObject(Features.class, AbstractFeature.class);
    }
}

