/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Map;
import java.util.SortedSet;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractFaultChainInitiatorObserver;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientOutFaultObserver
extends AbstractFaultChainInitiatorObserver {
    public ClientOutFaultObserver(Bus bus) {
        super(bus);
    }

    @Override
    protected SortedSet<Phase> getPhases() {
        return this.getBus().getExtension(PhaseManager.class).getOutPhases();
    }

    @Override
    public void onMessage(Message m) {
        if (m.get("org.apache.cxf.message.inbound").equals(Boolean.TRUE)) {
            return;
        }
        Exception ex2 = m.getContent(Exception.class);
        ClientCallback callback = m.getExchange().get(ClientCallback.class);
        if (callback != null) {
            Map<String, Object> resCtx = CastUtils.cast((Map)m.getExchange().getOutMessage().get("org.apache.cxf.invocation.context"));
            resCtx = CastUtils.cast((Map)resCtx.get("ResponseContext"));
            callback.handleException(resCtx, ex2);
        }
    }

    @Override
    protected boolean isOutboundObserver() {
        return true;
    }
}

