/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutEndingInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIStaxOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String FI_ENABLED = "org.apache.cxf.fastinfoset.enabled";
    private static final String OUTPUT_STREAM_HOLDER = FIStaxOutInterceptor.class.getName() + ".outputstream";
    private static final StaxOutEndingInterceptor ENDING = new StaxOutEndingInterceptor(OUTPUT_STREAM_HOLDER);
    boolean force;

    public FIStaxOutInterceptor() {
        super("pre-stream");
        this.addAfter(AttachmentOutInterceptor.class.getName());
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public FIStaxOutInterceptor(boolean f2) {
        this();
        this.force = f2;
    }

    @Override
    public void handleFault(Message message) {
        super.handleFault(message);
        OutputStream os2 = (OutputStream)message.get(OUTPUT_STREAM_HOLDER);
        if (os2 != null) {
            message.setContent(OutputStream.class, os2);
        }
    }

    @Override
    public void handleMessage(Message message) {
        OutputStream out = message.getContent(OutputStream.class);
        XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
        if (out == null || writer != null) {
            return;
        }
        boolean req = this.isRequestor(message);
        Object o = message.getContextualProperty(FI_ENABLED);
        if (!req) {
            String s2;
            if (message.getExchange().getInMessage() != null && (s2 = (String)message.getExchange().getInMessage().get("Accept")) != null && s2.contains("fastinfoset")) {
                o = Boolean.TRUE;
            }
        } else {
            Map headers2 = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
            ArrayList<String> accepts = (ArrayList<String>)headers2.get("Accept");
            if (accepts == null) {
                accepts = new ArrayList<String>();
                headers2.put("Accept", accepts);
            }
            String a2 = "application/fastinfoset";
            if (!accepts.isEmpty()) {
                a2 = a2 + ", " + (String)accepts.get(0);
                accepts.set(0, a2);
            } else {
                accepts.add(a2);
            }
        }
        if (this.force || MessageUtils.isTrue(o)) {
            StAXDocumentSerializer serializer = this.getOutput(message, out);
            message.setContent(XMLStreamWriter.class, serializer);
            message.removeContent(OutputStream.class);
            message.put(OUTPUT_STREAM_HOLDER, out);
            message.put("disable.outputstream.optimization", Boolean.TRUE);
            String s3 = (String)message.get("Content-Type");
            if (s3.contains("application/soap+xml")) {
                s3 = s3.replace("application/soap+xml", "application/soap+fastinfoset");
                message.put("Content-Type", s3);
            } else {
                message.put("Content-Type", "application/fastinfoset");
            }
            try {
                serializer.writeStartDocument();
            }
            catch (XMLStreamException e2) {
                throw new Fault(e2);
            }
            message.getInterceptorChain().add(ENDING);
        }
    }

    private StAXDocumentSerializer getOutput(Message m, OutputStream out) {
        return new StAXDocumentSerializer(out);
    }
}

