/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Collection;
import java.util.SortedSet;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InFaultChainInitiatorObserver
extends AbstractFaultChainInitiatorObserver {
    public InFaultChainInitiatorObserver(Bus bus) {
        super(bus);
    }

    @Override
    protected void initializeInterceptors(Exchange ex2, PhaseInterceptorChain chain2) {
        Endpoint e2 = ex2.get(Endpoint.class);
        Client c2 = ex2.get(Client.class);
        InterceptorProvider ip = ex2.get(InterceptorProvider.class);
        chain2.add(this.getBus().getInFaultInterceptors());
        if (c2 != null) {
            chain2.add(c2.getInFaultInterceptors());
        } else if (ip != null) {
            chain2.add(ip.getInFaultInterceptors());
        }
        chain2.add(e2.getService().getInFaultInterceptors());
        chain2.add(e2.getInFaultInterceptors());
        chain2.add(e2.getBinding().getInFaultInterceptors());
        if (e2.getService().getDataBinding() instanceof InterceptorProvider) {
            chain2.add(((InterceptorProvider)((Object)e2.getService().getDataBinding())).getInFaultInterceptors());
        }
        this.addToChain(chain2, ex2.getInFaultMessage());
        this.addToChain(chain2, ex2.getOutMessage());
    }

    private void addToChain(PhaseInterceptorChain chain2, Message m) {
        Collection<Interceptor<? extends Message>> is2;
        Collection<InterceptorProvider> providers = CastUtils.cast((Collection)m.get(Message.INTERCEPTOR_PROVIDERS));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain2.add(p.getInFaultInterceptors());
            }
        }
        if ((is2 = CastUtils.cast((Collection)m.get(Message.FAULT_IN_INTERCEPTORS))) != null) {
            chain2.add(is2);
        }
    }

    @Override
    protected SortedSet<Phase> getPhases() {
        return this.getBus().getExtension(PhaseManager.class).getInPhases();
    }

    @Override
    protected boolean isOutboundObserver() {
        return false;
    }
}

