/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Collection;
import java.util.SortedSet;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutFaultChainInitiatorObserver
extends AbstractFaultChainInitiatorObserver {
    public OutFaultChainInitiatorObserver(Bus bus) {
        super(bus);
    }

    @Override
    protected void initializeInterceptors(Exchange ex2, PhaseInterceptorChain chain2) {
        Endpoint e2 = ex2.get(Endpoint.class);
        Client c2 = ex2.get(Client.class);
        chain2.add(this.getBus().getOutFaultInterceptors());
        if (c2 != null) {
            chain2.add(c2.getOutFaultInterceptors());
        }
        chain2.add(e2.getService().getOutFaultInterceptors());
        chain2.add(e2.getOutFaultInterceptors());
        chain2.add(e2.getBinding().getOutFaultInterceptors());
        if (e2.getService().getDataBinding() instanceof InterceptorProvider) {
            chain2.add(((InterceptorProvider)((Object)e2.getService().getDataBinding())).getOutFaultInterceptors());
        }
        this.addToChain(chain2, ex2.getInMessage());
        this.addToChain(chain2, ex2.getOutFaultMessage());
    }

    private void addToChain(PhaseInterceptorChain chain2, Message m) {
        Collection<Interceptor<? extends Message>> is2;
        Collection<InterceptorProvider> providers = CastUtils.cast((Collection)m.get(Message.INTERCEPTOR_PROVIDERS));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain2.add(p.getOutFaultInterceptors());
            }
        }
        if ((is2 = CastUtils.cast((Collection)m.get(Message.FAULT_OUT_INTERCEPTORS))) != null) {
            chain2.add(is2);
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain2.add(((InterceptorProvider)((Object)m.getDestination())).getOutFaultInterceptors());
        }
    }

    @Override
    protected SortedSet<Phase> getPhases() {
        return this.getBus().getExtension(PhaseManager.class).getOutPhases();
    }

    @Override
    protected boolean isOutboundObserver() {
        return true;
    }
}

