/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.transport.Conduit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingChainInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(OutgoingChainInterceptor.class);
    private PhaseChainCache chainCache = new PhaseChainCache();

    public OutgoingChainInterceptor() {
        super("post-invoke");
    }

    @Override
    public void handleMessage(Message message) {
        Exchange ex2 = message.getExchange();
        BindingOperationInfo bin = ex2.get(BindingOperationInfo.class);
        if (null != bin && null != bin.getOperationInfo() && bin.getOperationInfo().isOneWay()) {
            this.closeInput(message);
            return;
        }
        Message out = ex2.getOutMessage();
        if (out != null) {
            InterceptorChain outChain;
            OutgoingChainInterceptor.getBackChannelConduit(message);
            if (bin != null) {
                out.put(MessageInfo.class, bin.getOperationInfo().getOutput());
                out.put(BindingMessageInfo.class, bin.getOutput());
            }
            if ((outChain = out.getInterceptorChain()) == null) {
                outChain = this.getChain(ex2);
                out.setInterceptorChain(outChain);
            }
            outChain.doIntercept(out);
        }
    }

    private void closeInput(Message message) {
        InputStream is2 = message.getContent(InputStream.class);
        if (is2 != null) {
            try {
                is2.close();
                message.removeContent(InputStream.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static Conduit getBackChannelConduit(Message message) {
        Conduit conduit = null;
        Exchange ex2 = message.getExchange();
        if (ex2.getConduit(message) == null && ex2.getDestination() != null) {
            try {
                conduit = ex2.getDestination().getBackChannel(ex2.getInMessage(), null, null);
                ex2.put(ConduitSelector.class, new PreexistingConduitSelector(conduit, ex2.get(Endpoint.class)));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return conduit;
    }

    public static InterceptorChain getOutInterceptorChain(Exchange ex2) {
        Bus bus = ex2.get(Bus.class);
        Binding binding = ex2.get(Binding.class);
        PhaseManager pm = bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain2 = new PhaseInterceptorChain(pm.getOutPhases());
        Endpoint ep = ex2.get(Endpoint.class);
        List<Interceptor<? extends Message>> il = ep.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain2.add(il);
        il = ep.getService().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by service: " + il);
        }
        chain2.add(il);
        il = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain2.add(il);
        if (binding != null) {
            il = binding.getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by binding: " + il);
            }
            chain2.add(il);
        }
        OutgoingChainInterceptor.modifyChain(chain2, ex2);
        chain2.setFaultObserver(ep.getOutFaultObserver());
        return chain2;
    }

    private static void modifyChain(PhaseInterceptorChain chain2, Exchange ex2) {
        OutgoingChainInterceptor.modifyChain(chain2, ex2.getInMessage());
        OutgoingChainInterceptor.modifyChain(chain2, ex2.getOutMessage());
    }

    private static void modifyChain(PhaseInterceptorChain chain2, Message m) {
        Collection<Interceptor<? extends Message>> is2;
        if (m == null) {
            return;
        }
        Collection<InterceptorProvider> providers = CastUtils.cast((Collection)m.get(Message.INTERCEPTOR_PROVIDERS));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain2.add(p.getOutInterceptors());
            }
        }
        if ((is2 = CastUtils.cast((Collection)m.get(Message.OUT_INTERCEPTORS))) != null) {
            chain2.add(is2);
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain2.add(((InterceptorProvider)((Object)m.getDestination())).getOutInterceptors());
        }
    }

    private PhaseInterceptorChain getChain(Exchange ex2) {
        Bus bus = ex2.get(Bus.class);
        Binding binding = ex2.get(Binding.class);
        Endpoint ep = ex2.get(Endpoint.class);
        List<Interceptor<? extends Message>> i1 = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List<Interceptor<? extends Message>> i2 = ep.getService().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by service: " + i2);
        }
        List<Interceptor<? extends Message>> i3 = ep.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i3);
        }
        List<Interceptor<? extends Message>> i4 = null;
        if (binding != null) {
            i4 = binding.getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by binding: " + i4);
            }
        }
        List<Interceptor<? extends Message>> i5 = null;
        if (ep.getService().getDataBinding() instanceof InterceptorProvider) {
            i5 = ((InterceptorProvider)((Object)ep.getService().getDataBinding())).getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by databinding: " + i5);
            }
            if (i4 == null) {
                i4 = i5;
                i5 = null;
            }
        }
        PhaseInterceptorChain chain2 = i5 != null ? this.chainCache.get(bus.getExtension(PhaseManager.class).getOutPhases(), i1, i2, i3, i4, i5) : (i4 != null ? this.chainCache.get(bus.getExtension(PhaseManager.class).getOutPhases(), i1, i2, i3, i4) : this.chainCache.get(bus.getExtension(PhaseManager.class).getOutPhases(), i1, i2, i3));
        OutgoingChainInterceptor.modifyChain(chain2, ex2);
        chain2.setFaultObserver(ep.getOutFaultObserver());
        return chain2;
    }
}

