/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class PrettyLoggingOutInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(PrettyLoggingOutInterceptor.class);
    private PrintWriter writer;

    public PrettyLoggingOutInterceptor(PrintWriter w) {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
        this.writer = w;
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os2 = message.getContent(OutputStream.class);
        if (os2 == null) {
            return;
        }
        if (!LOG.isLoggable(Level.ALL)) {
            return;
        }
        CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os2);
        message.setContent(OutputStream.class, newOut);
        newOut.registerCallback(new LoggingCallback());
    }

    public class LoggingCallback
    implements CachedOutputStreamCallback {
        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            try {
                Transformer serializer = XMLUtils.newTransformer(2);
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                if (PrettyLoggingOutInterceptor.this.writer != null) {
                    serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(PrettyLoggingOutInterceptor.this.writer));
                    PrettyLoggingOutInterceptor.this.writer.close();
                } else if (LOG.isLoggable(Level.INFO)) {
                    StringWriter swriter = new StringWriter();
                    serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
                    LOG.info(swriter.toString());
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

