/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInvokerInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ServiceInvokerInterceptor() {
        super("invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(final Message message) {
        final Exchange exchange = message.getExchange();
        Endpoint endpoint = exchange.get(Endpoint.class);
        Service service = endpoint.getService();
        final Invoker invoker = service.getInvoker();
        Runnable invocation = new Runnable(){

            public void run() {
                Exchange runableEx = message.getExchange();
                Object result2 = invoker.invoke(runableEx, ServiceInvokerInterceptor.this.getInvokee(message));
                if (!exchange.isOneWay()) {
                    Endpoint ep = exchange.get(Endpoint.class);
                    Message outMessage = runableEx.getOutMessage();
                    if (outMessage == null) {
                        outMessage = new MessageImpl();
                        outMessage.setExchange(exchange);
                        outMessage = ep.getBinding().createMessage(outMessage);
                        exchange.setOutMessage(outMessage);
                    }
                    ServiceInvokerInterceptor.this.copyJaxwsProperties(message, outMessage);
                    if (result2 != null) {
                        MessageContentsList resList = null;
                        if (result2 instanceof MessageContentsList) {
                            resList = (MessageContentsList)result2;
                        } else if (result2 instanceof List) {
                            resList = new MessageContentsList((List)result2);
                        } else if (result2.getClass().isArray()) {
                            resList = new MessageContentsList((Object[])result2);
                        } else {
                            outMessage.setContent(Object.class, result2);
                        }
                        if (resList != null) {
                            outMessage.setContent(List.class, resList);
                        }
                    }
                }
            }
        };
        Executor executor = this.getExecutor(endpoint);
        if (exchange.get(Executor.class) == executor) {
            invocation.run();
        } else {
            FutureTask<Object> o;
            exchange.put(Executor.class, executor);
            FutureTask<Object> futureTask = o = new FutureTask<Object>(invocation, null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    super.done();
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        this.notifyAll();
                    }
                }
            };
            synchronized (futureTask) {
                executor.execute(o);
                if (!o.isDone()) {
                    try {
                        o.wait();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
                try {
                    o.get();
                }
                catch (InterruptedException e3) {
                    throw new Fault(e3);
                }
                catch (ExecutionException e4) {
                    if (e4.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e4.getCause();
                    }
                    throw new Fault(e4.getCause());
                }
            }
        }
    }

    private Object getInvokee(Message message) {
        Object invokee = message.getContent(List.class);
        if (invokee == null) {
            invokee = message.getContent(Object.class);
        }
        return invokee;
    }

    private Executor getExecutor(Endpoint endpoint) {
        return endpoint.getService().getExecutor();
    }

    private void copyJaxwsProperties(Message inMsg, Message outMsg) {
        outMsg.put("javax.xml.ws.wsdl.operation", inMsg.get("javax.xml.ws.wsdl.operation"));
        outMsg.put("javax.xml.ws.wsdl.service", inMsg.get("javax.xml.ws.wsdl.service"));
        outMsg.put("javax.xml.ws.wsdl.interface", inMsg.get("javax.xml.ws.wsdl.interface"));
        outMsg.put("javax.xml.ws.wsdl.port", inMsg.get("javax.xml.ws.wsdl.port"));
        outMsg.put("javax.xml.ws.wsdl.description", inMsg.get("javax.xml.ws.wsdl.description"));
    }
}

