/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.transform;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.interceptor.StaxOutEndingInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final String OUTPUT_STREAM_HOLDER = TransformOutInterceptor.class.getName() + ".outputstream";
    private static final StaxOutEndingInterceptor ENDING = new StaxOutEndingInterceptor(OUTPUT_STREAM_HOLDER);
    private Map<String, String> outElementsMap;
    private Map<String, String> outAppendMap;
    private List<String> outDropElements;
    private boolean attributesToElements;
    private String contextPropertyName;

    public TransformOutInterceptor() {
        super("pre-stream");
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    @Override
    public void handleFault(Message message) {
        super.handleFault(message);
        OutputStream os2 = (OutputStream)message.get(OUTPUT_STREAM_HOLDER);
        if (os2 != null) {
            message.setContent(OutputStream.class, os2);
        }
    }

    @Override
    public void handleMessage(Message message) {
        OutputStream out;
        if (!this.isHttpVerbSupported(message)) {
            return;
        }
        if (this.contextPropertyName != null && !MessageUtils.getContextualBoolean(message.getExchange().getInMessage(), this.contextPropertyName, false)) {
            return;
        }
        XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
        XMLStreamWriter transformWriter = this.createTransformWriterIfNeeded(writer, out = message.getContent(OutputStream.class));
        if (transformWriter != null) {
            message.setContent(XMLStreamWriter.class, transformWriter);
            if (MessageUtils.isRequestor(message)) {
                message.removeContent(OutputStream.class);
                message.put(OUTPUT_STREAM_HOLDER, out);
                message.put("disable.outputstream.optimization", Boolean.TRUE);
                message.getInterceptorChain().add(ENDING);
            }
        }
    }

    protected XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os2) {
        return TransformUtils.createTransformWriterIfNeeded(writer, os2, this.outElementsMap, this.outDropElements, this.outAppendMap, this.attributesToElements);
    }

    public void setOutTransformElements(Map<String, String> outElements) {
        this.outElementsMap = outElements;
    }

    public void setOutAppendElements(Map<String, String> map3) {
        this.outAppendMap = map3;
    }

    public void setOutDropElements(List<String> dropElementsSet) {
        this.outDropElements = dropElementsSet;
    }

    public void setAttributesToElements(boolean value2) {
        this.attributesToElements = value2;
    }

    protected boolean isHttpVerbSupported(Message message) {
        return !this.isRequestor(message) || !this.isGET(message);
    }

    public void setContextPropertyName(String propertyName) {
        this.contextPropertyName = propertyName;
    }
}

