/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractWrappedOutputStream
extends OutputStream {
    protected OutputStream wrappedStream;
    protected boolean written;

    protected AbstractWrappedOutputStream() {
    }

    public void write(byte[] b, int off, int len2) throws IOException {
        if (!this.written) {
            this.onFirstWrite();
            this.written = true;
        }
        if (this.wrappedStream != null) {
            this.wrappedStream.write(b, off, len2);
        }
    }

    protected void onFirstWrite() throws IOException {
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (!this.written) {
            this.onFirstWrite();
            this.written = true;
        }
        if (this.wrappedStream != null) {
            this.wrappedStream.write(b);
        }
    }

    public void close() throws IOException {
        if (this.wrappedStream != null) {
            this.wrappedStream.close();
        }
    }

    public void flush() throws IOException {
        if (this.written && this.wrappedStream != null) {
            this.wrappedStream.flush();
        }
    }
}

