/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedOutputStream
extends OutputStream {
    private static final File DEFAULT_TEMP_DIR;
    private static final int DEFAULT_THRESHOLD;
    protected boolean outputLocked;
    protected OutputStream currentStream;
    private long threshold = DEFAULT_THRESHOLD;
    private int totalLength;
    private boolean inmem;
    private boolean tempFileFailed;
    private File tempFile;
    private File outputDir = DEFAULT_TEMP_DIR;
    private boolean allowDeleteOfFile = true;
    private List<CachedOutputStreamCallback> callbacks;
    private List<Object> streamList = new ArrayList<Object>();

    public CachedOutputStream(PipedInputStream stream2) throws IOException {
        this.currentStream = new PipedOutputStream(stream2);
        this.inmem = true;
    }

    public CachedOutputStream() {
        this.currentStream = new LoadingByteArrayOutputStream(2048);
        this.inmem = true;
    }

    public CachedOutputStream(long threshold) {
        this.threshold = threshold;
        this.currentStream = new LoadingByteArrayOutputStream(2048);
        this.inmem = true;
    }

    public void holdTempFile() {
        this.allowDeleteOfFile = false;
    }

    public void releaseTempFileHold() {
        this.allowDeleteOfFile = true;
    }

    public void registerCallback(CachedOutputStreamCallback cb) {
        if (null == this.callbacks) {
            this.callbacks = new ArrayList<CachedOutputStreamCallback>();
        }
        this.callbacks.add(cb);
    }

    public void deregisterCallback(CachedOutputStreamCallback cb) {
        if (null != this.callbacks) {
            this.callbacks.remove(cb);
        }
    }

    public List<CachedOutputStreamCallback> getCallbacks() {
        return this.callbacks == null ? null : Collections.unmodifiableList(this.callbacks);
    }

    protected void doFlush() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onFlush(this);
            }
        }
        this.doFlush();
    }

    protected void doClose() throws IOException {
    }

    protected void postClose() throws IOException {
    }

    public void lockOutputStream() throws IOException {
        if (this.outputLocked) {
            return;
        }
        this.currentStream.flush();
        this.outputLocked = true;
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.doClose();
        this.streamList.remove(this.currentStream);
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        this.outputLocked = true;
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.doClose();
        this.currentStream.close();
        this.maybeDeleteTempFile(this.currentStream);
        this.postClose();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedOutputStream) {
            return this.currentStream.equals(((CachedOutputStream)obj).currentStream);
        }
        return this.currentStream.equals(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetOut(OutputStream out, boolean copyOldContent) throws IOException {
        if (out == null) {
            out = new ByteArrayOutputStream();
        }
        if (this.currentStream instanceof CachedOutputStream) {
            CachedOutputStream ac = (CachedOutputStream)this.currentStream;
            InputStream in2 = ac.getInputStream();
            IOUtils.copyAndCloseInput(in2, out);
        } else if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.currentStream;
                if (copyOldContent && byteOut.size() > 0) {
                    byteOut.writeTo(out);
                }
            } else {
                if (!(this.currentStream instanceof PipedOutputStream)) throw new IOException("Unknown format of currentStream");
                PipedOutputStream pipeOut = (PipedOutputStream)this.currentStream;
                IOUtils.copyAndCloseInput(new PipedInputStream(pipeOut), out);
            }
        } else {
            this.currentStream.close();
            if (copyOldContent) {
                FileInputStream fin = new FileInputStream(this.tempFile);
                IOUtils.copyAndCloseInput(fin, out);
            }
            this.streamList.remove(this.currentStream);
            this.tempFile.delete();
            this.tempFile = null;
            this.inmem = true;
        }
        this.currentStream = out;
        this.outputLocked = false;
    }

    public static void copyStream(InputStream in2, OutputStream out, int bufferSize) throws IOException {
        IOUtils.copyAndCloseInput(in2, out, bufferSize);
    }

    public int size() {
        return this.totalLength;
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.currentStream).toByteArray();
            }
            throw new IOException("Unknown format of currentStream");
        }
        FileInputStream fin = new FileInputStream(this.tempFile);
        return IOUtils.readBytesFromStream(fin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(OutputStream out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            ((ByteArrayOutputStream)this.currentStream).writeTo(out);
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            IOUtils.copyAndCloseInput(fin, out);
        }
    }

    public void writeCacheTo(StringBuilder out, int limit) throws IOException {
        this.writeCacheTo(out, "UTF-8", limit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, String charsetName, int limit) throws IOException {
        this.flush();
        if (this.totalLength < limit || limit == -1) {
            this.writeCacheTo(out);
            return;
        }
        int count2 = 0;
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes2 = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(IOUtils.newStringFromBytes(bytes2, charsetName, 0, limit));
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            byte[] bytes3 = new byte[1024];
            int x = fin.read(bytes3);
            while (x != -1) {
                if (count2 + x > limit) {
                    x = limit - count2;
                }
                out.append(IOUtils.newStringFromBytes(bytes3, charsetName, 0, x));
                if ((count2 += x) >= limit) {
                    x = -1;
                    continue;
                }
                x = fin.read(bytes3);
            }
            fin.close();
        }
    }

    public void writeCacheTo(StringBuilder out) throws IOException {
        this.writeCacheTo(out, "UTF-8");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, String charsetName) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes2 = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(IOUtils.newStringFromBytes(bytes2, charsetName));
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            byte[] bytes3 = new byte[1024];
            int x = fin.read(bytes3);
            while (x != -1) {
                out.append(IOUtils.newStringFromBytes(bytes3, charsetName, 0, x));
                x = fin.read(bytes3);
            }
            fin.close();
        }
    }

    public OutputStream getOut() {
        return this.currentStream;
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(CachedOutputStream.class.getName()).append(" Content: ");
        try {
            this.writeCacheTo(builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.append("]").toString();
    }

    protected void onWrite() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len2) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += len2;
            if (this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
                this.createFileOutputStream();
            }
            this.currentStream.write(b, off, len2);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += b.length;
            if (this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
                this.createFileOutputStream();
            }
            this.currentStream.write(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            ++this.totalLength;
            if (this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
                this.createFileOutputStream();
            }
            this.currentStream.write(b);
        }
    }

    private void createFileOutputStream() throws IOException {
        if (this.tempFileFailed) {
            return;
        }
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        try {
            this.tempFile = this.outputDir == null ? FileUtils.createTempFile("cos", "tmp") : FileUtils.createTempFile("cos", "tmp", this.outputDir, false);
            this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            bout.writeTo(this.currentStream);
            this.inmem = false;
            this.streamList.add(this.currentStream);
        }
        catch (Exception ex2) {
            this.tempFileFailed = true;
            this.tempFile = null;
            this.inmem = true;
            this.currentStream = bout;
        }
    }

    public File getTempFile() {
        return this.tempFile != null && this.tempFile.exists() ? this.tempFile : null;
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof LoadingByteArrayOutputStream) {
                return ((LoadingByteArrayOutputStream)this.currentStream).createInputStream();
            }
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            if (this.currentStream instanceof PipedOutputStream) {
                return new PipedInputStream((PipedOutputStream)this.currentStream);
            }
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile){

                public void close() throws IOException {
                    super.close();
                    CachedOutputStream.this.maybeDeleteTempFile(this);
                }
            };
            this.streamList.add(fileInputStream);
            return fileInputStream;
        }
        catch (FileNotFoundException e2) {
            throw new IOException("Cached file was deleted, " + e2.toString());
        }
    }

    private void maybeDeleteTempFile(Object stream2) {
        this.streamList.remove(stream2);
        if (!this.inmem && this.tempFile != null && this.streamList.isEmpty() && this.allowDeleteOfFile) {
            if (this.currentStream != null) {
                try {
                    this.currentStream.close();
                    this.postClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.tempFile.delete();
            this.tempFile = null;
            this.currentStream = new LoadingByteArrayOutputStream(1024);
            this.inmem = true;
        }
    }

    public void setOutputDir(File outputDir) throws IOException {
        this.outputDir = outputDir;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    static {
        File f2;
        String s2 = System.getProperty("org.apache.cxf.io.CachedOutputStream.Threshold", "-1");
        int i = Integer.parseInt(s2);
        if (i <= 0) {
            i = 65536;
        }
        DEFAULT_THRESHOLD = i;
        s2 = System.getProperty("org.apache.cxf.io.CachedOutputStream.OutputDirectory");
        DEFAULT_TEMP_DIR = s2 != null ? ((f2 = new File(s2)).exists() && f2.isDirectory() ? f2 : null) : null;
    }
}

