/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.CachedClass;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBContextCache {
    private static final Map<Set<Class<?>>, CachedContextAndSchemas> JAXBCONTEXT_CACHE = new CacheMap();
    private static final Map<Package, CachedClass> OBJECT_FACTORY_CACHE = new CacheMap<Package, CachedClass>();

    private JAXBContextCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<Object, Object> map3 = JAXBCONTEXT_CACHE;
        synchronized (map3) {
            JAXBCONTEXT_CACHE.clear();
        }
        map3 = OBJECT_FACTORY_CACHE;
        synchronized (map3) {
            OBJECT_FACTORY_CACHE.clear();
        }
    }

    public static void scanPackages(Set<Class<?>> classes2) {
        JAXBUtils.scanPackages(classes2, OBJECT_FACTORY_CACHE);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(Class<?> cls) throws JAXBException {
        HashSet classes2 = new HashSet();
        classes2.add(cls);
        JAXBContextCache.scanPackages(classes2);
        return JAXBContextCache.getCachedContextAndSchemas(classes2, null, null, null, false);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(String pkg, Map<String, Object> props, ClassLoader loader) throws JAXBException {
        HashSet classes2 = new HashSet();
        JAXBContextCache.addPackage(classes2, pkg, loader);
        return JAXBContextCache.getCachedContextAndSchemas(classes2, null, props, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedContextAndSchemas getCachedContextAndSchemas(Set<Class<?>> classes2, String defaultNs, Map<String, Object> props, Collection<Object> typeRefs, boolean exact) throws JAXBException {
        Map<Set<Class<?>>, CachedContextAndSchemas> map3;
        for (Class<?> clz : classes2) {
            if (!clz.getName().endsWith("ObjectFactory") || !JAXBContextCache.checkObjectFactoryNamespaces(clz)) continue;
            defaultNs = null;
        }
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        if (defaultNs != null) {
            map4.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        if (props != null) {
            map4.putAll(props);
        }
        CachedContextAndSchemas cachedContextAndSchemas = null;
        JAXBContext context = null;
        if (typeRefs == null || typeRefs.isEmpty()) {
            map3 = JAXBCONTEXT_CACHE;
            synchronized (map3) {
                if (exact) {
                    cachedContextAndSchemas = JAXBCONTEXT_CACHE.get(classes2);
                } else {
                    for (Map.Entry<Set<Class<?>>, CachedContextAndSchemas> k : JAXBCONTEXT_CACHE.entrySet()) {
                        Set<Class<Class<?>>> key = k.getKey();
                        if (key == null || !key.containsAll(classes2)) continue;
                        cachedContextAndSchemas = k.getValue();
                        break;
                    }
                }
            }
        }
        if (cachedContextAndSchemas != null && (context = cachedContextAndSchemas.getContext()) == null) {
            JAXBCONTEXT_CACHE.remove(cachedContextAndSchemas.getClasses());
            cachedContextAndSchemas = null;
        }
        if (context == null) {
            block21: {
                try {
                    context = JAXBContextCache.createContext(classes2, map4, typeRefs);
                }
                catch (JAXBException ex2) {
                    boolean added = JAXBContextCache.addJaxbObjectFactory(ex2, classes2);
                    while (cachedContextAndSchemas == null && added) {
                        try {
                            context = JAXBContext.newInstance((Class[])classes2.toArray(new Class[classes2.size()]), null);
                        }
                        catch (JAXBException e2) {
                            throw ex2;
                        }
                    }
                    if (context != null) break block21;
                    throw ex2;
                }
            }
            cachedContextAndSchemas = new CachedContextAndSchemas(context, classes2);
            map3 = JAXBCONTEXT_CACHE;
            synchronized (map3) {
                if (typeRefs == null || typeRefs.isEmpty()) {
                    JAXBCONTEXT_CACHE.put(classes2, cachedContextAndSchemas);
                }
            }
        }
        return cachedContextAndSchemas;
    }

    private static boolean checkObjectFactoryNamespaces(Class<?> clz) {
        for (Method meth : clz.getMethods()) {
            XmlElementDecl decl = meth.getAnnotation(XmlElementDecl.class);
            if (decl == null || !XmlElementDecl.GLOBAL.class.equals((Object)decl.scope()) || !StringUtils.isEmpty(decl.namespace())) continue;
            return true;
        }
        return false;
    }

    private static JAXBContext createContext(Set<Class<?>> classes2, Map<String, Object> map3, Collection<Object> typeRefs) throws JAXBException {
        JAXBContext ctx;
        if (typeRefs != null && !typeRefs.isEmpty()) {
            Class<?> fact = null;
            String pfx = "com.sun.xml.bind.";
            try {
                fact = ClassLoaderUtils.loadClass("com.sun.xml.bind.v2.ContextFactory", JAXBContextCache.class);
            }
            catch (Throwable t2) {
                try {
                    fact = ClassLoaderUtils.loadClass("com.sun.xml.internal.bind.v2.ContextFactory", JAXBContextCache.class);
                    pfx = "com.sun.xml.internal.bind.";
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (fact != null) {
                for (Method m : fact.getMethods()) {
                    if (!"createContext".equals(m.getName()) || m.getParameterTypes().length != 9) continue;
                    try {
                        return (JAXBContext)m.invoke(null, classes2.toArray(new Class[classes2.size()]), typeRefs, map3.get(pfx + "subclassReplacements"), map3.get(pfx + "defaultNamespaceRemap"), map3.get(pfx + "c14n") == null ? Boolean.FALSE : map3.get(pfx + "c14n"), map3.get(pfx + "v2.model.annotation.RuntimeAnnotationReader"), map3.get(pfx + "XmlAccessorFactory") == null ? Boolean.FALSE : map3.get(pfx + "XmlAccessorFactory"), map3.get(pfx + "treatEverythingNillable") == null ? Boolean.FALSE : map3.get(pfx + "treatEverythingNillable"), map3.get("retainReferenceToInfo") == null ? Boolean.FALSE : map3.get("retainReferenceToInfo"));
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            ctx = JAXBContext.newInstance((Class[])classes2.toArray(new Class[classes2.size()]), map3);
        }
        catch (JAXBException ex2) {
            if (map3.containsKey("com.sun.xml.bind.defaultNamespaceRemap") && ex2.getMessage().contains("com.sun.xml.bind.defaultNamespaceRemap")) {
                map3.put("com.sun.xml.internal.bind.defaultNamespaceRemap", map3.remove("com.sun.xml.bind.defaultNamespaceRemap"));
                ctx = JAXBContext.newInstance((Class[])classes2.toArray(new Class[classes2.size()]), map3);
            }
            throw ex2;
        }
        return ctx;
    }

    private static boolean addJaxbObjectFactory(JAXBException e1, Set<Class<?>> classes2) {
        boolean added = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        e1.printStackTrace(pout);
        String str = new String(bout.toByteArray());
        Pattern pattern = Pattern.compile("(?<=There's\\sno\\sObjectFactory\\swith\\san\\s@XmlElementDecl\\sfor\\sthe\\selement\\s\\{)\\S*(?=\\})");
        Matcher matcher2 = pattern.matcher(str);
        while (matcher2.find()) {
            String pkgName = JAXBUtils.namespaceURIToPackage(matcher2.group());
            try {
                Class<?> clz = JAXBContextCache.class.getClassLoader().loadClass(pkgName + "." + "ObjectFactory");
                if (classes2.contains(clz)) continue;
                classes2.add(clz);
                added = true;
            }
            catch (ClassNotFoundException e2) {}
        }
        return added;
    }

    public static void addPackage(Set<Class<?>> classes2, String pkg, ClassLoader loader) {
        try {
            classes2.add(Class.forName(pkg + ".ObjectFactory", false, loader));
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            InputStream ins2 = loader.getResourceAsStream("/" + pkg.replace('.', '/') + "/jaxb.index");
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(ins2, "UTF-8"));
            if (!StringUtils.isEmpty(pkg)) {
                pkg = pkg + ".";
            }
            String line = reader2.readLine();
            while (line != null) {
                if ((line = line.trim()).indexOf("#") != -1) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (!StringUtils.isEmpty(line)) {
                    try {
                        Class<?> ncls = Class.forName(pkg + line, false, loader);
                        classes2.add(ncls);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                line = reader2.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CachedContextAndSchemas {
        private WeakReference<JAXBContext> context;
        private WeakReference<Set<Class<?>>> classes;
        private Collection<DOMSource> schemas;

        CachedContextAndSchemas(JAXBContext context, Set<Class<?>> classes2) {
            this.context = new WeakReference<JAXBContext>(context);
            this.classes = new WeakReference(classes2);
        }

        public JAXBContext getContext() {
            return (JAXBContext)this.context.get();
        }

        public Set<Class<?>> getClasses() {
            return (Set)this.classes.get();
        }

        public void setClasses(Set<Class<?>> cls) {
            this.classes = new WeakReference(cls);
        }

        public Collection<DOMSource> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            this.schemas = schemas;
        }
    }
}

