/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JAXBContextInitializer
extends ServiceModelVisitor {
    private Set<Class<?>> classes;
    private Collection<Object> typeReferences;

    public JAXBContextInitializer(ServiceInfo serviceInfo, Set<Class<?>> classes2, Collection<Object> typeReferences) {
        super(serviceInfo);
        this.classes = classes2;
        this.typeReferences = typeReferences;
    }

    @Override
    public void begin(MessagePartInfo part) {
        boolean isFromWrapper;
        Class<?> clazz2 = part.getTypeClass();
        if (clazz2 == null) {
            return;
        }
        if (Exception.class.isAssignableFrom(clazz2)) {
            part.setProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION", Boolean.TRUE);
        }
        if ((isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped()) && !Boolean.TRUE.equals(part.getProperty("messagepart.isheader"))) {
            UnwrappedOperationInfo uop = (UnwrappedOperationInfo)part.getMessageInfo().getOperation();
            OperationInfo op = uop.getWrappedOperation();
            MessageInfo inf = null;
            if (uop.getInput() == part.getMessageInfo()) {
                inf = op.getInput();
            } else if (uop.getOutput() == part.getMessageInfo()) {
                inf = op.getOutput();
            }
            if (inf != null && inf.getMessagePart(0).getTypeClass() != null) {
                return;
            }
        }
        if (isFromWrapper && clazz2.isArray() && !Byte.TYPE.equals(clazz2.getComponentType())) {
            clazz2 = clazz2.getComponentType();
        }
        Annotation[] a2 = (Annotation[])part.getProperty("parameter.annotations");
        this.checkForAdapter(clazz2, a2);
        Class<?> genericType = (Class<?>)part.getProperty("generic.type");
        if (genericType != null) {
            boolean isList = Collection.class.isAssignableFrom(clazz2);
            if (isFromWrapper) {
                if (genericType instanceof Class && ((Class)genericType).isArray()) {
                    Class cl2 = genericType;
                    if (cl2.isArray() && !Byte.TYPE.equals(cl2.getComponentType())) {
                        genericType = cl2.getComponentType();
                    }
                    this.addType(genericType);
                } else if (!isList) {
                    this.addType(genericType);
                }
            } else {
                this.addType(genericType, true);
            }
            if (isList && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)((Object)genericType);
                if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                    Class<?> arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                    clazz2 = arrayCls;
                    part.setTypeClass(clazz2);
                    if (isFromWrapper) {
                        this.addType(clazz2.getComponentType(), true);
                    }
                } else if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)pt.getActualTypeArguments()[0];
                    gat.getGenericComponentType();
                    Class<?> arrayCls = Array.newInstance((Class)gat.getGenericComponentType(), 0).getClass();
                    clazz2 = Array.newInstance(arrayCls, 0).getClass();
                    part.setTypeClass(clazz2);
                    if (isFromWrapper) {
                        this.addType(clazz2.getComponentType(), true);
                    }
                }
            }
            if (isFromWrapper && isList) {
                clazz2 = null;
            }
        }
        if (clazz2 != null) {
            if (!isFromWrapper && clazz2.getAnnotation(XmlRootElement.class) == null && clazz2.getAnnotation(XmlType.class) != null && StringUtils.isEmpty(clazz2.getAnnotation(XmlType.class).name())) {
                this.createTypeReference(part.getName(), clazz2);
            }
            this.addClass(clazz2);
        }
    }

    private void createTypeReference(QName n, Class<?> cls) {
        Class<?> refClass2 = null;
        try {
            refClass2 = ClassLoaderUtils.loadClass("com.sun.xml.bind.api.TypeReference", this.getClass());
        }
        catch (Throwable ex2) {
            try {
                refClass2 = ClassLoaderUtils.loadClass("com.sun.xml.internal.bind.api.TypeReference", this.getClass());
            }
            catch (Throwable ex22) {
                // empty catch block
            }
        }
        if (refClass2 != null) {
            try {
                Object o = refClass2.getConstructor(QName.class, Type.class, new Annotation[0].getClass()).newInstance(n, cls, new Annotation[0]);
                this.typeReferences.add(o);
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
    }

    private void checkForAdapter(Class<?> clazz2, Annotation[] anns) {
        XmlJavaTypeAdapter xjta;
        if (anns != null) {
            for (Annotation a2 : anns) {
                if (!XmlJavaTypeAdapter.class.isAssignableFrom(a2.annotationType())) continue;
                this.inspectTypeAdapter(((XmlJavaTypeAdapter)a2).value());
            }
        }
        if ((xjta = clazz2.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
            this.inspectTypeAdapter(xjta.value());
        }
    }

    private void addType(Type cls) {
        this.addType(cls, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addType(Type cls, boolean allowArray) {
        if (cls instanceof Class) {
            if (((Class)cls).isArray() && !allowArray) {
                this.addClass(((Class)cls).getComponentType());
                return;
            } else {
                this.addClass((Class)cls);
            }
            return;
        } else if (cls instanceof ParameterizedType) {
            this.addType(((ParameterizedType)cls).getRawType());
            for (Type t2 : ((ParameterizedType)cls).getActualTypeArguments()) {
                this.addType(t2);
            }
            return;
        } else if (cls instanceof GenericArrayType) {
            Class ct;
            GenericArrayType gt = (GenericArrayType)cls;
            Type componentType = gt.getGenericComponentType();
            if (componentType instanceof Class) {
                ct = (Class)componentType;
            } else {
                TypeVariable tv = (TypeVariable)componentType;
                Type[] bounds = tv.getBounds();
                if (bounds == null || bounds.length != 1) throw new IllegalArgumentException("Unable to determine type for: " + tv);
                if (!(bounds[0] instanceof Class)) throw new IllegalArgumentException("Unable to determine type for: " + tv);
                ct = (Class)bounds[0];
            }
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
            return;
        } else if (cls instanceof WildcardType) {
            for (Type t2 : ((WildcardType)cls).getUpperBounds()) {
                this.addType(t2);
            }
            for (Type t2 : ((WildcardType)cls).getLowerBounds()) {
                this.addType(t2);
            }
            return;
        } else {
            if (!(cls instanceof TypeVariable)) return;
            for (Type t3 : ((TypeVariable)cls).getBounds()) {
                this.addType(t3);
            }
        }
    }

    private void addClass(Class<?> cls) {
        if (Throwable.class.isAssignableFrom(cls)) {
            if (!Throwable.class.equals(cls) && !Exception.class.equals(cls)) {
                this.walkReferences(cls);
            }
            this.addClass(String.class);
        } else if (null != (cls = JAXBUtils.getValidClass(cls))) {
            if (cls.getSuperclass() != null) {
                this.addClass(cls.getSuperclass());
            }
            if (cls.isInterface()) {
                XmlJavaTypeAdapter xjta;
                XmlSeeAlso xsa = cls.getAnnotation(XmlSeeAlso.class);
                if (xsa != null) {
                    for (Class c2 : xsa.value()) {
                        this.addClass(c2);
                    }
                }
                if ((xjta = cls.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
                    Class c2 = xjta.value();
                    this.inspectTypeAdapter(c2);
                }
            } else {
                if (this.classes.contains(cls)) {
                    return;
                }
                this.classes.add(cls);
                this.walkReferences(cls);
            }
        }
    }

    private void inspectTypeAdapter(Class<? extends XmlAdapter> aclass) {
        Class<? extends XmlAdapter> c2;
        Type sp2 = c2.getGenericSuperclass();
        for (c2 = aclass; !XmlAdapter.class.equals(c2) && c2 != null; c2 = c2.getSuperclass()) {
            sp2 = c2.getGenericSuperclass();
        }
        if (sp2 instanceof ParameterizedType) {
            this.addType(((ParameterizedType)sp2).getActualTypeArguments()[0]);
        }
    }

    private void walkReferences(Class<?> cls) {
        XmlAccessType accessType;
        if (cls == null) {
            return;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.")) {
            return;
        }
        XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
        if (accessorType == null && cls.getPackage() != null) {
            accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
        }
        XmlAccessType xmlAccessType = accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType != XmlAccessType.PROPERTY) {
            Field[] fields = cls.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                if (!JAXBContextInitializer.isFieldAccepted((Field)accessibleObject, accessType)) continue;
                this.addType(((Field)accessibleObject).getGenericType());
            }
            this.walkReferences(cls.getSuperclass());
        }
        if (accessType != XmlAccessType.FIELD) {
            Method[] methods2 = cls.getDeclaredMethods();
            for (AccessibleObject accessibleObject : methods2) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                this.addType(((Method)accessibleObject).getGenericReturnType());
                for (Type t2 : ((Method)accessibleObject).getGenericParameterTypes()) {
                    this.addType(t2);
                }
            }
        }
    }

    static boolean isFieldAccepted(Field field2, XmlAccessType accessType) {
        if (Modifier.isStatic(field2.getModifiers()) || field2.isAnnotationPresent(XmlTransient.class)) {
            return false;
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER && !Modifier.isPublic(field2.getModifiers())) {
            return false;
        }
        if (field2.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return false;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.PROPERTY) {
            return JAXBContextInitializer.checkJaxbAnnotation(field2.getAnnotations());
        }
        return true;
    }

    static boolean isMethodAccepted(Method method, XmlAccessType accessType) {
        boolean isPropGetter;
        if (Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(XmlTransient.class) || !Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType() == Void.class || method.getParameterTypes().length != 0 || method.getDeclaringClass().equals(Throwable.class)) {
            return false;
        }
        boolean bl = isPropGetter = method.getName().startsWith("get") || method.getName().startsWith("is");
        if (!isPropGetter || method.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return false;
        }
        int beginIndex = 3;
        if (method.getName().startsWith("is")) {
            beginIndex = 2;
        }
        try {
            method.getDeclaringClass().getMethod("set" + method.getName().substring(beginIndex), method.getReturnType());
        }
        catch (Exception e2) {
            return false;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.FIELD) {
            return JAXBContextInitializer.checkJaxbAnnotation(method.getAnnotations());
        }
        return true;
    }

    private static boolean checkJaxbAnnotation(Annotation[] annotations2) {
        Package jaxbAnnotationsPackage = XmlElement.class.getPackage();
        for (Annotation annotation2 : annotations2) {
            if (annotation2.annotationType().getPackage() != jaxbAnnotationsPackage) continue;
            return true;
        }
        return false;
    }
}

