/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.staxutils.W3CNamespaceContext;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBEncoderDecoder {
    private static final Logger LOG = LogUtils.getLogger(JAXBEncoderDecoder.class);

    private JAXBEncoderDecoder() {
    }

    public static void marshall(Marshaller marshaller, Object elValue, MessagePartInfo part, Object source) {
        try {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
        }
        catch (PropertyException e2) {
            // empty catch block
        }
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz2 = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            Object mObj = elValue;
            QName elName = null;
            if (part != null) {
                elName = part.getConcreteName();
            }
            if (null != elName) {
                if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
                    XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
                    if (mObj.getClass().isArray() && el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                        mObj = Arrays.asList(mObj);
                        JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, cls, mObj));
                    } else if (part.getMessageInfo().getOperation().isUnwrapped() && (mObj.getClass().isArray() || mObj instanceof List) && el.getMaxOccurs() != 1L) {
                        JAXBEncoderDecoder.writeArrayObject(marshaller, source, elName, mObj);
                    } else {
                        JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, cls, mObj));
                    }
                } else if (byte[].class == cls && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
                    mObj = new HexBinaryAdapter().marshal((byte[])mObj);
                    JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, String.class, mObj));
                } else if (mObj instanceof JAXBElement) {
                    JAXBEncoderDecoder.writeObject(marshaller, source, mObj);
                } else if (marshaller.getSchema() != null) {
                    JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, Object.class, mObj));
                } else {
                    JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(elName, cls, mObj));
                }
            } else {
                JAXBEncoderDecoder.writeObject(marshaller, source, mObj);
            }
        }
        catch (Fault ex2) {
            throw (Fault)ex2.fillInStackTrace();
        }
        catch (Exception ex3) {
            if (ex3 instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)((Object)ex3);
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, marshalEx.getLinkedException().getMessage());
                throw new Fault(faultMessage, (Throwable)ex3);
            }
            throw new Fault(new Message("MARSHAL_ERROR", LOG, ex3.getMessage()), (Throwable)ex3);
        }
    }

    public static void marshalWithBridge(QName qname, Class<?> cls, Annotation[] anns, Set<Class<?>> ctxClasses, Object elValue, Object source, AttachmentMarshaller am) {
        block6: {
            try {
                JAXBUtils.BridgeWrapper bridge2 = JAXBUtils.createBridge(ctxClasses, qname, cls, anns);
                if (source instanceof XMLStreamWriter) {
                    bridge2.marshal(elValue, (XMLStreamWriter)source, am);
                    break block6;
                }
                if (source instanceof OutputStream) {
                    StringWriter sw = new StringWriter();
                    StreamResult s1 = new StreamResult(sw);
                    bridge2.marshal(elValue, s1);
                    ((OutputStream)source).write(sw.toString().getBytes());
                    break block6;
                }
                if (source instanceof Node) {
                    bridge2.marshal(elValue, (Node)source, am);
                    break block6;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
            }
            catch (Exception ex2) {
                if (ex2 instanceof MarshalException) {
                    MarshalException marshalEx = (MarshalException)((Object)ex2);
                    Message faultMessage = new Message("MARSHAL_ERROR", LOG, marshalEx.getLinkedException().getMessage());
                    throw new Fault(faultMessage, (Throwable)ex2);
                }
                throw new Fault(new Message("MARSHAL_ERROR", LOG, ex2.getMessage()), (Throwable)ex2);
            }
        }
    }

    public static Object unmarshalWithBridge(QName qname, Class<?> cls, Annotation[] anns, Set<Class<?>> ctxClasses, Object source, AttachmentUnmarshaller am) {
        try {
            JAXBUtils.BridgeWrapper bridge2 = JAXBUtils.createBridge(ctxClasses, qname, cls, anns);
            if (source instanceof XMLStreamReader) {
                return bridge2.unmarshal((XMLStreamReader)source, am);
            }
            if (source instanceof InputStream) {
                return bridge2.unmarshal((InputStream)source);
            }
            if (source instanceof Node) {
                return bridge2.unmarshal((Node)source, am);
            }
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
        }
        catch (Exception ex2) {
            if (ex2 instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)((Object)ex2);
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, marshalEx.getLinkedException().getMessage());
                throw new Fault(faultMessage, (Throwable)ex2);
            }
            throw new Fault(new Message("MARSHAL_ERROR", LOG, ex2.getMessage()), (Throwable)ex2);
        }
    }

    public static void marshallException(Marshaller marshaller, Exception elValue, MessagePartInfo part, Object source) {
        XMLStreamWriter writer = JAXBEncoderDecoder.getStreamWriter(source);
        QName qn = part.getElementQName();
        try {
            writer.writeStartElement("ns1", qn.getLocalPart(), qn.getNamespaceURI());
            Class<?> cls = part.getTypeClass();
            XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
            if (accessorType == null && cls.getPackage() != null) {
                accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
            }
            XmlAccessType accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
            String namespace = part.getElementQName().getNamespaceURI();
            SchemaInfo sch = part.getMessageInfo().getOperation().getInterface().getService().getSchema(namespace);
            if (sch != null) {
                if (!sch.isElementFormQualified()) {
                    namespace = null;
                }
            } else {
                LOG.warning("Schema associated with " + namespace + " is null");
            }
            for (Field field2 : cls.getDeclaredFields()) {
                if (!JAXBContextInitializer.isFieldAccepted(field2, accessType)) continue;
                QName fname = new QName(namespace, field2.getName());
                field2.setAccessible(true);
                if (JAXBSchemaInitializer.isArray(field2.getGenericType())) {
                    JAXBEncoderDecoder.writeArrayObject(marshaller, writer, fname, field2.get(elValue));
                    continue;
                }
                JAXBEncoderDecoder.writeObject(marshaller, writer, new JAXBElement(fname, String.class, field2.get(elValue)));
            }
            for (AccessibleObject accessibleObject : cls.getMethods()) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                int idx = ((Method)accessibleObject).getName().startsWith("get") ? 3 : 2;
                String name = ((Method)accessibleObject).getName().substring(idx);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                QName mname = new QName(namespace, name);
                if (JAXBSchemaInitializer.isArray(((Method)accessibleObject).getGenericReturnType())) {
                    JAXBEncoderDecoder.writeArrayObject(marshaller, writer, mname, ((Method)accessibleObject).invoke(elValue, new Object[0]));
                    continue;
                }
                JAXBEncoderDecoder.writeObject(marshaller, writer, new JAXBElement(mname, String.class, ((Method)accessibleObject).invoke(elValue, new Object[0])));
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (Exception e2) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, e2.getMessage()), (Throwable)e2);
        }
    }

    private static void writeArrayObject(Marshaller marshaller, Object source, QName mname, Object mObj) throws Fault, JAXBException {
        Object[] objArray;
        if (mObj == null) {
            return;
        }
        Class<?> cls = null;
        if (mObj instanceof List) {
            List l = (List)mObj;
            objArray = l.toArray(new Object[l.size()]);
            cls = null;
        } else {
            objArray = mObj;
            cls = objArray.getClass().getComponentType();
        }
        int len2 = Array.getLength(objArray);
        for (int x = 0; x < len2; ++x) {
            Object o = Array.get(objArray, x);
            JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(mname, cls == null ? o.getClass() : cls, o));
        }
    }

    public static Exception unmarshallException(Unmarshaller u, Object source, MessagePartInfo part) {
        XMLStreamReader reader2;
        if (source instanceof XMLStreamReader) {
            reader2 = (XMLStreamReader)source;
        } else if (source instanceof Element) {
            reader2 = StaxUtils.createXMLStreamReader((Element)source);
            try {
                reader2.nextTag();
            }
            catch (XMLStreamException e2) {}
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
        }
        try {
            QName qn = part.getElementQName();
            if (!qn.equals(reader2.getName())) {
                throw new Fault(new Message("ELEMENT_NAME_MISMATCH", LOG, qn, reader2.getName()));
            }
            Class<?> cls = part.getTypeClass();
            Object obj = null;
            try {
                Constructor<?> cons2 = cls.getConstructor(new Class[0]);
                obj = cons2.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException nse) {
                Constructor<?> cons3 = cls.getConstructor(String.class);
                obj = cons3.newInstance(new Object[1]);
            }
            XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
            if (accessorType == null && cls.getPackage() != null) {
                accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
            }
            XmlAccessType accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
            reader2.nextTag();
            while (reader2.getEventType() == 1) {
                QName q = reader2.getName();
                try {
                    Field f2 = cls.getField(q.getLocalPart());
                    Type type = f2.getGenericType();
                    if (!JAXBContextInitializer.isFieldAccepted(f2, accessType)) continue;
                    f2.setAccessible(true);
                    if (JAXBSchemaInitializer.isArray(type)) {
                        Class<?> compType = JAXBSchemaInitializer.getArrayComponentType(type);
                        List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, reader2, q, compType, JAXBEncoderDecoder.createList(type));
                        Object[] o = ret;
                        if (!JAXBEncoderDecoder.isList(type)) {
                            if (compType.isPrimitive()) {
                                o = Array.newInstance(compType, ret.size());
                                for (int x = 0; x < ret.size(); ++x) {
                                    Array.set(o, x, ret.get(x));
                                }
                            } else {
                                o = ret.toArray((Object[])Array.newInstance(compType, ret.size()));
                            }
                        }
                        f2.set(obj, o);
                        continue;
                    }
                    f2.set(obj, u.unmarshal(reader2, f2.getType()));
                }
                catch (NoSuchFieldException ex2) {
                    String s2 = Character.toUpperCase(q.getLocalPart().charAt(0)) + q.getLocalPart().substring(1);
                    Method m = null;
                    try {
                        m = cls.getMethod("get" + s2, new Class[0]);
                    }
                    catch (NoSuchMethodException mex) {
                        m = cls.getMethod("is" + s2, new Class[0]);
                    }
                    Type type = m.getGenericReturnType();
                    Method m2 = cls.getMethod("set" + s2, m.getReturnType());
                    if (JAXBSchemaInitializer.isArray(type)) {
                        Class<?> compType = JAXBSchemaInitializer.getArrayComponentType(type);
                        List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, reader2, q, compType, JAXBEncoderDecoder.createList(type));
                        Object[] o = ret;
                        if (!JAXBEncoderDecoder.isList(type)) {
                            if (compType.isPrimitive()) {
                                o = Array.newInstance(compType, ret.size());
                                for (int x = 0; x < ret.size(); ++x) {
                                    Array.set(o, x, ret.get(x));
                                }
                            } else {
                                o = ret.toArray((Object[])Array.newInstance(compType, ret.size()));
                            }
                        }
                        m2.invoke(obj, new Object[]{o});
                        continue;
                    }
                    Object o = JAXBEncoderDecoder.getElementValue(u.unmarshal(reader2, m.getReturnType()));
                    m2.invoke(obj, o);
                }
            }
            return obj;
        }
        catch (Exception e3) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, e3.getMessage()), (Throwable)e3);
        }
    }

    private static void writeObject(Marshaller u, Object source, Object mObj) throws Fault, JAXBException {
        if (source instanceof XMLStreamWriter) {
            u.marshal(mObj, (XMLStreamWriter)source);
        } else if (source instanceof OutputStream) {
            u.marshal(mObj, (OutputStream)source);
        } else if (source instanceof Node) {
            u.marshal(mObj, (Node)source);
        } else if (source instanceof XMLEventWriter) {
            u.marshal(mObj, (XMLEventWriter)source);
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
        }
    }

    private static XMLStreamWriter getStreamWriter(Object source) throws Fault {
        if (source instanceof XMLStreamWriter) {
            return (XMLStreamWriter)source;
        }
        if (source instanceof OutputStream) {
            return StaxUtils.createXMLStreamWriter((OutputStream)source);
        }
        if (source instanceof Node) {
            return new W3CDOMStreamWriter((Element)source);
        }
        throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
    }

    public static void marshallNullElement(Marshaller marshaller, Object source, MessagePartInfo part) {
        Class<?> clazz2 = part != null ? part.getTypeClass() : null;
        try {
            JAXBEncoderDecoder.writeObject(marshaller, source, new JAXBElement(part.getElementQName(), clazz2, null));
        }
        catch (JAXBException e2) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, e2.getMessage()), (Throwable)e2);
        }
    }

    public static Object unmarshall(Unmarshaller u, Object source, MessagePartInfo part, boolean unwrap) {
        List<Object> o;
        QName elName;
        Class<?> clazz2;
        Class<?> clazz3 = clazz2 = part != null ? part.getTypeClass() : null;
        if (clazz2 != null && Exception.class.isAssignableFrom(clazz2) && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
            return JAXBEncoderDecoder.unmarshallException(u, source, part);
        }
        QName qName = elName = part != null ? part.getConcreteName() : null;
        if (clazz2 != null && clazz2.isArray() && part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
            if (el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                Object obj = JAXBEncoderDecoder.unmarshall(u, source, elName, null, unwrap);
                if (clazz2.isArray() && obj instanceof List) {
                    return ((List)obj).toArray((Object[])Array.newInstance(clazz2.getComponentType(), ((List)obj).size()));
                }
                return obj;
            }
            if (part.getMessageInfo().getOperation().isUnwrapped() && el.getMaxOccurs() != 1L) {
                List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, source, elName, clazz2.getComponentType(), JAXBEncoderDecoder.createList(part));
                Object[] o2 = ret;
                if (!JAXBEncoderDecoder.isList(part)) {
                    if (JAXBEncoderDecoder.isSet(part)) {
                        o2 = JAXBEncoderDecoder.createSet(part, ret);
                    } else if (clazz2.getComponentType().isPrimitive()) {
                        o2 = Array.newInstance(clazz2.getComponentType(), ret.size());
                        for (int x = 0; x < ret.size(); ++x) {
                            Array.set(o2, x, ret.get(x));
                        }
                    } else {
                        o2 = ret.toArray((Object[])Array.newInstance(clazz2.getComponentType(), ret.size()));
                    }
                }
                return o2;
            }
        } else {
            if (byte[].class == clazz2 && part != null && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
                String obj = (String)JAXBEncoderDecoder.unmarshall(u, source, elName, String.class, unwrap);
                return new HexBinaryAdapter().unmarshal(obj);
            }
            if (part != null && u.getSchema() != null && !(part.getXmlSchema() instanceof XmlSchemaElement)) {
                source = JAXBEncoderDecoder.updateSourceWithXSIType(source, part.getTypeQName());
            }
        }
        if ((o = JAXBEncoderDecoder.unmarshall(u, source, elName, clazz2, unwrap)) != null && o.getClass().isArray() && JAXBEncoderDecoder.isList(part)) {
            List<Object> ret = JAXBEncoderDecoder.createList(part);
            ret.addAll(Arrays.asList((Object[])o));
            o = ret;
        }
        return o;
    }

    private static Object updateSourceWithXSIType(Object source, QName typeQName) {
        XMLStreamReader reader2;
        String type;
        if (source instanceof XMLStreamReader && typeQName != null && StringUtils.isEmpty(type = (reader2 = (XMLStreamReader)source).getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type"))) {
            source = new AddXSITypeStreamReader(reader2, typeQName);
        }
        return source;
    }

    private static Object createSet(MessagePartInfo part, List<Object> ret) {
        Collection c2;
        Type genericType = (Type)part.getProperty("generic.type");
        Class tp2 = (Class)((ParameterizedType)genericType).getRawType();
        if (tp2.isInterface()) {
            return new HashSet<Object>(ret);
        }
        try {
            c2 = CastUtils.cast((Collection)tp2.newInstance());
        }
        catch (Exception e2) {
            c2 = new HashSet();
        }
        c2.addAll(ret);
        return c2;
    }

    private static boolean isSet(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            return Set.class.isAssignableFrom((Class)tp2);
        }
        return false;
    }

    private static List<Object> createList(MessagePartInfo part) {
        Type genericType = (Type)part.getProperty("generic.type");
        return JAXBEncoderDecoder.createList(genericType);
    }

    private static List<Object> createList(Type genericType) {
        Class cls;
        Type tp2;
        if (genericType instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class && !(cls = (Class)tp2).isInterface() && List.class.isAssignableFrom(cls)) {
            try {
                return CastUtils.cast((List)cls.newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static boolean isList(Type cls) {
        return cls instanceof ParameterizedType;
    }

    private static boolean isList(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            return List.class.isAssignableFrom((Class)tp2);
        }
        return false;
    }

    public static Object unmarshall(Unmarshaller u, Object source, QName elName, Class<?> clazz2, boolean unwrap) {
        Object obj;
        block13: {
            obj = null;
            try {
                boolean unmarshalWithClass = true;
                if (clazz2 == null || !clazz2.isPrimitive() && !clazz2.isArray() && !clazz2.isEnum() && !clazz2.equals(Calendar.class) && (Modifier.isAbstract(clazz2.getModifiers()) || Modifier.isInterface(clazz2.getModifiers()))) {
                    unmarshalWithClass = false;
                }
                if (clazz2 != null && (clazz2.getName().equals("javax.xml.datatype.XMLGregorianCalendar") || clazz2.getName().equals("javax.xml.datatype.Duration"))) {
                    unmarshalWithClass = true;
                }
                if (source instanceof Node) {
                    obj = unmarshalWithClass ? u.unmarshal((Node)source, clazz2) : u.unmarshal((Node)source);
                    break block13;
                }
                if (source instanceof DepthXMLStreamReader) {
                    DepthXMLStreamReader dr = (DepthXMLStreamReader)source;
                    XMLStreamReader reader2 = dr.getReader();
                    if (u.getSchema() != null) {
                        reader2 = JAXBEncoderDecoder.findExtraNamespaces(reader2);
                    }
                    obj = unmarshalWithClass ? u.unmarshal(reader2, clazz2) : u.unmarshal(dr.getReader());
                    break block13;
                }
                if (source instanceof XMLStreamReader) {
                    XMLStreamReader reader3 = (XMLStreamReader)source;
                    if (u.getSchema() != null) {
                        reader3 = JAXBEncoderDecoder.findExtraNamespaces(reader3);
                    }
                    obj = unmarshalWithClass ? u.unmarshal(reader3, clazz2) : u.unmarshal((XMLStreamReader)source);
                    break block13;
                }
                if (source instanceof XMLEventReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLEventReader)source, clazz2) : u.unmarshal((XMLEventReader)source);
                    break block13;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
            }
            catch (Fault ex2) {
                ex2.fillInStackTrace();
                throw ex2;
            }
            catch (Throwable ex3) {
                if (ex3 instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex3;
                    if (unmarshalEx.getLinkedException() != null) {
                        throw new Fault(new Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getLinkedException().getMessage()), ex3);
                    }
                    throw new Fault(new Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getMessage()), ex3);
                }
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, ex3.getMessage()), ex3);
            }
        }
        return unwrap ? JAXBEncoderDecoder.getElementValue(obj) : obj;
    }

    private static XMLStreamReader findExtraNamespaces(XMLStreamReader source) {
        TreeMap<String, String> nsMap;
        block16: {
            NamespaceContext c2 = source.getNamespaceContext();
            nsMap = new TreeMap<String, String>();
            try {
                if (c2 instanceof W3CNamespaceContext) {
                    for (Element element2 = ((W3CNamespaceContext)c2).getElement(); element2 != null; element2 = (Element)element2.getParentNode()) {
                        NamedNodeMap namedNodeMap = element2.getAttributes();
                        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                            Attr attr = (Attr)namedNodeMap.item(i);
                            if (attr.getPrefix() == null || !attr.getPrefix().equals("xmlns")) continue;
                            nsMap.put(attr.getLocalName(), attr.getValue());
                        }
                    }
                    break block16;
                }
                try {
                    c2 = (NamespaceContext)c2.getClass().getMethod("createNonTransientNsContext", Location.class).invoke((Object)c2, new Object[1]);
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                Field f2 = c2.getClass().getDeclaredField("mNamespaces");
                f2.setAccessible(true);
                String[] ns = (String[])f2.get(c2);
                for (int x = 0; x < ns.length; x += 2) {
                    nsMap.put(ns[x], ns[x + 1]);
                }
            }
            catch (Throwable t3) {
                try {
                    Field f3 = c2.getClass().getDeclaredField("fNamespaceContext");
                    f3.setAccessible(true);
                    Object c22 = f3.get(c2);
                    Enumeration enm = (Enumeration)c22.getClass().getMethod("getAllPrefixes", new Class[0]).invoke(c22, new Object[0]);
                    while (enm.hasMoreElements()) {
                        String s2 = (String)enm.nextElement();
                        if (s2 == null) {
                            nsMap.put("", c2.getNamespaceURI(s2));
                            continue;
                        }
                        nsMap.put(s2, c2.getNamespaceURI(s2));
                    }
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
        }
        if (!nsMap.isEmpty()) {
            for (int x = 0; x < source.getNamespaceCount(); ++x) {
                String pfx = source.getNamespacePrefix(x);
                if (pfx == null) {
                    nsMap.remove("");
                    continue;
                }
                nsMap.remove(pfx);
            }
            if (!nsMap.isEmpty()) {
                final Map.Entry[] namespaces = nsMap.entrySet().toArray(new Map.Entry[nsMap.size()]);
                source = new DepthXMLStreamReader(source){

                    public int getNamespaceCount() {
                        if (this.getDepth() == 0 && this.isStartElement()) {
                            return super.getNamespaceCount() + nsMap.size();
                        }
                        return super.getNamespaceCount();
                    }

                    public String getNamespacePrefix(int arg0) {
                        int i;
                        if (this.getDepth() == 0 && this.isStartElement() && arg0 >= (i = super.getNamespaceCount())) {
                            return (String)namespaces[arg0 -= i].getKey();
                        }
                        return super.getNamespacePrefix(arg0);
                    }

                    public String getNamespaceURI(int arg0) {
                        int i;
                        if (this.getDepth() == 0 && this.isStartElement() && arg0 >= (i = super.getNamespaceCount())) {
                            return (String)namespaces[arg0 -= i].getValue();
                        }
                        return super.getNamespaceURI(arg0);
                    }
                };
            }
        }
        return source;
    }

    public static Object getElementValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    public static Class<?> getClassFromType(Type t2) {
        if (t2 instanceof Class) {
            return (Class)t2;
        }
        if (t2 instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t2;
            return Array.newInstance(JAXBEncoderDecoder.getClassFromType(g.getGenericComponentType()), 0).getClass();
        }
        if (t2 instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t2;
            return JAXBEncoderDecoder.getClassFromType(p.getRawType());
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }

    public static List<Object> unmarshallArray(Unmarshaller u, Object source, QName elName, Class<?> clazz2, List<Object> ret) {
        try {
            XMLStreamReader reader2;
            if (source instanceof XMLStreamReader) {
                reader2 = (XMLStreamReader)source;
            } else if (source instanceof Element) {
                reader2 = StaxUtils.createXMLStreamReader((Element)source);
            } else {
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, source.getClass().getName()));
            }
            while (reader2.getName().equals(elName)) {
                Object obj = u.unmarshal(reader2, clazz2);
                if (obj instanceof JAXBElement) {
                    obj = obj.getValue();
                }
                ret.add(obj);
                while (reader2.getEventType() != 1 && reader2.getEventType() != 2) {
                    reader2.nextTag();
                }
            }
            return ret;
        }
        catch (Fault ex2) {
            ex2.fillInStackTrace();
            throw ex2;
        }
        catch (Exception ex3) {
            if (ex3 instanceof UnmarshalException) {
                UnmarshalException unmarshalEx = (UnmarshalException)ex3;
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex3);
            }
            throw new Fault(new Message("UNMARSHAL_ERROR", LOG, ex3.getMessage()), (Throwable)ex3);
        }
    }

    private static final class AddXSITypeStreamReader
    extends StreamReaderDelegate {
        private boolean first = true;
        private final QName typeQName;

        private AddXSITypeStreamReader(XMLStreamReader reader2, QName typeQName) {
            super(reader2);
            this.typeQName = typeQName;
        }

        public int getAttributeCount() {
            return super.getAttributeCount() + (this.first ? 1 : 0);
        }

        public String getAttributeLocalName(int index2) {
            if (this.first && index2 == 0) {
                return "type";
            }
            return super.getAttributeLocalName(index2 - 1);
        }

        public QName getAttributeName(int index2) {
            if (this.first && index2 == 0) {
                return new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
            }
            return super.getAttributeName(index2 - 1);
        }

        public String getAttributeNamespace(int index2) {
            if (this.first && index2 == 0) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            return super.getAttributeNamespace(index2 - 1);
        }

        public String getAttributePrefix(int index2) {
            if (this.first && index2 == 0) {
                return "xsi";
            }
            return super.getAttributePrefix(index2 - 1);
        }

        public String getAttributeType(int index2) {
            if (this.first && index2 == 0) {
                return "#TEXT";
            }
            return super.getAttributeType(index2 - 1);
        }

        public String getAttributeValue(int index2) {
            if (this.first && index2 == 0) {
                String pfx = this.getNamespaceContext().getPrefix(this.typeQName.getNamespaceURI());
                if (StringUtils.isEmpty(pfx)) {
                    return this.typeQName.getLocalPart();
                }
                return pfx + ":" + this.typeQName.getLocalPart();
            }
            return super.getAttributeValue(index2);
        }

        public int next() throws XMLStreamException {
            this.first = false;
            return super.next();
        }

        public String getAttributeValue(String namespaceUri, String localName) {
            if (this.first && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri) && "type".equals(localName)) {
                String pfx = this.getNamespaceContext().getPrefix(this.typeQName.getNamespaceURI());
                if (StringUtils.isEmpty(pfx)) {
                    return this.typeQName.getLocalPart();
                }
                return pfx + ":" + this.typeQName.getLocalPart();
            }
            return super.getAttributeValue(namespaceUri, localName);
        }
    }
}

