/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.common.util.CachedClass;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBUtils {
    public static final String JAXB_URI = "http://java.sun.com/xml/ns/jaxb";
    private static final char[] XML_NAME_PUNCTUATION_CHARS = new char[]{'-', '.', ':', '\u00b7', '\u0387', '\u06dd', '\u06de', '_'};
    private static final String XML_NAME_PUNCTUATION_STRING = new String(XML_NAME_PUNCTUATION_CHARS);
    private static final Map<String, String> BUILTIN_DATATYPES_MAP;
    private static final Map<String, Class<?>> HOLDER_TYPES_MAP;
    private static final Logger LOG;
    private static ClassLoader jaxbXjcLoader;

    private JAXBUtils() {
    }

    public static String builtInTypeToJavaType(String type) {
        return BUILTIN_DATATYPES_MAP.get(type);
    }

    public static Class<?> holderClass(String type) {
        return HOLDER_TYPES_MAP.get(type);
    }

    protected static boolean isJavaKeyword(String word) {
        return JavaUtils.isJavaKeyword(word);
    }

    public static String namespaceURIToPackage(String namespaceURI) {
        try {
            return JAXBUtils.nameSpaceURIToPackage(new URI(namespaceURI));
        }
        catch (URISyntaxException ex2) {
            return null;
        }
    }

    public static String nameSpaceURIToPackage(URI uri) {
        int index2;
        String path2;
        StringBuilder packageName = new StringBuilder();
        String authority = uri.getAuthority();
        String scheme = uri.getScheme();
        if (authority == null && "urn".equals(scheme)) {
            authority = uri.getSchemeSpecificPart();
        }
        if (null != authority && !"".equals(authority)) {
            String token2;
            StringTokenizer st;
            if ("urn".equals(scheme)) {
                packageName.append(authority);
                for (int i = 0; i < packageName.length(); ++i) {
                    if (packageName.charAt(i) != '-') continue;
                    packageName.setCharAt(i, '.');
                }
                authority = packageName.toString();
                packageName.setLength(0);
                st = new StringTokenizer(authority, ":");
                while (st.hasMoreTokens()) {
                    token2 = st.nextToken();
                    if (packageName.length() > 0) {
                        packageName.insert(0, ".");
                        packageName.insert(0, JAXBUtils.normalizePackageNamePart(token2));
                        continue;
                    }
                    packageName.insert(0, token2);
                }
                authority = packageName.toString();
                packageName.setLength(0);
            }
            if ((st = new StringTokenizer(authority, ".")).hasMoreTokens()) {
                token2 = null;
                while (st.hasMoreTokens()) {
                    token2 = st.nextToken();
                    if (packageName.length() == 0) {
                        if ("www".equals(token2)) {
                            continue;
                        }
                    } else {
                        packageName.insert(0, ".");
                    }
                    packageName.insert(0, JAXBUtils.normalizePackageNamePart(token2));
                }
            }
            if (!"http".equalsIgnoreCase(scheme) && !"urn".equalsIgnoreCase(scheme)) {
                packageName.insert(0, ".");
                packageName.insert(0, JAXBUtils.normalizePackageNamePart(scheme));
            }
        }
        if ((path2 = uri.getPath()) == null) {
            path2 = "";
        }
        if ((index2 = path2.lastIndexOf(46)) < 0) {
            index2 = path2.length();
        } else {
            String ending = path2.substring(index2 + 1);
            if (ending.length() < 2 || ending.length() > 3 && !"html".equalsIgnoreCase(ending)) {
                index2 = path2.length();
            }
        }
        StringTokenizer st = new StringTokenizer(path2.substring(0, index2), "/");
        while (st.hasMoreTokens()) {
            String token3 = st.nextToken();
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            packageName.append(JAXBUtils.normalizePackageNamePart(token3));
        }
        return packageName.toString();
    }

    private static String normalizePackageNamePart(String name) {
        int i;
        StringBuilder sname = new StringBuilder(name.toLowerCase());
        for (i = 0; i < sname.length(); ++i) {
            sname.setCharAt(i, Character.toLowerCase(sname.charAt(i)));
        }
        for (i = 0; i < sname.length(); ++i) {
            if (Character.isJavaIdentifierPart(sname.charAt(i))) continue;
            sname.setCharAt(i, '_');
        }
        if (JAXBUtils.isJavaKeyword(sname.toString())) {
            sname.insert(0, '_');
        }
        if (!Character.isJavaIdentifierStart(sname.charAt(0))) {
            sname.insert(0, '_');
        }
        return sname.toString();
    }

    public static String nameToIdentifier(String name, IdentifierType type) {
        if (null == name || name.length() == 0) {
            return name;
        }
        boolean legalIdentifier = false;
        StringBuilder buf = new StringBuilder(name);
        legalIdentifier = Character.isJavaIdentifierStart(buf.charAt(0));
        for (int i = 1; i < name.length() && legalIdentifier; ++i) {
            legalIdentifier = legalIdentifier && Character.isJavaIdentifierPart(buf.charAt(i));
        }
        boolean conventionalIdentifier = JAXBUtils.isConventionalIdentifier(buf, type);
        if (legalIdentifier && conventionalIdentifier) {
            if (JAXBUtils.isJavaKeyword(name) && type == IdentifierType.VARIABLE) {
                name = JAXBUtils.normalizePackageNamePart(name.toString());
            }
            return name;
        }
        ArrayList<String> words2 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(name, XML_NAME_PUNCTUATION_STRING);
        while (st.hasMoreTokens()) {
            words2.add(st.nextToken());
        }
        for (int i = 0; i < words2.size(); ++i) {
            JAXBUtils.splitWord(words2, i);
        }
        return JAXBUtils.makeConventionalIdentifier(words2, type);
    }

    private static void splitWord(List<String> words2, int listIndex) {
        String word = words2.get(listIndex);
        if (word.length() <= 1) {
            return;
        }
        int index2 = listIndex + 1;
        StringBuilder sword = new StringBuilder(word);
        int first2 = 0;
        char firstChar = sword.charAt(first2);
        if (Character.isLowerCase(firstChar)) {
            sword.setCharAt(first2, Character.toUpperCase(firstChar));
        }
        int i = 1;
        while (i < sword.length()) {
            if (Character.isDigit(firstChar)) {
                while (i < sword.length() && Character.isDigit(sword.charAt(i))) {
                    ++i;
                }
            } else if (JAXBUtils.isCasedLetter(firstChar)) {
                boolean previousIsLower = Character.isLowerCase(firstChar);
                while (!(i >= sword.length() || !JAXBUtils.isCasedLetter(sword.charAt(i)) || Character.isUpperCase(sword.charAt(i)) && previousIsLower)) {
                    previousIsLower = Character.isLowerCase(sword.charAt(i));
                    ++i;
                }
            } else {
                while (i < sword.length() && (JAXBUtils.isMark(sword.charAt(i)) || !JAXBUtils.isCasedLetter(sword.charAt(i)))) {
                    ++i;
                }
            }
            String newWord = sword.substring(first2, i);
            words2.add(index2, newWord);
            ++index2;
            if (i >= sword.length()) break;
            first2 = i;
            firstChar = sword.charAt(first2);
        }
        if (index2 > listIndex + 1) {
            words2.remove(listIndex);
        }
    }

    private static boolean isMark(char c2) {
        return Character.isJavaIdentifierPart(c2) && !Character.isLetter(c2) && !Character.isDigit(c2);
    }

    private static boolean isCasedLetter(char c2) {
        return Character.isUpperCase(c2) || Character.isLowerCase(c2);
    }

    private static boolean isConventionalIdentifier(StringBuilder buf, IdentifierType type) {
        if (null == buf || buf.length() == 0) {
            return false;
        }
        boolean result2 = false;
        if (IdentifierType.CONSTANT == type) {
            for (int i = 0; i < buf.length(); ++i) {
                if (!Character.isLowerCase(buf.charAt(i))) continue;
                return false;
            }
            result2 = true;
        } else if (IdentifierType.VARIABLE == type) {
            result2 = Character.isLowerCase(buf.charAt(0));
        } else {
            int pos = 3;
            if (!(IdentifierType.GETTER != type || buf.length() >= pos && "get".equals(buf.subSequence(0, 3)))) {
                return false;
            }
            if (!(IdentifierType.SETTER != type || buf.length() >= pos && "set".equals(buf.subSequence(0, 3)))) {
                return false;
            }
            pos = 0;
            result2 = Character.isUpperCase(buf.charAt(pos));
        }
        return result2;
    }

    private static String makeConventionalIdentifier(List<String> words2, IdentifierType type) {
        StringBuilder buf = new StringBuilder();
        boolean firstWord = true;
        if (IdentifierType.GETTER == type) {
            buf.append("get");
        } else if (IdentifierType.SETTER == type) {
            buf.append("set");
        }
        for (String w : words2) {
            int l = buf.length();
            if (l > 0 && IdentifierType.CONSTANT == type) {
                buf.append('_');
                ++l;
            }
            buf.append(w);
            if (IdentifierType.CONSTANT == type) {
                for (int i = l; i < buf.length(); ++i) {
                    if (!Character.isLowerCase(buf.charAt(i))) continue;
                    buf.setCharAt(i, Character.toUpperCase(buf.charAt(i)));
                }
            } else if (IdentifierType.VARIABLE == type) {
                if (firstWord && Character.isUpperCase(buf.charAt(l))) {
                    buf.setCharAt(l, Character.toLowerCase(buf.charAt(l)));
                }
            } else if (firstWord && Character.isLowerCase(buf.charAt(l))) {
                buf.setCharAt(l, Character.toUpperCase(buf.charAt(l)));
            }
            firstWord = false;
        }
        return buf.toString();
    }

    public static Class<?> getValidClass(Class<?> cls) {
        if (cls.isEnum()) {
            return cls;
        }
        if (cls.isArray()) {
            return cls;
        }
        if (cls == Object.class || cls == String.class || "javax.xml.ws.Holder".equals(cls.getName())) {
            cls = null;
        } else if (cls.isPrimitive() || cls.isAnnotation()) {
            cls = null;
        } else if (cls.isInterface()) {
            return cls;
        }
        if (cls != null) {
            if (cls.getName().equals("javax.xml.ws.wsaddressing.W3CEndpointReference")) {
                return cls;
            }
            Constructor<?> cons2 = null;
            try {
                cons2 = cls.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    cons2 = cls.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex22) {
                    cons2 = null;
                }
            }
            if (cons2 == null) {
                cls = null;
            }
        }
        return cls;
    }

    private static synchronized ClassLoader getXJCClassLoader() {
        block6: {
            if (jaxbXjcLoader == null) {
                try {
                    Class.forName("com.sun.tools.internal.xjc.api.XJC");
                    jaxbXjcLoader = ClassLoader.getSystemClassLoader();
                }
                catch (Exception t2) {
                    String s2 = System.getProperty("java.home");
                    if (StringUtils.isEmpty(s2)) break block6;
                    File home = new File(s2);
                    File jar = new File(home, "lib/tools.jar");
                    if (!jar.exists()) {
                        jar = new File(home, "../lib/tools.jar");
                    }
                    if (!jar.exists()) break block6;
                    try {
                        jaxbXjcLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()});
                        Class.forName("com.sun.tools.internal.xjc.api.XJC", false, jaxbXjcLoader);
                    }
                    catch (Exception e2) {
                        jaxbXjcLoader = null;
                    }
                }
            }
        }
        return jaxbXjcLoader;
    }

    public static JAXBContext createRIContext(Class<?>[] clss, String defaultNS) throws JAXBException {
        try {
            Class<?> cls;
            HashMap<String, String> map3;
            block5: {
                map3 = new HashMap<String, String>();
                try {
                    cls = Class.forName("com.sun.xml.bind.v2.ContextFactory");
                    if (defaultNS != null) {
                        map3.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNS);
                    }
                }
                catch (ClassNotFoundException e2) {
                    cls = Class.forName("com.sun.xml.internal.bind.v2.ContextFactory", true, JAXBUtils.getXJCClassLoader());
                    if (defaultNS == null) break block5;
                    map3.put("com.sun.xml.internal.bind.defaultNamespaceRemap", defaultNS);
                }
            }
            Method meth = cls.getMethod("createContext", clss.getClass(), Map.class);
            return (JAXBContext)meth.invoke(null, clss, map3);
        }
        catch (Exception e3) {
            throw new JAXBException((Throwable)e3);
        }
    }

    public static void setNamespaceWrapper(Map<String, String> nspref, Marshaller marshaller) throws PropertyException {
        Object mapper2 = null;
        if (marshaller.getClass().getName().contains(".internal.")) {
            mapper2 = JAXBUtils.createNamespaceWrapper(nspref);
            if (mapper2 == null) {
                LOG.log(Level.INFO, "Could not create namespace mapper for JDK internal JAXB implementation.");
            } else {
                marshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", mapper2);
            }
        } else {
            try {
                Class<?> cls = Class.forName("org.apache.cxf.jaxb.NamespaceMapper");
                mapper2 = cls.getConstructor(Map.class).newInstance(nspref);
            }
            catch (Exception ex2) {
                LOG.log(Level.INFO, "Could not create NamespaceMapper", ex2);
            }
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", mapper2);
        }
    }

    public static BridgeWrapper createBridge(Set<Class<?>> ctxClasses, QName qname, Class<?> refcls, Annotation[] anns) throws JAXBException {
        try {
            Class<?> refClass2;
            Class<?> cls;
            String pkg = "com.sun.xml.bind.";
            try {
                cls = Class.forName("com.sun.xml.bind.api.JAXBRIContext");
                refClass2 = Class.forName(pkg + "api.TypeReference");
            }
            catch (ClassNotFoundException e2) {
                cls = Class.forName("com.sun.xml.internal.bind.api.JAXBRIContext", true, JAXBUtils.getXJCClassLoader());
                pkg = "com.sun.xml.internal.bind.";
                refClass2 = Class.forName(pkg + "api.TypeReference", true, JAXBUtils.getXJCClassLoader());
            }
            Object ref = refClass2.getConstructor(QName.class, Type.class, anns.getClass()).newInstance(qname, refcls, anns);
            ArrayList typeRefs = new ArrayList();
            typeRefs.add(ref);
            ArrayList clses = new ArrayList(ctxClasses);
            clses.add(refClass2.getField("type").get(ref).getClass());
            if (!refcls.isInterface()) {
                clses.add(refcls);
            }
            Object ctx = null;
            for (Method m : cls.getDeclaredMethods()) {
                if (!m.getName().equals("newInstance") || m.getParameterTypes().length != 6) continue;
                ctx = m.invoke(null, clses.toArray(new Class[clses.size()]), typeRefs, null, null, true, null);
            }
            Object bridge2 = ctx.getClass().getMethod("createBridge", refClass2).invoke(ctx, ref);
            return ReflectionInvokationHandler.createProxyWrapper(bridge2, BridgeWrapper.class);
        }
        catch (Exception ex2) {
            throw new JAXBException((Throwable)ex2);
        }
    }

    public static SchemaCompiler createSchemaCompiler() throws JAXBException {
        try {
            Object sc = null;
            try {
                Class<?> cls = Class.forName("com.sun.tools.xjc.api.XJC");
                sc = cls.getMethod("createSchemaCompiler", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable e2) {
                Class<?> cls = Class.forName("com.sun.tools.internal.xjc.api.XJC", true, JAXBUtils.getXJCClassLoader());
                sc = cls.getMethod("createSchemaCompiler", new Class[0]).invoke(null, new Object[0]);
            }
            return ReflectionInvokationHandler.createProxyWrapper(sc, SchemaCompiler.class);
        }
        catch (Exception ex2) {
            throw new JAXBException((Throwable)ex2);
        }
    }

    public static SchemaCompiler createSchemaCompilerWithDefaultAllocator(Set<String> allocatorSet) {
        try {
            SchemaCompiler compiler = JAXBUtils.createSchemaCompiler();
            Object allocator = ReflectionInvokationHandler.createProxyWrapper(new DefaultClassNameAllocator(allocatorSet), JAXBUtils.getParamClass(compiler, "setClassNameAllocator"));
            compiler.setClassNameAllocator(allocator);
            return compiler;
        }
        catch (JAXBException e1) {
            throw new IllegalStateException("Unable to create schema compiler", e1);
        }
    }

    public static void logGeneratedClassNames(Logger logger, JCodeModel codeModel) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        Iterator<JPackage> itr = codeModel.packages();
        while (itr.hasNext()) {
            JPackage package1 = itr.next();
            Iterator<JDefinedClass> citr = package1.classes();
            while (citr.hasNext()) {
                if (!first2) {
                    sb.append(", ");
                } else {
                    first2 = false;
                }
                sb.append(citr.next().fullName());
            }
        }
        logger.log(Level.INFO, "Created classes: " + sb.toString());
    }

    public static Object createFileCodeWriter(File f2) throws JAXBException {
        try {
            Class<?> cls;
            try {
                cls = Class.forName("com.sun.codemodel.writer.FileCodeWriter");
            }
            catch (ClassNotFoundException e2) {
                cls = Class.forName("com.sun.codemodel.internal.writer.FileCodeWriter", true, JAXBUtils.getXJCClassLoader());
            }
            return cls.getConstructor(File.class).newInstance(f2);
        }
        catch (Exception ex2) {
            throw new JAXBException((Throwable)ex2);
        }
    }

    public static Class<?> getParamClass(SchemaCompiler sc, String method) {
        Object o = ((ReflectionInvokationHandler)Proxy.getInvocationHandler(sc)).getTarget();
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().equals(method) || m.getParameterTypes().length != 1) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static JAXBBeanInfo getBeanInfo(JAXBContextProxy context, Class<?> cls) {
        Object o = context.getBeanInfo(cls);
        if (o == null) {
            return null;
        }
        return ReflectionInvokationHandler.createProxyWrapper(o, JAXBBeanInfo.class);
    }

    public static List<DOMResult> generateJaxbSchemas(JAXBContext context, final Map<String, DOMResult> builtIns) throws IOException {
        final ArrayList<DOMResult> results2 = new ArrayList<DOMResult>();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result2 = new DOMResult();
                if (builtIns.containsKey(ns)) {
                    DOMResult dr = (DOMResult)builtIns.get(ns);
                    result2.setSystemId(dr.getSystemId());
                    results2.add(dr);
                    return result2;
                }
                result2.setSystemId(file);
                results2.add(result2);
                return result2;
            }
        });
        return results2;
    }

    public static String getPackageNamespace(Class<?> cls) {
        XmlSchema schemaAnn;
        Package p = cls.getPackage();
        if (p != null && (schemaAnn = p.getAnnotation(XmlSchema.class)) != null) {
            return schemaAnn.namespace();
        }
        return null;
    }

    public static void scanPackages(Set<Class<?>> classes2, Map<Package, CachedClass> objectFactoryCache) {
        JAXBUtils.scanPackages(classes2, null, objectFactoryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static void scanPackages(Set<Class<?>> classes2, Class[] extraClass, Map<Package, CachedClass> objectFactoryCache) {
        Object pkg;
        if (extraClass != null && extraClass.length > 0) {
            for (Class clz : extraClass) {
                classes2.add(clz);
            }
        }
        HashMap<String, InputStream> packages2 = new HashMap<String, InputStream>();
        HashMap<String, ClassLoader> packageLoaders = new HashMap<String, ClassLoader>();
        HashSet objectFactories = new HashSet();
        for (Class<?> jcls : classes2) {
            String pkgName = PackageUtils.getPackageName(jcls);
            if (packages2.containsKey(pkgName)) continue;
            pkg = jcls.getPackage();
            packages2.put(pkgName, jcls.getResourceAsStream("jaxb.index"));
            packageLoaders.put(pkgName, jcls.getClassLoader());
            String objectFactoryClassName = pkgName + "." + "ObjectFactory";
            Class<?> ofactory = null;
            CachedClass cachedFactory = null;
            if (pkg != null && objectFactoryCache != null) {
                Map<Package, CachedClass> map3 = objectFactoryCache;
                synchronized (map3) {
                    cachedFactory = objectFactoryCache.get(pkg);
                }
            }
            if (cachedFactory != null) {
                ofactory = cachedFactory.getCachedClass();
            }
            if (ofactory == null) {
                try {
                    ofactory = Class.forName(objectFactoryClassName, false, jcls.getClassLoader());
                    objectFactories.add(ofactory);
                    JAXBUtils.addToObjectFactoryCache((Package)pkg, ofactory, objectFactoryCache);
                }
                catch (ClassNotFoundException e2) {
                    JAXBUtils.addToObjectFactoryCache((Package)pkg, null, objectFactoryCache);
                }
                continue;
            }
            objectFactories.add(ofactory);
        }
        for (Map.Entry entry2 : packages2.entrySet()) {
            if (entry2.getValue() == null) continue;
            BufferedReader reader2 = null;
            reader2 = new BufferedReader(new InputStreamReader((InputStream)entry2.getValue(), "UTF-8"));
            pkg = (String)entry2.getKey();
            ClassLoader loader = (ClassLoader)packageLoaders.get(pkg);
            if (!StringUtils.isEmpty((String)pkg)) {
                pkg = (String)pkg + ".";
            }
            String line = reader2.readLine();
            while (line != null) {
                if ((line = line.trim()).indexOf("#") != -1) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (!StringUtils.isEmpty(line)) {
                    try {
                        Class<?> ncls = Class.forName((String)pkg + line, false, loader);
                        classes2.add(ncls);
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                line = reader2.readLine();
            }
            Object var16_20 = null;
            try {
                if (reader2 == null) continue;
                reader2.close();
                ((InputStream)entry2.getValue()).close();
            }
            catch (Exception e4) {}
            continue;
            {
                catch (Exception e5) {
                    var16_20 = null;
                    try {
                        if (reader2 == null) continue;
                        reader2.close();
                        ((InputStream)entry2.getValue()).close();
                    }
                    catch (Exception e4) {}
                    continue;
                }
            }
            catch (Throwable throwable2) {
                var16_20 = null;
                try {
                    if (reader2 != null) {
                        reader2.close();
                        ((InputStream)entry2.getValue()).close();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                throw throwable2;
            }
        }
        classes2.addAll(objectFactories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToObjectFactoryCache(Package objectFactoryPkg, Class<?> ofactory, Map<Package, CachedClass> objectFactoryCache) {
        if (objectFactoryPkg == null || objectFactoryCache == null) {
            return;
        }
        Map<Package, CachedClass> map3 = objectFactoryCache;
        synchronized (map3) {
            objectFactoryCache.put(objectFactoryPkg, new CachedClass(ofactory));
        }
    }

    private static synchronized Object createNamespaceWrapper(Map<String, String> map3) {
        ASMHelper helper2 = new ASMHelper();
        String className = "org.apache.cxf.jaxb.NamespaceMapperInternal";
        Class<?> cls = helper2.findClass(className, JAXBUtils.class);
        if (cls == null) {
            ClassWriter cw = helper2.createClassWriter();
            if (cw == null) {
                return null;
            }
            cls = JAXBUtils.createNamespaceWrapperInternal(helper2, cw);
        }
        try {
            return cls.getConstructor(Map.class).newInstance(map3);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static Class<?> createNamespaceWrapperInternal(ASMHelper helper2, ClassWriter cw) {
        Class<Object> cls;
        String className = "org.apache.cxf.jaxb.NamespaceMapperInternal";
        cw.visit(49, 49, "org/apache/cxf/jaxb/NamespaceMapperInternal", null, "com/sun/xml/internal/bind/marshaller/NamespacePrefixMapper", null);
        cw.visitSource("NamespaceMapper.java", null);
        FieldVisitor fv = cw.visitField(18, "nspref", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;)V", null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(30, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/sun/xml/internal/bind/marshaller/NamespacePrefixMapper", "<init>", "()V");
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(31, l1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, "org/apache/cxf/jaxb/NamespaceMapperInternal", "nspref", "Ljava/util/Map;");
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(32, l2);
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/jaxb/NamespaceMapperInternal;", null, l0, l3, 0);
        mv.visitLocalVariable("nspref", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", l0, l3, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getPreferredPrefix", "(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/String;", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(38, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/apache/cxf/jaxb/NamespaceMapperInternal", "nspref", "Ljava/util/Map;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/lang/String");
        mv.visitVarInsn(58, 4);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(39, l1);
        mv.visitVarInsn(25, 4);
        l2 = new Label();
        mv.visitJumpInsn(198, l2);
        l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(40, l3);
        mv.visitVarInsn(25, 4);
        mv.visitInsn(176);
        mv.visitLabel(l2);
        mv.visitLineNumber(42, l2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "Lorg/apache/cxf/jaxb/NamespaceMapperInternal;", null, l0, l4, 0);
        mv.visitLocalVariable("namespaceUri", "Ljava/lang/String;", null, l0, l4, 1);
        mv.visitLocalVariable("suggestion", "Ljava/lang/String;", null, l0, l4, 2);
        mv.visitLocalVariable("requirePrefix", "Z", null, l0, l4, 3);
        mv.visitLocalVariable("prefix", "Ljava/lang/String;", null, l1, l4, 4);
        mv.visitMaxs(2, 5);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bts = cw.toByteArray();
        try {
            cls = Class.forName("com.sun.xml.bind.api.JAXBRIContext");
        }
        catch (ClassNotFoundException e2) {
            try {
                cls = Class.forName("com.sun.xml.internal.bind.api.JAXBRIContext", true, JAXBUtils.getXJCClassLoader());
            }
            catch (ClassNotFoundException e1) {
                cls = JAXBUtils.class;
            }
        }
        return helper2.loadClass(className, cls, bts);
    }

    static {
        LOG = LogUtils.getL7dLogger(JAXBUtils.class, "CommonUtilityMessages");
        BUILTIN_DATATYPES_MAP = new HashMap<String, String>();
        BUILTIN_DATATYPES_MAP.put("string", "java.lang.String");
        BUILTIN_DATATYPES_MAP.put("integer", "java.math.BigInteger");
        BUILTIN_DATATYPES_MAP.put("int", "int");
        BUILTIN_DATATYPES_MAP.put("long", "long");
        BUILTIN_DATATYPES_MAP.put("short", "short");
        BUILTIN_DATATYPES_MAP.put("decimal", "java.math.BigDecimal");
        BUILTIN_DATATYPES_MAP.put("float", "float");
        BUILTIN_DATATYPES_MAP.put("double", "double");
        BUILTIN_DATATYPES_MAP.put("boolean", "boolean");
        BUILTIN_DATATYPES_MAP.put("byte", "byte");
        BUILTIN_DATATYPES_MAP.put("QName", "javax.xml.namespace.QName");
        BUILTIN_DATATYPES_MAP.put("dateTime", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("base64Binary", "byte[]");
        BUILTIN_DATATYPES_MAP.put("hexBinary", "byte[]");
        BUILTIN_DATATYPES_MAP.put("unsignedInt", "long");
        BUILTIN_DATATYPES_MAP.put("unsignedShort", "short");
        BUILTIN_DATATYPES_MAP.put("unsignedByte", "byte");
        BUILTIN_DATATYPES_MAP.put("time", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("date", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gYear", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gYearMonth", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gMonth", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gMonthDay", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gDay", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("duration", "javax.xml.datatype.Duration");
        BUILTIN_DATATYPES_MAP.put("NOTATION", "javax.xml.namespace.QName");
        BUILTIN_DATATYPES_MAP.put("string", "java.lang.String");
        HOLDER_TYPES_MAP = new HashMap();
        HOLDER_TYPES_MAP.put("int", Integer.class);
        HOLDER_TYPES_MAP.put("long", Long.class);
        HOLDER_TYPES_MAP.put("short", Short.class);
        HOLDER_TYPES_MAP.put("float", Float.class);
        HOLDER_TYPES_MAP.put("double", Double.class);
        HOLDER_TYPES_MAP.put("boolean", Boolean.class);
        HOLDER_TYPES_MAP.put("byte", Byte.class);
    }

    public static interface JDefinedClass {
        public String name();

        public String fullName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JPackage {
        public String name();

        @ReflectionInvokationHandler.WrapReturn(value=JDefinedClass.class, iterator=true)
        public Iterator<JDefinedClass> classes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JCodeModel {
        public void build(Object var1) throws IOException;

        @ReflectionInvokationHandler.WrapReturn(value=JPackage.class, iterator=true)
        public Iterator<JPackage> packages();
    }

    public static interface Options {
        public void addGrammar(InputSource var1);

        public void addBindFile(InputSource var1);

        public String getBuildID();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JType {
        public boolean isArray();

        @ReflectionInvokationHandler.WrapReturn(value=JType.class)
        public JType elementType();

        public boolean isPrimitive();

        public String binaryName();

        public String fullName();

        public String name();

        @ReflectionInvokationHandler.WrapReturn(value=JType.class, iterator=true)
        public Iterator<JType> classes();
    }

    public static interface TypeAndAnnotation {
        @ReflectionInvokationHandler.WrapReturn(value=JType.class)
        public JType getTypeClass();
    }

    public static interface Mapping {
        @ReflectionInvokationHandler.WrapReturn(value=TypeAndAnnotation.class)
        public TypeAndAnnotation getType();
    }

    public static interface S2JJAXBModel {
        @ReflectionInvokationHandler.WrapReturn(value=JCodeModel.class)
        public JCodeModel generateCode(Object var1, Object var2);

        @ReflectionInvokationHandler.WrapReturn(value=Mapping.class)
        public Mapping get(QName var1);

        @ReflectionInvokationHandler.WrapReturn(value=TypeAndAnnotation.class)
        public TypeAndAnnotation getJavaType(QName var1);
    }

    public static interface SchemaCompiler {
        public void setErrorListener(Object var1);

        public void setClassNameAllocator(Object var1);

        @ReflectionInvokationHandler.WrapReturn(value=S2JJAXBModel.class)
        public S2JJAXBModel bind();

        public void parseSchema(InputSource var1);

        public void parseSchema(String var1, Element var2);

        @ReflectionInvokationHandler.WrapReturn(value=Options.class)
        public Options getOptions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultClassNameAllocator {
        private final Set<String> typesClassNames;

        public DefaultClassNameAllocator() {
            this(new HashSet<String>());
        }

        public DefaultClassNameAllocator(Set<String> set2) {
            this.typesClassNames = set2;
        }

        public String assignClassName(String packageName, String className) {
            String fullClassName = className;
            String fullPckClass = packageName + "." + fullClassName;
            int cnt = 0;
            while (this.typesClassNames.contains(fullPckClass)) {
                fullClassName = className + ++cnt;
                fullPckClass = packageName + "." + fullClassName;
            }
            this.typesClassNames.add(fullPckClass);
            return fullClassName;
        }
    }

    public static interface BridgeWrapper {
        public Object unmarshal(XMLStreamReader var1, AttachmentUnmarshaller var2) throws JAXBException;

        public Object unmarshal(InputStream var1) throws JAXBException;

        public Object unmarshal(Node var1, AttachmentUnmarshaller var2) throws JAXBException;

        public void marshal(Object var1, XMLStreamWriter var2, AttachmentMarshaller var3) throws JAXBException;

        public void marshal(Object var1, StreamResult var2) throws JAXBException;

        public void marshal(Object var1, Node var2, AttachmentMarshaller var3) throws JAXBException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentifierType {
        CLASS,
        INTERFACE,
        GETTER,
        SETTER,
        VARIABLE,
        CONSTANT;

    }
}

