/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientProxy
extends ClientProxy
implements InvocationHandler,
BindingProvider {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsClientProxy.class);
    private final Binding binding;
    private final EndpointReferenceBuilder builder;

    public JaxWsClientProxy(Client c2, Binding b) {
        super(c2);
        this.binding = b;
        this.setupEndpointAddressContext(this.getClient().getEndpoint());
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)this.getClient().getEndpoint());
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        BindingOperationInfo oi;
        Endpoint endpoint = this.getClient().getEndpoint();
        String address = endpoint.getEndpointInfo().getAddress();
        MethodDispatcher dispatcher = (MethodDispatcher)endpoint.getService().get(MethodDispatcher.class.getName());
        Object[] params2 = args2;
        if (null == params2) {
            params2 = new Object[]{};
        }
        if ((oi = dispatcher.getBindingOperation(method, endpoint)) == null) {
            if (method.getDeclaringClass().equals(BindingProvider.class) || method.getDeclaringClass().equals(Object.class)) {
                try {
                    return method.invoke((Object)this, params2);
                }
                catch (InvocationTargetException e2) {
                    throw e2.fillInStackTrace().getCause();
                }
            }
            Message msg = new Message("NO_BINDING_OPERATION_INFO", LOG, method.getName());
            throw new WebServiceException(msg.toString());
        }
        this.client.getRequestContext().put(Method.class.getName(), method);
        boolean isAsync = this.isAsync(method);
        Object result2 = null;
        try {
            result2 = isAsync ? this.invokeAsync(method, oi, params2) : this.invokeSync(method, oi, params2);
        }
        catch (WebServiceException wex) {
            throw wex.fillInStackTrace();
        }
        catch (Exception ex2) {
            for (Class<?> excls : method.getExceptionTypes()) {
                if (!excls.isInstance(ex2)) continue;
                throw ex2.fillInStackTrace();
            }
            if (ex2 instanceof Fault && ex2.getCause() instanceof IOException) {
                throw new WebServiceException(ex2.getMessage(), ex2.getCause());
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)ex2);
                throw exception;
            }
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex2);
                if (soapFault == null) {
                    throw new WebServiceException((Throwable)ex2);
                }
                SOAPFaultException exception = new SOAPFaultException(soapFault);
                if (ex2 instanceof Fault && ex2.getCause() != null) {
                    exception.initCause(ex2.getCause());
                } else {
                    exception.initCause((Throwable)ex2);
                }
                throw exception;
            }
            throw new WebServiceException((Throwable)ex2);
        }
        finally {
            if (this.addressChanged(address)) {
                this.setupEndpointAddressContext(this.getClient().getEndpoint());
            }
        }
        Map<String, Object> respContext = this.client.getResponseContext();
        Map scopes = CastUtils.cast((Map)respContext.get(WrappedMessageContext.SCOPES));
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                respContext.remove(scope.getKey());
            }
        }
        return result2;
    }

    boolean isAsync(Method m) {
        return m.getName().endsWith("Async") && (Future.class.equals(m.getReturnType()) || Response.class.equals(m.getReturnType()));
    }

    static SOAPFault createSoapFault(SOAPBinding binding, Exception ex2) throws SOAPException {
        SOAPFault soapFault;
        try {
            soapFault = binding.getSOAPFactory().createFault();
        }
        catch (Throwable t2) {
            try {
                soapFault = binding.getMessageFactory().createMessage().getSOAPBody().addFault();
            }
            catch (Throwable t22) {
                return null;
            }
        }
        if (ex2 instanceof SoapFault) {
            if (!soapFault.getNamespaceURI().equals(((SoapFault)ex2).getFaultCode().getNamespaceURI()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(((SoapFault)ex2).getFaultCode().getNamespaceURI())) {
                try {
                    soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
                }
                catch (Throwable t3) {
                    // empty catch block
                }
            }
            soapFault.setFaultString(((SoapFault)ex2).getReason());
            soapFault.setFaultCode(((SoapFault)ex2).getFaultCode());
            soapFault.setFaultActor(((SoapFault)ex2).getRole());
            if (((SoapFault)ex2).hasDetails()) {
                Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)ex2).getDetail(), true);
                nd = nd.getFirstChild();
                soapFault.addDetail();
                while (nd != null) {
                    Node next2 = nd.getNextSibling();
                    soapFault.getDetail().appendChild(nd);
                    nd = next2;
                }
            }
        } else {
            String msg = ex2.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }

    private boolean addressChanged(String address) {
        return address != null && this.getClient().getEndpoint().getEndpointInfo() != null && !address.equals(this.getClient().getEndpoint().getEndpointInfo().getAddress());
    }

    private Object invokeAsync(Method method, BindingOperationInfo oi, Object[] params2) throws Exception {
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        AsyncHandler handler = params2.length > 0 && params2[params2.length - 1] instanceof AsyncHandler ? (AsyncHandler)params2[params2.length - 1] : null;
        JaxwsClientCallback callback = new JaxwsClientCallback(handler);
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        this.client.invoke(callback, oi, params2);
        return ret;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        return new WrappedMessageContext(this.getClient().getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    @Override
    public Map<String, Object> getResponseContext() {
        return new WrappedMessageContext(this.getClient().getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        return this.builder.getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz2) {
        return this.builder.getEndpointReference(clazz2);
    }
}

