/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.blueprint;

import java.util.StringTokenizer;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.blueprint.AbstractBPBeanDefinitionParser;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class EndpointDefinitionParser
extends AbstractBPBeanDefinitionParser {
    private static final Class<?> EP_CLASS;

    EndpointDefinitionParser() {
    }

    public static String getIdOrName(Element elem2) {
        StringTokenizer st;
        String names;
        String id2 = elem2.getAttribute("id");
        if ((null == id2 || "".equals(id2)) && null != (names = elem2.getAttribute("name")) && (st = new StringTokenizer(names, ",")).countTokens() > 0) {
            id2 = st.nextToken();
        }
        return id2;
    }

    public Metadata parse(Element element2, ParserContext context) {
        MutableBeanMetadata cxfBean = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        if (!StringUtils.isEmpty(EndpointDefinitionParser.getIdOrName(element2))) {
            cxfBean.setId(EndpointDefinitionParser.getIdOrName(element2));
        } else {
            cxfBean.setId("cxf.endpoint." + UUID.randomUUID().toString());
        }
        cxfBean.setRuntimeClass(EP_CLASS);
        boolean isAbstract = false;
        boolean publish2 = true;
        NamedNodeMap atts = element2.getAttributes();
        String bus = null;
        Metadata impl = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node4 = (Attr)atts.item(i);
            String val = node4.getValue();
            String pre = node4.getPrefix();
            String name = node4.getLocalName();
            if ("createdFromAPI".equals(name) || "abstract".equals(name)) {
                cxfBean.setScope("prototype");
                isAbstract = true;
                continue;
            }
            if ("publish".equals(name)) {
                publish2 = Boolean.parseBoolean(val);
                continue;
            }
            if ("bus".equals(name)) {
                bus = val;
                continue;
            }
            if (!this.isAttribute(pre, name)) continue;
            if ("endpointName".equals(name) || "serviceName".equals(name)) {
                QName q = this.parseQName(element2, val);
                cxfBean.addProperty(name, this.createValue(context, q));
                continue;
            }
            if ("depends-on".equals(name)) {
                cxfBean.addDependsOn(val);
                continue;
            }
            if ("implementor".equals(name)) {
                if (val.startsWith("#")) {
                    impl = EndpointDefinitionParser.createRef(context, val.substring(1));
                    continue;
                }
                impl = EndpointDefinitionParser.createObjectOfClass(context, val);
                continue;
            }
            if ("name".equals(name)) continue;
            cxfBean.addProperty(name, (Metadata)EndpointDefinitionParser.createValue(context, val));
        }
        Element elem2 = DOMUtils.getFirstElement(element2);
        while (elem2 != null) {
            String name = elem2.getLocalName();
            if ("properties".equals(name)) {
                Metadata map3 = this.parseMapData(context, (ComponentMetadata)cxfBean, elem2);
                cxfBean.addProperty(name, map3);
            } else if ("binding".equals(name)) {
                this.setFirstChildAsProperty(elem2, context, cxfBean, "bindingConfig");
            } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
                Metadata list2 = this.parseListData(context, (ComponentMetadata)cxfBean, elem2);
                cxfBean.addProperty(name, list2);
            } else if ("implementor".equals(name)) {
                impl = (Metadata)context.parseElement(Metadata.class, (ComponentMetadata)cxfBean, elem2);
            } else {
                this.setFirstChildAsProperty(elem2, context, cxfBean, name);
            }
            elem2 = DOMUtils.getNextElement(elem2);
        }
        if (StringUtils.isEmpty(bus)) {
            bus = "cxf";
        }
        cxfBean.addArgument((Metadata)this.getBusRef(context, bus), Bus.class.getName(), 0);
        cxfBean.addArgument(impl, Object.class.getName(), 1);
        if (!isAbstract) {
            if (publish2) {
                cxfBean.setInitMethod("publish");
            }
            cxfBean.setDestroyMethod("stop");
        }
        cxfBean.setActivation(1);
        return cxfBean;
    }

    static {
        Class cls = EndpointImpl.class;
        try {
            if (ProviderImpl.isJaxWs22()) {
                cls = ClassLoaderUtils.loadClass("org.apache.cxf.jaxws22.JAXWS22EndpointImpl", EndpointDefinitionParser.class);
            }
        }
        catch (Throwable t2) {
            cls = EndpointImpl.class;
        }
        EP_CLASS = cls;
    }
}

