/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
implements HandlerResolver {
    private final Map<PortInfo, List<Handler>> handlerMap = new HashMap<PortInfo, List<Handler>>();
    private Class<?> annotationClass;
    private Bus bus;

    public HandlerResolverImpl(Bus bus, QName serviceName, Class<?> clazz2) {
        this.bus = bus;
        this.annotationClass = clazz2;
    }

    public HandlerResolverImpl() {
        this(null, null, null);
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        List<Handler> handlerChain = this.handlerMap.get(portInfo);
        if (handlerChain == null) {
            handlerChain = this.createHandlerChain(portInfo);
            this.handlerMap.put(portInfo, handlerChain);
        }
        return handlerChain;
    }

    private List<Handler> createHandlerChain(PortInfo portInfo) {
        ArrayList<Handler> chain2 = null;
        if (null == chain2) {
            chain2 = new ArrayList<Handler>();
        }
        if (this.annotationClass != null) {
            chain2.addAll(this.getHandlersFromAnnotation(this.annotationClass, portInfo));
        }
        for (Handler h : chain2) {
            this.configHandler(h);
        }
        return chain2;
    }

    private List<Handler> getHandlersFromAnnotation(Class<?> clazz2, PortInfo portInfo) {
        AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
        List<Handler> chain2 = builder.buildHandlerChainFromClass(clazz2, portInfo != null ? portInfo.getPortName() : null, portInfo != null ? portInfo.getServiceName() : null, portInfo != null ? portInfo.getBindingID() : null);
        return chain2;
    }

    private void configHandler(Handler handler) {
        if (handler != null) {
            ResourceManager resourceManager = this.bus.getExtension(ResourceManager.class);
            List<ResourceResolver> resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            ResourceInjector injector = new ResourceInjector(resourceManager);
            injector.inject(handler);
            injector.construct(handler);
        }
    }
}

