/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalHandlerOutInterceptor
extends AbstractJAXWSHandlerInterceptor<Message> {
    public static final String ORIGINAL_WRITER = LogicalHandlerOutInterceptor.class.getName() + ".original_writer";
    private LogicalHandlerOutEndingInterceptor ending;

    public LogicalHandlerOutInterceptor(Binding binding) {
        super(binding, "pre-marshal");
        this.ending = new LogicalHandlerOutEndingInterceptor(binding);
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        if (this.binding.getHandlerChain().isEmpty()) {
            return;
        }
        HandlerChainInvoker invoker = this.getInvoker(message);
        if (invoker.getLogicalHandlers().isEmpty()) {
            return;
        }
        try {
            XMLStreamWriter origWriter = message.getContent(XMLStreamWriter.class);
            Document document2 = XMLUtils.newDocument();
            message.setContent(Node.class, document2);
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter(document2.createDocumentFragment());
            message.setContent(XMLStreamWriter.class, writer);
            message.put(ORIGINAL_WRITER, origWriter);
            message.getInterceptorChain().add(this.ending);
        }
        catch (ParserConfigurationException e2) {
            throw new Fault(e2);
        }
    }

    @Override
    public void handleFault(Message message) {
        super.handleFault(message);
        XMLStreamWriter os2 = (XMLStreamWriter)message.get(ORIGINAL_WRITER);
        if (os2 != null) {
            message.setContent(XMLStreamWriter.class, os2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalHandlerOutEndingInterceptor
    extends AbstractJAXWSHandlerInterceptor<Message> {
        public LogicalHandlerOutEndingInterceptor(Binding binding) {
            super(binding, "post-marshal");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            W3CDOMStreamWriter domWriter = (W3CDOMStreamWriter)message.getContent(XMLStreamWriter.class);
            XMLStreamWriter origWriter = (XMLStreamWriter)message.get(ORIGINAL_WRITER);
            HandlerChainInvoker invoker = this.getInvoker(message);
            LogicalMessageContextImpl lctx = new LogicalMessageContextImpl(message);
            invoker.setLogicalMessageContext(lctx);
            boolean requestor = this.isRequestor(message);
            XMLStreamReader reader2 = (XMLStreamReader)message.get("LogicalHandlerInterceptor.INREADER");
            SOAPMessage origMessage = null;
            if (reader2 != null) {
                origMessage = message.getContent(SOAPMessage.class);
                message.setContent(XMLStreamReader.class, reader2);
                message.removeContent(SOAPMessage.class);
            } else if (domWriter.getCurrentFragment() != null) {
                Node nd;
                DocumentFragment frag = domWriter.getCurrentFragment();
                for (nd = frag.getFirstChild(); nd != null && !(nd instanceof Element); nd = nd.getNextSibling()) {
                }
                DOMSource source = new DOMSource(nd);
                message.setContent(Source.class, source);
                message.setContent(XMLStreamReader.class, new W3CDOMStreamReader(domWriter.getCurrentFragment()));
            } else if (domWriter.getDocument().getDocumentElement() != null) {
                DOMSource source = new DOMSource(domWriter.getDocument());
                message.setContent(Source.class, source);
                message.setContent(XMLStreamReader.class, StaxUtils.createXMLStreamReader(domWriter.getDocument()));
            }
            if (!invoker.invokeLogicalHandlers(requestor, lctx)) {
                if (requestor) {
                    message.getInterceptorChain().abort();
                    if (!message.getExchange().isOneWay()) {
                        Endpoint e2 = message.getExchange().get(Endpoint.class);
                        Message responseMsg = new MessageImpl();
                        responseMsg.setExchange(message.getExchange());
                        responseMsg = e2.getBinding().createMessage(responseMsg);
                        MessageObserver observer = message.getExchange().get(MessageObserver.class);
                        if (observer != null) {
                            responseMsg.setContent(XMLStreamReader.class, message.getContent(XMLStreamReader.class));
                            message.getExchange().setInMessage(responseMsg);
                            responseMsg.put("starting_at_interceptor_id", LogicalHandlerInInterceptor.class.getName());
                            observer.onMessage(responseMsg);
                        }
                    }
                }
                return;
            }
            if (origMessage != null) {
                message.setContent(SOAPMessage.class, origMessage);
            }
            try {
                reader2 = message.getContent(XMLStreamReader.class);
                message.removeContent(XMLStreamReader.class);
                if (reader2 != null) {
                    StaxUtils.copy(reader2, origWriter);
                } else if (domWriter.getDocument().getDocumentElement() != null) {
                    StaxUtils.copy(domWriter.getDocument(), origWriter);
                }
                message.setContent(XMLStreamWriter.class, origWriter);
            }
            catch (XMLStreamException e3) {
                throw new Fault(e3);
            }
        }
    }
}

