/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogicalMessageImpl
implements LogicalMessage {
    private static final Logger LOG = LogUtils.getL7dLogger(LogicalMessageImpl.class);
    private final LogicalMessageContextImpl msgContext;

    public LogicalMessageImpl(LogicalMessageContextImpl lmctx) {
        this.msgContext = lmctx;
    }

    public Source getPayload() {
        Source source = null;
        Service.Mode mode = this.msgContext.getWrappedMessage().getExchange().get(Service.Mode.class);
        if (mode != null) {
            source = this.handleDispatchProviderCase(mode);
        } else {
            Message message = this.msgContext.getWrappedMessage();
            source = message.getContent(Source.class);
            if (source == null) {
                SOAPMessage msg = message.getContent(SOAPMessage.class);
                XMLStreamReader reader2 = null;
                if (msg != null) {
                    try {
                        Node node4;
                        for (node4 = msg.getSOAPBody().getFirstChild(); node4 != null && !(node4 instanceof Element); node4 = node4.getNextSibling()) {
                        }
                        source = new DOMSource(node4);
                        reader2 = StaxUtils.createXMLStreamReader(source);
                    }
                    catch (SOAPException e2) {
                        throw new Fault(e2);
                    }
                }
                if (source == null) {
                    try {
                        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                        reader2 = message.getContent(XMLStreamReader.class);
                        StaxUtils.toNextTag(reader2);
                        StaxUtils.copy(reader2, (XMLStreamWriter)writer);
                        source = new DOMSource(writer.getDocument().getDocumentElement());
                        reader2 = StaxUtils.createXMLStreamReader(writer.getDocument());
                    }
                    catch (ParserConfigurationException e3) {
                        throw new Fault(e3);
                    }
                    catch (XMLStreamException e4) {
                        throw new Fault(e4);
                    }
                }
                message.setContent(XMLStreamReader.class, reader2);
                message.setContent(Source.class, source);
            } else if (!(source instanceof DOMSource)) {
                W3CDOMStreamWriter writer;
                try {
                    writer = new W3CDOMStreamWriter();
                }
                catch (ParserConfigurationException e5) {
                    throw new Fault(e5);
                }
                XMLStreamReader reader3 = message.getContent(XMLStreamReader.class);
                if (reader3 == null) {
                    reader3 = StaxUtils.createXMLStreamReader(source);
                }
                try {
                    StaxUtils.copy(reader3, (XMLStreamWriter)writer);
                }
                catch (XMLStreamException e6) {
                    throw new Fault(e6);
                }
                source = new DOMSource(writer.getDocument().getDocumentElement());
                reader3 = StaxUtils.createXMLStreamReader(writer.getDocument());
                message.setContent(XMLStreamReader.class, reader3);
                message.setContent(Source.class, source);
            }
        }
        return source;
    }

    private Source handleDispatchProviderCase(Service.Mode mode) {
        Source source = null;
        Message message = this.msgContext.getWrappedMessage();
        Source obj = message.getContent(Source.class);
        if (message instanceof SoapMessage) {
            CachedOutputStream cos;
            if (obj instanceof StreamSource) {
                try {
                    cos = new CachedOutputStream();
                    StaxUtils.copy(obj, (OutputStream)cos);
                    obj = new StreamSource(cos.getInputStream());
                    message.setContent(Source.class, new StreamSource(cos.getInputStream()));
                    cos.close();
                }
                catch (Exception e2) {
                    throw new Fault(e2);
                }
            }
            if (mode == Service.Mode.PAYLOAD) {
                source = obj;
            } else {
                try {
                    cos = new CachedOutputStream();
                    StaxUtils.copy(obj, (OutputStream)cos);
                    InputStream in2 = cos.getInputStream();
                    SOAPMessage msg = this.initSOAPMessage(in2);
                    source = new DOMSource(msg.getSOAPBody().getFirstChild());
                    in2.close();
                    cos.close();
                }
                catch (Exception e3) {
                    throw new Fault(e3);
                }
            }
        } else if (message instanceof XMLMessage) {
            if (obj != null) {
                source = obj;
            } else if (message.getContent(DataSource.class) != null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("GETPAYLOAD_OF_DATASOURCE_NOT_VALID_XMLHTTPBINDING", LOG, new Object[0]));
            }
        }
        return source;
    }

    public void setPayload(Source s2) {
        Message message = this.msgContext.getWrappedMessage();
        Service.Mode mode = (Service.Mode)this.msgContext.getWrappedMessage().getContextualProperty(Service.Mode.class.getName());
        if (mode != null) {
            if (message instanceof SoapMessage) {
                if (mode == Service.Mode.MESSAGE) {
                    try {
                        SOAPMessage msg = this.initSOAPMessage(null);
                        this.write(s2, (Node)msg.getSOAPBody());
                        s2 = new DOMSource((Node)msg.getSOAPPart());
                    }
                    catch (Exception e2) {
                        throw new Fault(e2);
                    }
                }
            } else if (message instanceof XMLMessage && message.getContent(DataSource.class) != null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("GETPAYLOAD_OF_DATASOURCE_NOT_VALID_XMLHTTPBINDING", LOG, new Object[0]));
            }
        } else {
            XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(s2);
            this.msgContext.getWrappedMessage().setContent(XMLStreamReader.class, reader2);
        }
        this.msgContext.getWrappedMessage().setContent(Source.class, s2);
    }

    public Object getPayload(JAXBContext arg0) {
        try {
            return arg0.createUnmarshaller().unmarshal(this.getPayload());
        }
        catch (JAXBException e2) {
            throw new WebServiceException((Throwable)e2);
        }
    }

    public void setPayload(Object arg0, JAXBContext arg1) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            arg1.createMarshaller().marshal(arg0, (XMLStreamWriter)writer);
            DOMSource source = new DOMSource(writer.getDocument().getDocumentElement());
            this.setPayload(source);
        }
        catch (ParserConfigurationException e2) {
            throw new WebServiceException((Throwable)e2);
        }
        catch (JAXBException e3) {
            throw new WebServiceException((Throwable)e3);
        }
    }

    private void write(Source source, Node n) {
        try {
            if (source instanceof DOMSource && ((DOMSource)source).getNode() == null) {
                return;
            }
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Element)n);
            StaxUtils.copy(source, (XMLStreamWriter)writer);
        }
        catch (XMLStreamException e2) {
            throw new Fault(e2);
        }
    }

    private SOAPMessage initSOAPMessage(InputStream is2) throws SOAPException, IOException {
        SOAPMessage msg = null;
        msg = is2 != null ? SAAJFactoryResolver.createMessageFactory(null).createMessage(null, is2) : SAAJFactoryResolver.createMessageFactory(null).createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return msg;
    }
}

