/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(WrapperClassInInterceptor.class);

    public WrapperClassInInterceptor() {
        super("post-logical");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Class<?> retType;
        Exchange ex2 = message.getExchange();
        BindingOperationInfo boi = ex2.getBindingOperationInfo();
        if (Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response")) || boi == null) {
            return;
        }
        Method method = ex2.get(Method.class);
        if (method != null && method.getName().endsWith("Async") && ((retType = method.getReturnType()).getName().equals("java.util.concurrent.Future") || retType.getName().equals("javax.xml.ws.Response"))) {
            return;
        }
        if (boi != null && boi.isUnwrappedCapable()) {
            MessageContentsList newParams;
            BindingMessageInfo bmi;
            MessageInfo messageInfo;
            BindingOperationInfo boi2 = boi.getUnwrappedOperation();
            OperationInfo op = boi2.getOperationInfo();
            MessageInfo wrappedMessageInfo = message.get(MessageInfo.class);
            if (wrappedMessageInfo == boi.getOperationInfo().getInput()) {
                messageInfo = op.getInput();
                bmi = boi2.getInput();
            } else {
                messageInfo = op.getOutput();
                bmi = boi2.getOutput();
            }
            MessageContentsList lst = MessageContentsList.getContentsList(message);
            if (lst == null) {
                return;
            }
            if (lst != null) {
                message.put(MessageInfo.class, messageInfo);
                message.put(BindingMessageInfo.class, bmi);
                ex2.put(BindingOperationInfo.class, boi2);
                ex2.put(OperationInfo.class, op);
            }
            if (this.isGET(message)) {
                LOG.fine("WrapperClassInInterceptor skipped in HTTP GET method");
                return;
            }
            MessagePartInfo wrapperPart = wrappedMessageInfo.getMessagePart(0);
            Class<?> wrapperClass = wrapperPart.getTypeClass();
            Object wrappedObject = lst.get(wrapperPart.getIndex());
            if (wrapperClass != null && !wrapperClass.isInstance(wrappedObject)) {
                wrappedObject = null;
                wrapperPart = null;
                wrapperClass = null;
            }
            if (wrapperClass == null || wrappedObject == null) {
                return;
            }
            WrapperHelper helper2 = wrapperPart.getProperty("WRAPPER_CLASS", WrapperHelper.class);
            if (helper2 == null) {
                Service service = ServiceModelUtil.getService(message.getExchange());
                DataBinding dataBinding = service.getDataBinding();
                if (dataBinding instanceof WrapperCapableDatabinding) {
                    helper2 = this.createWrapperHelper((WrapperCapableDatabinding)((Object)dataBinding), messageInfo, wrappedMessageInfo, wrapperClass);
                    wrapperPart.setProperty("WRAPPER_CLASS", helper2);
                } else {
                    return;
                }
            }
            try {
                newParams = new MessageContentsList(helper2.getWrapperParts(wrappedObject));
                ArrayList<Integer> removes = null;
                int count2 = 0;
                for (MessagePartInfo part : messageInfo.getMessageParts()) {
                    if (Boolean.TRUE.equals(part.getProperty("messagepart.isheader"))) {
                        MessagePartInfo mpi = wrappedMessageInfo.getMessagePart(part.getName());
                        if (lst.hasValue(mpi)) {
                            ++count2;
                            newParams.put(part, lst.get(mpi));
                            continue;
                        }
                        if (mpi.getTypeClass() != null) continue;
                        if (removes == null) {
                            removes = new ArrayList<Integer>();
                        }
                        removes.add(part.getIndex());
                        continue;
                    }
                    ++count2;
                }
                if (count2 == 0) {
                    newParams.clear();
                } else if (removes != null) {
                    Collections.sort(removes, Collections.reverseOrder());
                    for (Integer i : removes) {
                        if (i >= newParams.size()) continue;
                        newParams.remove(i);
                    }
                }
            }
            catch (Exception e2) {
                throw new Fault(e2);
            }
            message.setContent(List.class, newParams);
        }
    }

    private WrapperHelper createWrapperHelper(WrapperCapableDatabinding dataBinding, MessageInfo messageInfo, MessageInfo wrappedMessageInfo, Class<?> wrapperClass) {
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> elTypeNames = new ArrayList<String>();
        ArrayList partClasses = new ArrayList();
        QName wrapperName = null;
        for (MessagePartInfo p : wrappedMessageInfo.getMessageParts()) {
            if (wrapperClass != p.getTypeClass()) continue;
            wrapperName = p.getElementQName();
        }
        for (MessagePartInfo p : messageInfo.getMessageParts()) {
            if (Boolean.TRUE.equals(p.getProperty("messagepart.isheader"))) {
                if (p.getTypeClass() == null) continue;
                int idx = p.getIndex();
                this.ensureSize(elTypeNames, idx);
                this.ensureSize(partClasses, idx);
                this.ensureSize(partNames, idx);
                elTypeNames.set(idx, null);
                partClasses.set(idx, null);
                partNames.set(idx, null);
                continue;
            }
            String elementType2 = null;
            elementType2 = p.getTypeQName() == null ? null : p.getTypeQName().getLocalPart();
            int idx = p.getIndex();
            this.ensureSize(elTypeNames, idx);
            this.ensureSize(partClasses, idx);
            this.ensureSize(partNames, idx);
            elTypeNames.set(idx, elementType2);
            partClasses.set(idx, p.getTypeClass());
            partNames.set(idx, p.getName().getLocalPart());
        }
        return dataBinding.createWrapperHelper(wrapperClass, wrapperName, partNames, elTypeNames, partClasses);
    }

    private void ensureSize(List<?> lst, int idx) {
        while (idx >= lst.size()) {
            lst.add(null);
        }
    }
}

