/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public WrapperClassOutInterceptor() {
        super("pre-logical");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Exchange ex2 = message.getExchange();
        BindingOperationInfo bop = ex2.getBindingOperationInfo();
        MessageInfo messageInfo = message.get(MessageInfo.class);
        if (messageInfo == null || bop == null || !bop.isUnwrapped()) {
            return;
        }
        BindingOperationInfo newbop = bop.getWrappedOperation();
        MessageInfo wrappedMsgInfo = Boolean.TRUE.equals(message.get("org.apache.cxf.client")) ? newbop.getInput().getMessageInfo() : newbop.getOutput().getMessageInfo();
        Class<?> wrapped = null;
        List<MessagePartInfo> parts = wrappedMsgInfo.getMessageParts();
        if (parts.size() > 0) {
            wrapped = parts.get(0).getTypeClass();
        }
        if (wrapped != null) {
            MessageContentsList objs = MessageContentsList.getContentsList(message);
            WrapperHelper helper2 = parts.get(0).getProperty("WRAPPER_CLASS", WrapperHelper.class);
            if (helper2 == null) {
                Service service = ServiceModelUtil.getService(message.getExchange());
                DataBinding dataBinding = service.getDataBinding();
                if (dataBinding instanceof WrapperCapableDatabinding) {
                    helper2 = this.createWrapperHelper((WrapperCapableDatabinding)((Object)dataBinding), messageInfo, wrappedMsgInfo, wrapped);
                    parts.get(0).setProperty("WRAPPER_CLASS", helper2);
                } else {
                    return;
                }
            }
            try {
                MessageContentsList newObjs = new MessageContentsList();
                Object en = message.getContextualProperty("schema-validation-enabled");
                if (Boolean.TRUE.equals(en) || "true".equals(en)) {
                    try {
                        Class<?> xmlBeanWrapperHelperClass = Class.forName("org.apache.cxf.xmlbeans.XmlBeansWrapperHelper");
                        if (xmlBeanWrapperHelperClass.isInstance(helper2)) {
                            Method method = xmlBeanWrapperHelperClass.getMethod("setValidate", Boolean.TYPE);
                            method.invoke((Object)helper2, true);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Object o2 = helper2.createWrapperObject(objs);
                newObjs.put(parts.get(0), o2);
                for (MessagePartInfo p : messageInfo.getMessageParts()) {
                    if (!Boolean.TRUE.equals(p.getProperty("messagepart.isheader"))) continue;
                    MessagePartInfo mpi = wrappedMsgInfo.getMessagePart(p.getName());
                    if (!objs.hasValue(p)) continue;
                    newObjs.put(mpi, objs.get(p));
                }
                message.setContent(List.class, newObjs);
            }
            catch (Fault f2) {
                throw f2;
            }
            catch (Exception e2) {
                throw new Fault(e2);
            }
            ex2.put(BindingOperationInfo.class, newbop);
            ex2.put(OperationInfo.class, newbop.getOperationInfo());
            if (messageInfo == bop.getOperationInfo().getInput()) {
                message.put(MessageInfo.class, newbop.getOperationInfo().getInput());
                message.put(BindingMessageInfo.class, newbop.getInput());
            } else if (messageInfo == bop.getOperationInfo().getOutput()) {
                message.put(MessageInfo.class, newbop.getOperationInfo().getOutput());
                message.put(BindingMessageInfo.class, newbop.getOutput());
            }
        }
    }

    private void ensureSize(List<?> lst, int idx) {
        while (idx >= lst.size()) {
            lst.add(null);
        }
    }

    private WrapperHelper createWrapperHelper(WrapperCapableDatabinding dataBinding, MessageInfo messageInfo, MessageInfo wrappedMessageInfo, Class<?> wrapperClass) {
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> elTypeNames = new ArrayList<String>();
        ArrayList partClasses = new ArrayList();
        QName wrapperName = null;
        for (MessagePartInfo p : wrappedMessageInfo.getMessageParts()) {
            if (p.getTypeClass() != wrapperClass) continue;
            wrapperName = p.getElementQName();
        }
        for (MessagePartInfo p : messageInfo.getMessageParts()) {
            this.ensureSize(partNames, p.getIndex());
            this.ensureSize(elTypeNames, p.getIndex());
            this.ensureSize(partClasses, p.getIndex());
            partNames.set(p.getIndex(), p.getName().getLocalPart());
            String elementType2 = null;
            elementType2 = p.getTypeQName() == null ? null : p.getTypeQName().getLocalPart();
            elTypeNames.set(p.getIndex(), elementType2);
            partClasses.set(p.getIndex(), p.getTypeClass());
        }
        return dataBinding.createWrapperHelper(wrapperClass, wrapperName, partNames, elTypeNames, partClasses);
    }
}

