/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class EndpointDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final Class<?> EP_CLASS;
    private static final String IMPLEMENTOR = "implementor";

    public EndpointDefinitionParser() {
        this.setBeanClass(EP_CLASS);
    }

    protected String getSuffix() {
        return ".jaxws-endpoint";
    }

    protected void doParse(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean isAbstract = false;
        boolean publish2 = true;
        NamedNodeMap atts = element2.getAttributes();
        String bus = element2.getAttribute("bus");
        if (StringUtils.isEmpty(bus)) {
            this.addBusWiringAttribute(bean, BusWiringType.CONSTRUCTOR);
        } else {
            bean.addConstructorArgReference(bus);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node4 = (Attr)atts.item(i);
            String val = node4.getValue();
            String pre = node4.getPrefix();
            String name = node4.getLocalName();
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                isAbstract = true;
                continue;
            }
            if (this.isAttribute(pre, name) && !"publish".equals(name) && !"bus".equals(name)) {
                if ("endpointName".equals(name) || "serviceName".equals(name)) {
                    QName q = this.parseQName(element2, val);
                    bean.addPropertyValue(name, q);
                    continue;
                }
                if ("depends-on".equals(name)) {
                    bean.addDependsOn(val);
                    continue;
                }
                if (IMPLEMENTOR.equals(name)) {
                    this.loadImplementor(bean, val);
                    continue;
                }
                if ("name".equals(name)) continue;
                this.mapToProperty(bean, name, val);
                continue;
            }
            if ("abstract".equals(name)) {
                bean.setAbstract(true);
                isAbstract = true;
                continue;
            }
            if (!"publish".equals(name)) continue;
            publish2 = "true".equals(val);
        }
        Element elem2 = DOMUtils.getFirstElement(element2);
        while (elem2 != null) {
            String name = elem2.getLocalName();
            if ("properties".equals(name)) {
                Map map3 = ctx.getDelegate().parseMapElement(elem2, bean.getBeanDefinition());
                bean.addPropertyValue("properties", map3);
            } else if ("binding".equals(name)) {
                this.setFirstChildAsProperty(elem2, ctx, bean, "bindingConfig");
            } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
                List list2 = ctx.getDelegate().parseListElement(elem2, bean.getBeanDefinition());
                bean.addPropertyValue(name, list2);
            } else if (IMPLEMENTOR.equals(name)) {
                ctx.getDelegate().parseConstructorArgElement(elem2, bean.getBeanDefinition());
            } else {
                this.setFirstChildAsProperty(elem2, ctx, bean, name);
            }
            elem2 = DOMUtils.getNextElement(elem2);
        }
        if (!isAbstract) {
            if (publish2) {
                bean.setInitMethodName("publish");
            }
            bean.setDestroyMethodName("stop");
        }
        bean.setLazyInit(false);
    }

    private void loadImplementor(BeanDefinitionBuilder bean, String val) {
        if (!StringUtils.isEmpty(val)) {
            if (val.startsWith("#")) {
                bean.addConstructorArgReference(val.substring(1));
            } else {
                try {
                    Object obj = ClassLoaderUtils.loadClass(val, this.getClass()).newInstance();
                    bean.addConstructorArg(obj);
                }
                catch (Exception e2) {
                    throw new FatalBeanException("Could not load class: " + val, e2);
                }
            }
        }
    }

    protected String resolveId(Element elem2, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id2 = super.resolveId(elem2, definition, ctx);
        if (StringUtils.isEmpty(id2)) {
            id2 = EndpointImpl.class.getName() + "--" + definition.hashCode();
        }
        return id2;
    }

    static {
        Class cls = SpringEndpointImpl.class;
        try {
            if (ProviderImpl.isJaxWs22()) {
                cls = ClassLoaderUtils.loadClass("org.apache.cxf.jaxws22.spring.JAXWS22SpringEndpointImpl", EndpointDefinitionParser.class);
            }
        }
        catch (Throwable t2) {
            cls = SpringEndpointImpl.class;
        }
        EP_CLASS = cls;
    }

    @NoJSR250Annotations
    public static class SpringEndpointImpl
    extends EndpointImpl
    implements ApplicationContextAware {
        public SpringEndpointImpl(Object o) {
            super(o instanceof Bus ? (Bus)o : null, o instanceof Bus ? null : o);
        }

        public SpringEndpointImpl(Bus bus, Object implementor) {
            super(bus, implementor);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus(ctx));
            }
        }
    }
}

