/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.ServiceImpl;

public final class ServiceDelegateAccessor {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceDelegateAccessor.class);
    private static final String DELEGATE_FIELD_NAME = "delegate";
    private static final String DELEGATE_FIELD_NAME2 = "_delegate";

    private ServiceDelegateAccessor() {
    }

    public static ServiceImpl get(Service service) {
        ServiceImpl delegate = null;
        try {
            Field delegateField = Service.class.getDeclaredField(DELEGATE_FIELD_NAME);
            delegateField.setAccessible(true);
            delegate = (ServiceImpl)((Object)delegateField.get(service));
        }
        catch (Exception e2) {
            try {
                Field delegateField = Service.class.getDeclaredField(DELEGATE_FIELD_NAME2);
                delegateField.setAccessible(true);
                delegate = (ServiceImpl)((Object)delegateField.get(service));
            }
            catch (Exception e22) {
                WebServiceException wse = new WebServiceException("Failed to access Field named delegate of Service instance " + service, (Throwable)e2);
                LOG.log(Level.SEVERE, e2.getMessage(), e2);
                throw wse;
            }
        }
        return delegate;
    }
}

