/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvoker
implements Invoker {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractInvoker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Exchange exchange, Object o) {
        Object serviceObject = this.getServiceObject(exchange);
        try {
            Method m;
            BindingOperationInfo bop = exchange.get(BindingOperationInfo.class);
            MethodDispatcher md = (MethodDispatcher)exchange.get(Service.class).get(MethodDispatcher.class.getName());
            Method method = m = bop == null ? null : md.getMethod(bop);
            if (m == null && bop == null) {
                LOG.severe(new Message("MISSING_BINDING_OPERATION", LOG, new Object[0]).toString());
                throw new Fault(new Message("EXCEPTION_INVOKING_OBJECT", LOG, "No binding operation info", "unknown method", "unknown"));
            }
            m = AbstractInvoker.matchMethod(m, serviceObject);
            MessageContentsList params2 = null;
            if (o instanceof List) {
                params2 = CastUtils.cast((List)o);
            } else if (o != null) {
                params2 = new MessageContentsList(o);
            }
            Object object = this.invoke(exchange, serviceObject, m, params2);
            return object;
        }
        finally {
            this.releaseServiceObject(exchange, serviceObject);
        }
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params2) {
        try {
            Object[] paramArray = new Object[]{};
            if (params2 != null) {
                paramArray = params2.toArray();
            }
            Object res = this.performInvocation(exchange, serviceObject, m, paramArray);
            if (exchange.isOneWay()) {
                return null;
            }
            return new MessageContentsList(res);
        }
        catch (InvocationTargetException e2) {
            Throwable t2 = e2.getCause();
            if (t2 == null) {
                t2 = e2;
            }
            this.checkSuspendedInvocation(exchange, serviceObject, m, params2, t2);
            exchange.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            for (Class<?> cl : m.getExceptionTypes()) {
                if (!cl.isInstance(t2)) continue;
                exchange.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
            }
            if (t2 instanceof Fault) {
                exchange.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
                throw (Fault)t2;
            }
            throw this.createFault(t2, m, params2, true);
        }
        catch (SuspendedInvocationException suspendedEx) {
            this.checkSuspendedInvocation(exchange, serviceObject, m, params2, suspendedEx);
            throw suspendedEx;
        }
        catch (Fault f2) {
            exchange.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw f2;
        }
        catch (Exception e3) {
            this.checkSuspendedInvocation(exchange, serviceObject, m, params2, e3);
            exchange.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(e3, m, params2, false);
        }
    }

    protected void checkSuspendedInvocation(Exchange exchange, Object serviceObject, Method m, List<Object> params2, Throwable t2) {
        if (t2 instanceof SuspendedInvocationException) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "SUSPENDED_INVOCATION_EXCEPTION", new Object[]{serviceObject, m.toString(), params2});
            }
            throw (SuspendedInvocationException)t2;
        }
    }

    protected Fault createFault(Throwable ex2, Method m, List<Object> params2, boolean checked) {
        if (checked) {
            return new Fault(ex2);
        }
        String message = ex2 == null ? "" : ex2.getMessage();
        String method = m == null ? "<null>" : m.toString();
        return new Fault(new Message("EXCEPTION_INVOKING_OBJECT", LOG, message, method, params2), ex2);
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        paramArray = this.insertExchange(m, paramArray, exchange);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "INVOKING_METHOD", new Object[]{serviceObject, m, Arrays.asList(paramArray)});
        }
        return m.invoke(serviceObject, paramArray);
    }

    public Object[] insertExchange(Method method, Object[] params2, Exchange context) {
        Object[] newParams = params2;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (!method.getParameterTypes()[i].equals(Exchange.class)) continue;
            newParams = new Object[params2.length + 1];
            for (int j = 0; j < newParams.length; ++j) {
                newParams[j] = j == i ? context : (j > i ? params2[j - 1] : params2[j]);
            }
        }
        return newParams;
    }

    public abstract Object getServiceObject(Exchange var1);

    public void releaseServiceObject(Exchange context, Object obj) {
    }

    private static Method matchMethod(Method methodToMatch, Object targetObject) {
        if (AbstractInvoker.isJdkDynamicProxy(targetObject)) {
            Class<?>[] interfaces2 = targetObject.getClass().getInterfaces();
            for (int i = 0; i < interfaces2.length; ++i) {
                Method m = AbstractInvoker.getMostSpecificMethod(methodToMatch, interfaces2[i]);
                if (methodToMatch.equals(m)) continue;
                return m;
            }
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

