/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OverlayW3CDOMStreamWriter
extends W3CDOMStreamWriter {
    List<Boolean> isOverlaidStack = new LinkedList<Boolean>();
    boolean isOverlaid = true;

    public OverlayW3CDOMStreamWriter(Document document2) {
        super(document2);
    }

    public OverlayW3CDOMStreamWriter(Element e2) {
        super(e2);
    }

    public void writeEndElement() throws XMLStreamException {
        this.isOverlaid = this.isOverlaidStack.remove(0);
        super.writeEndElement();
    }

    public void writeStartElement(String local) throws XMLStreamException {
        this.isOverlaidStack.add(0, this.isOverlaid);
        if (this.isOverlaid) {
            Element nd = this.getCurrentNode();
            Node nd2 = null;
            for (nd2 = nd == null ? this.getDocument().getDocumentElement() : nd.getFirstChild(); nd2 != null; nd2 = nd2.getNextSibling()) {
                if (nd2.getNodeType() != 1 || !local.equals(nd2.getLocalName()) || !StringUtils.isEmpty(nd2.getNamespaceURI())) continue;
                this.setChild((Element)nd2, false);
                return;
            }
        }
        this.isOverlaid = false;
        super.writeStartElement(local);
    }

    public void writeStartElement(String namespace, String local) throws XMLStreamException {
        this.isOverlaidStack.add(0, this.isOverlaid);
        if (this.isOverlaid) {
            Element nd = this.getCurrentNode();
            Node nd2 = null;
            for (nd2 = nd == null ? this.getDocument().getDocumentElement() : nd.getFirstChild(); nd2 != null; nd2 = nd2.getNextSibling()) {
                if (nd2.getNodeType() != 1 || !local.equals(nd2.getLocalName()) || !namespace.equals(nd2.getNamespaceURI())) continue;
                this.setChild((Element)nd2, false);
                return;
            }
        }
        this.isOverlaid = false;
        super.writeStartElement(namespace, local);
    }

    public void writeStartElement(String prefix2, String local, String namespace) throws XMLStreamException {
        if (prefix2 == null || prefix2.equals("")) {
            this.writeStartElement(namespace, local);
        } else {
            this.isOverlaidStack.add(0, this.isOverlaid);
            if (this.isOverlaid) {
                Element nd = this.getCurrentNode();
                Node nd2 = null;
                for (nd2 = nd == null ? this.getDocument().getDocumentElement() : nd.getFirstChild(); nd2 != null; nd2 = nd2.getNextSibling()) {
                    if (nd2.getNodeType() != 1 || !local.equals(nd2.getLocalName()) || !namespace.equals(nd2.getNamespaceURI())) continue;
                    this.setChild((Element)nd2, false);
                    return;
                }
            }
            this.isOverlaid = false;
            super.writeStartElement(prefix2, local, namespace);
        }
    }
}

