/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class StaxSource
extends SAXSource
implements XMLReader {
    private XMLStreamReader streamReader;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    public StaxSource(XMLStreamReader streamReader) {
        this.streamReader = streamReader;
        this.setInputSource(new InputSource());
    }

    public XMLReader getXMLReader() {
        return this;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.streamReader;
    }

    protected void parse() throws SAXException {
        try {
            while (true) {
                switch (this.streamReader.getEventType()) {
                    case 10: {
                        break;
                    }
                    case 12: {
                        if (this.lexicalHandler != null) {
                            this.lexicalHandler.startCDATA();
                        }
                        int length2 = this.streamReader.getTextLength();
                        int start2 = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.characters(chars, start2, length2);
                        if (this.lexicalHandler == null) break;
                        this.lexicalHandler.endCDATA();
                        break;
                    }
                    case 4: {
                        int length3 = this.streamReader.getTextLength();
                        int start3 = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.characters(chars, start3, length3);
                        break;
                    }
                    case 6: {
                        int length4 = this.streamReader.getTextLength();
                        int start4 = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.contentHandler.ignorableWhitespace(chars, start4, length4);
                        break;
                    }
                    case 5: {
                        if (this.lexicalHandler == null) break;
                        int length5 = this.streamReader.getTextLength();
                        int start5 = this.streamReader.getTextStart();
                        char[] chars = this.streamReader.getTextCharacters();
                        this.lexicalHandler.comment(chars, start5, length5);
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 8: {
                        this.contentHandler.endDocument();
                        return;
                    }
                    case 2: {
                        String uri = this.streamReader.getNamespaceURI();
                        String localName = this.streamReader.getLocalName();
                        String prefix2 = this.streamReader.getPrefix();
                        String qname = prefix2 != null && prefix2.length() > 0 ? prefix2 + ":" + localName : localName;
                        this.contentHandler.endElement(uri, localName, qname);
                        break;
                    }
                    case 9: 
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 7: {
                        this.contentHandler.startDocument();
                        break;
                    }
                    case 1: {
                        String uri = this.streamReader.getNamespaceURI();
                        String localName = this.streamReader.getLocalName();
                        String prefix2 = this.streamReader.getPrefix();
                        String qname = prefix2 != null && prefix2.length() > 0 ? prefix2 + ":" + localName : localName;
                        this.contentHandler.startElement(uri == null ? "" : uri, localName, qname, this.getAttributes());
                        break;
                    }
                }
                if (!this.streamReader.hasNext()) {
                    return;
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException e2) {
            SAXParseException spe = e2.getLocation() != null ? new SAXParseException(e2.getMessage(), null, null, e2.getLocation().getLineNumber(), e2.getLocation().getColumnNumber(), e2) : new SAXParseException(e2.getMessage(), null, null, -1, -1, e2);
            spe.initCause(e2);
            throw spe;
        }
    }

    protected String getQualifiedName() {
        String prefix2 = this.streamReader.getPrefix();
        if (prefix2 != null && prefix2.length() > 0) {
            return prefix2 + ":" + this.streamReader.getLocalName();
        }
        return this.streamReader.getLocalName();
    }

    protected Attributes getAttributes() {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        for (i = 0; i < this.streamReader.getNamespaceCount(); ++i) {
            String prefix2 = this.streamReader.getNamespacePrefix(i);
            String uri = this.streamReader.getNamespaceURI(i);
            if (uri == null) {
                uri = "";
            }
            if (prefix2 == null || prefix2.length() == 0) {
                attrs.addAttribute("", null, "xmlns", "CDATA", uri);
                continue;
            }
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix2, "xmlns:" + prefix2, "CDATA", uri);
        }
        for (i = 0; i < this.streamReader.getAttributeCount(); ++i) {
            String uri = this.streamReader.getAttributeNamespace(i);
            String localName = this.streamReader.getAttributeLocalName(i);
            String prefix3 = this.streamReader.getAttributePrefix(i);
            String qName = prefix3 != null && prefix3.length() > 0 ? prefix3 + ':' + localName : localName;
            String type = this.streamReader.getAttributeType(i);
            String value2 = this.streamReader.getAttributeValue(i);
            if (value2 == null) {
                value2 = "";
            }
            attrs.addAttribute(uri == null ? "" : uri, localName, qName, type, value2);
        }
        return attrs;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value2) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!"http://xml.org/sax/properties/lexical-handler".equals(name)) {
            throw new SAXNotRecognizedException(name);
        }
        this.lexicalHandler = (LexicalHandler)value2;
    }

    public void setEntityResolver(EntityResolver resolver2) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource input2) throws SAXException {
        this.parse();
    }

    public void parse(String systemId) throws SAXException {
        this.parse();
    }
}

