/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StreamWriterContentHandler;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class StaxUtils {
    private static final Logger LOG;
    private static final BlockingQueue<XMLInputFactory> NS_AWARE_INPUT_FACTORY_POOL;
    private static final BlockingQueue<XMLOutputFactory> OUTPUT_FACTORY_POOL;
    private static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    private static final String[] DEF_PREFIXES;
    private static int innerElementLevelThreshold;
    private static int innerElementCountThreshold;

    private StaxUtils() {
    }

    public static boolean isWoodstox() {
        try {
            ClassLoaderUtils.loadClass("org.codehaus.stax2.XMLStreamReader2", StaxUtils.class);
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return true;
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory f2 = (XMLInputFactory)NS_AWARE_INPUT_FACTORY_POOL.poll();
        if (f2 == null) {
            f2 = StaxUtils.createXMLInputFactory(true);
        }
        return f2;
    }

    private static void returnXMLInputFactory(XMLInputFactory factory) {
        NS_AWARE_INPUT_FACTORY_POOL.offer(factory);
    }

    private static XMLOutputFactory getXMLOutputFactory() {
        XMLOutputFactory f2 = (XMLOutputFactory)OUTPUT_FACTORY_POOL.poll();
        if (f2 == null) {
            f2 = XMLOutputFactory.newInstance();
        }
        return f2;
    }

    private static void returnXMLOutputFactory(XMLOutputFactory factory) {
        OUTPUT_FACTORY_POOL.offer(factory);
    }

    public static XMLInputFactory createXMLInputFactory(boolean nsAware) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", nsAware);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setXMLResolver(new XMLResolver(){

            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("Reading external entities is disabled");
            }
        });
        return factory;
    }

    public static XMLStreamWriter createXMLStreamWriter(Writer out) {
        XMLStreamWriter xMLStreamWriter;
        XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
        try {
            xMLStreamWriter = factory.createXMLStreamWriter(out);
            Object var4_4 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Cant' create XMLStreamWriter", e2);
            }
            catch (Throwable throwable2) {
                Object var4_5 = null;
                StaxUtils.returnXMLOutputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLOutputFactory(factory);
        return xMLStreamWriter;
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return StaxUtils.createXMLStreamWriter(out, null);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        XMLStreamWriter xMLStreamWriter;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
        try {
            xMLStreamWriter = factory.createXMLStreamWriter(out, encoding);
            Object var5_5 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Cant' create XMLStreamWriter", e2);
            }
            catch (Throwable throwable2) {
                Object var5_6 = null;
                StaxUtils.returnXMLOutputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLOutputFactory(factory);
        return xMLStreamWriter;
    }

    public static XMLStreamWriter createXMLStreamWriter(Result r) {
        XMLStreamWriter xMLStreamWriter;
        XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
        try {
            xMLStreamWriter = factory.createXMLStreamWriter(r);
            Object var4_4 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Cant' create XMLStreamWriter", e2);
            }
            catch (Throwable throwable2) {
                Object var4_5 = null;
                StaxUtils.returnXMLOutputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLOutputFactory(factory);
        return xMLStreamWriter;
    }

    public static XMLStreamReader createFilteredReader(XMLStreamReader reader2, StreamFilter filter2) {
        XMLStreamReader xMLStreamReader;
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            xMLStreamReader = factory.createFilteredReader(reader2, filter2);
            Object var5_5 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Cant' create XMLStreamReader", e2);
            }
            catch (Throwable throwable2) {
                Object var5_6 = null;
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    public static void nextEvent(XMLStreamReader dr) {
        try {
            dr.next();
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException("Couldn't parse stream.", e2);
        }
    }

    public static boolean toNextText(DepthXMLStreamReader reader2) {
        if (reader2.getEventType() == 4) {
            return true;
        }
        try {
            int depth = reader2.getDepth();
            int event = reader2.getEventType();
            while (reader2.getDepth() >= depth && reader2.hasNext()) {
                if (event == 4 && reader2.getDepth() == depth + 1) {
                    return true;
                }
                event = reader2.next();
            }
            return false;
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException("Couldn't parse stream.", e2);
        }
    }

    public static boolean toNextTag(XMLStreamReader reader2) {
        try {
            int x = reader2.getEventType();
            while (x != 1 && x != 2 && reader2.hasNext()) {
                x = reader2.next();
            }
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException("Couldn't parse stream.", e2);
        }
        return true;
    }

    public static boolean toNextTag(DepthXMLStreamReader reader2, QName endTag2) {
        try {
            int depth = reader2.getDepth();
            int event = reader2.getEventType();
            while (reader2.getDepth() >= depth && reader2.hasNext()) {
                if (event == 1 && reader2.getName().equals(endTag2) && reader2.getDepth() == depth + 1) {
                    return true;
                }
                event = reader2.next();
            }
            return false;
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException("Couldn't parse stream.", e2);
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, String prefix2, String name, String namespace) throws XMLStreamException {
        if (prefix2 == null) {
            prefix2 = "";
        }
        if (namespace.length() > 0) {
            writer.writeStartElement(prefix2, name, namespace);
            if (prefix2.length() > 0) {
                writer.writeNamespace(prefix2, namespace);
                writer.setPrefix(prefix2, namespace);
            } else {
                writer.writeDefaultNamespace(namespace);
                writer.setDefaultNamespace(namespace);
            }
        } else {
            writer.writeStartElement(name);
            writer.writeDefaultNamespace("");
            writer.setDefaultNamespace("");
        }
    }

    public static boolean skipToStartOfElement(XMLStreamReader in2) throws XMLStreamException {
        int code2 = in2.getEventType();
        while (code2 != 8) {
            if (code2 == 1) {
                return true;
            }
            code2 = in2.next();
        }
        return false;
    }

    public static boolean toNextElement(DepthXMLStreamReader dr) {
        if (dr.getEventType() == 1) {
            return true;
        }
        if (dr.getEventType() == 2) {
            return false;
        }
        try {
            int depth = dr.getDepth();
            int event = dr.getEventType();
            while (dr.getDepth() >= depth && dr.hasNext()) {
                if (event == 1 && dr.getDepth() == depth + 1) {
                    return true;
                }
                if (event == 2) {
                    --depth;
                }
                event = dr.next();
            }
            return false;
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException("Couldn't parse stream.", e2);
        }
    }

    public static boolean skipToStartOfElement(DepthXMLStreamReader in2) throws XMLStreamException {
        int code2 = in2.getEventType();
        while (code2 != 8) {
            if (code2 == 1) {
                return true;
            }
            code2 = in2.next();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Source source, OutputStream os2) throws XMLStreamException {
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(os2);
        try {
            StaxUtils.copy(source, writer);
            Object var4_3 = null;
        }
        catch (Throwable throwable2) {
            Object var4_4 = null;
            try {
                writer.flush();
            }
            catch (XMLStreamException ex2) {
                // empty catch block
            }
            throw throwable2;
        }
        try {
            writer.flush();
        }
        catch (XMLStreamException ex2) {}
    }

    public static void copy(Source source, XMLStreamWriter writer) throws XMLStreamException {
        Source ss;
        InputSource src;
        if (source instanceof SAXSource && ((src = ((SAXSource)(ss = (SAXSource)source)).getInputSource()) == null || src.getSystemId() == null && src.getPublicId() == null)) {
            if (((SAXSource)ss).getXMLReader() != null) {
                StreamWriterContentHandler ch = new StreamWriterContentHandler(writer);
                XMLReader reader2 = ((SAXSource)source).getXMLReader();
                reader2.setContentHandler(ch);
                try {
                    try {
                        reader2.setFeature("http://xml.org/sax/features/namespaces", true);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    reader2.parse(((SAXSource)source).getInputSource());
                    return;
                }
                catch (Exception e2) {
                    throw new XMLStreamException(e2);
                }
            }
            if (((SAXSource)ss).getInputSource() == null) {
                return;
            }
        }
        if (source instanceof StreamSource && ((StreamSource)(ss = (StreamSource)source)).getInputStream() == null && ((StreamSource)ss).getReader() == null && ((StreamSource)ss).getSystemId() == null) {
            return;
        }
        XMLStreamReader reader3 = StaxUtils.createXMLStreamReader(source);
        StaxUtils.copy(reader3, writer);
        reader3.close();
    }

    public static Document copy(Document doc) throws XMLStreamException, ParserConfigurationException {
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(doc);
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        StaxUtils.copy(reader2, (XMLStreamWriter)writer);
        Document d = writer.getDocument();
        try {
            d.setDocumentURI(doc.getDocumentURI());
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return d;
    }

    public static void copy(Document doc, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(doc);
        StaxUtils.copy(reader2, writer);
    }

    public static void copy(Element node4, XMLStreamWriter writer) throws XMLStreamException {
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(node4);
        StaxUtils.copy(reader2, writer);
    }

    public static void copy(XMLStreamReader reader2, OutputStream os2) throws XMLStreamException {
        XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter(os2);
        StaxUtils.copy(reader2, xsw);
        xsw.close();
    }

    public static void copy(XMLStreamReader reader2, XMLStreamWriter writer) throws XMLStreamException {
        StaxUtils.copy(reader2, writer, false);
    }

    public static void copy(XMLStreamReader reader2, XMLStreamWriter writer, boolean fragment) throws XMLStreamException {
        int read2 = 0;
        int event = reader2.getEventType();
        while (reader2.hasNext()) {
            switch (event) {
                case 1: {
                    ++read2;
                    StaxUtils.writeStartElement(reader2, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read2 > 0 || fragment) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader2.getText());
                    break;
                }
                case 5: {
                    writer.writeComment(reader2.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader2.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader2.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader2, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String uri = reader2.getNamespaceURI();
        String prefix2 = reader2.getPrefix();
        String local = reader2.getLocalName();
        if (prefix2 == null) {
            prefix2 = "";
        }
        boolean writeElementNS = false;
        if (uri != null) {
            writeElementNS = true;
            Iterator it = CastUtils.cast(writer.getNamespaceContext().getPrefixes(uri));
            while (it != null && it.hasNext()) {
                String s2 = (String)it.next();
                if (s2 == null) {
                    s2 = "";
                }
                if (!s2.equals(prefix2)) continue;
                writeElementNS = false;
            }
        }
        if (uri != null) {
            if (prefix2.length() == 0 && StringUtils.isEmpty(uri)) {
                writer.writeStartElement(local);
            } else {
                writer.writeStartElement(prefix2, local, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        for (i = 0; i < reader2.getNamespaceCount(); ++i) {
            String nsURI = reader2.getNamespaceURI(i);
            nsPrefix = reader2.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsURI.length() > 0) {
                if (nsPrefix.length() == 0) {
                    writer.writeDefaultNamespace(nsURI);
                    writer.setDefaultNamespace(nsURI);
                } else {
                    writer.writeNamespace(nsPrefix, nsURI);
                    writer.setPrefix(nsPrefix, nsURI);
                }
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix2)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix2 == null || prefix2.length() == 0) {
                writer.writeDefaultNamespace(uri);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix2, uri);
                writer.setPrefix(prefix2, uri);
            }
        }
        for (i = 0; i < reader2.getAttributeCount(); ++i) {
            String ns = reader2.getAttributeNamespace(i);
            nsPrefix = reader2.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader2.getAttributeNamespace(i), reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
                continue;
            }
            Iterator it = CastUtils.cast(writer.getNamespaceContext().getPrefixes(ns));
            boolean writeNs = true;
            while (it != null && it.hasNext()) {
                String s3 = (String)it.next();
                if (s3 == null) {
                    s3 = "";
                }
                if (!s3.equals(nsPrefix)) continue;
                writeNs = false;
            }
            if (writeNs) {
                writer.writeNamespace(nsPrefix, ns);
                writer.setPrefix(nsPrefix, ns);
            }
            writer.writeAttribute(reader2.getAttributePrefix(i), reader2.getAttributeNamespace(i), reader2.getAttributeLocalName(i), reader2.getAttributeValue(i));
        }
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        StaxUtils.writeDocument(d, writer, true, repairing);
    }

    public static void writeDocument(Document d, XMLStreamWriter writer, boolean writeProlog, boolean repairing) throws XMLStreamException {
        if (writeProlog) {
            writer.writeStartDocument();
        }
        for (Node node4 = d.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (!writeProlog && node4.getNodeType() != 1) continue;
            StaxUtils.writeNode(node4, writer, repairing);
        }
        if (writeProlog) {
            writer.writeEndDocument();
        }
    }

    public static void writeElement(Element e2, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        StaxUtils.writeElement(e2, writer, repairing, true);
    }

    public static void writeElement(Element e2, XMLStreamWriter writer, boolean repairing, boolean endElement) throws XMLStreamException {
        boolean declareNamespace;
        String prefix2 = e2.getPrefix();
        String ns = e2.getNamespaceURI();
        String localName = e2.getLocalName();
        if (prefix2 == null) {
            prefix2 = "";
        }
        if (localName == null && (localName = e2.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = writer.getNamespaceContext().getNamespaceURI(prefix2);
        boolean bl = declareNamespace = decUri == null || !decUri.equals(ns);
        if (ns == null || ns.length() == 0) {
            writer.writeStartElement(localName);
            if (StringUtils.isEmpty(decUri)) {
                declareNamespace = false;
            }
        } else {
            writer.writeStartElement(prefix2, localName, ns);
        }
        NamedNodeMap attrs = e2.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getLocalName();
            String attrPrefix = attr.getPrefix();
            if (attrPrefix == null) {
                attrPrefix = "";
            }
            if (name == null) {
                name = attr.getNodeName();
            }
            if ("xmlns".equals(attrPrefix)) {
                writer.writeNamespace(name, attr.getNodeValue());
                writer.setPrefix(name, attr.getNodeValue());
                if (!name.equals(prefix2) || !attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            if ("xmlns".equals(name) && "".equals(attrPrefix)) {
                writer.writeDefaultNamespace(attr.getNodeValue());
                writer.setDefaultNamespace(attr.getNodeValue());
                if (attr.getNodeValue().equals(ns)) {
                    declareNamespace = false;
                    continue;
                }
                if (!StringUtils.isEmpty(attr.getNodeValue()) || !StringUtils.isEmpty(ns)) continue;
                declareNamespace = false;
                continue;
            }
            String attns = attr.getNamespaceURI();
            String value2 = attr.getNodeValue();
            if (attns == null || attns.length() == 0) {
                writer.writeAttribute(name, value2);
                continue;
            }
            if (attrPrefix == null || attrPrefix.length() == 0) {
                writer.writeAttribute(attns, name, value2);
                continue;
            }
            writer.writeAttribute(attrPrefix, attns, name, value2);
        }
        if (declareNamespace && repairing) {
            if (ns == null) {
                writer.writeNamespace(prefix2, "");
                writer.setPrefix(prefix2, "");
            } else {
                writer.writeNamespace(prefix2, ns);
                writer.setPrefix(prefix2, ns);
            }
        }
        for (Node nd = e2.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            StaxUtils.writeNode(nd, writer, repairing);
        }
        if (endElement) {
            writer.writeEndElement();
        }
    }

    public static void writeNode(Node n, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        switch (n.getNodeType()) {
            case 1: {
                StaxUtils.writeElement((Element)n, writer, repairing);
                break;
            }
            case 3: {
                writer.writeCharacters(((Text)n).getNodeValue());
                break;
            }
            case 8: {
                writer.writeComment(((Comment)n).getData());
                break;
            }
            case 4: {
                writer.writeCData(((CDATASection)n).getData());
                break;
            }
            case 5: {
                writer.writeEntityRef(((org.w3c.dom.EntityReference)n).getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 9: {
                StaxUtils.writeDocument((Document)n, writer, repairing);
                break;
            }
            case 11: {
                DocumentFragment frag = (DocumentFragment)n;
                for (Node child = frag.getFirstChild(); child != null; child = child.getNextSibling()) {
                    StaxUtils.writeNode(child, writer, repairing);
                }
                break;
            }
            case 10: {
                try {
                    if (((DocumentType)n).getTextContent() == null) break;
                    writer.writeDTD(((DocumentType)n).getTextContent());
                }
                catch (UnsupportedOperationException ex2) {}
                break;
            }
            default: {
                throw new IllegalStateException("Found type: " + n.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(Source s2) throws XMLStreamException {
        Document document2;
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(s2);
        try {
            document2 = StaxUtils.read(reader2);
            Object var4_3 = null;
        }
        catch (Throwable throwable2) {
            Object var4_4 = null;
            try {
                reader2.close();
            }
            catch (Exception ex2) {}
            throw throwable2;
        }
        try {
            reader2.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(InputStream s2) throws XMLStreamException {
        Document document2;
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(s2);
        try {
            document2 = StaxUtils.read(reader2);
            Object var4_3 = null;
        }
        catch (Throwable throwable2) {
            Object var4_4 = null;
            try {
                reader2.close();
            }
            catch (Exception ex2) {}
            throw throwable2;
        }
        try {
            reader2.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(InputSource s2) throws XMLStreamException {
        Document document2;
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(s2);
        try {
            document2 = StaxUtils.read(reader2);
            Object var4_3 = null;
        }
        catch (Throwable throwable2) {
            Object var4_4 = null;
            try {
                reader2.close();
            }
            catch (Exception ex2) {}
            throw throwable2;
        }
        try {
            reader2.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return document2;
    }

    public static Document read(XMLStreamReader reader2) throws XMLStreamException {
        return StaxUtils.read(reader2, false);
    }

    public static Document read(XMLStreamReader reader2, boolean recordLoc) throws XMLStreamException {
        Document doc = DOMUtils.createDocument();
        if (reader2.getLocation().getSystemId() != null) {
            try {
                doc.setDocumentURI(new String(reader2.getLocation().getSystemId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StaxUtils.readDocElements(doc, doc, reader2, true, recordLoc);
        return doc;
    }

    public static Document read(DocumentBuilder builder, XMLStreamReader reader2, boolean repairing) throws XMLStreamException {
        Document doc;
        Document document2 = doc = builder == null ? DOMUtils.createDocument() : builder.newDocument();
        if (reader2.getLocation().getSystemId() != null) {
            try {
                doc.setDocumentURI(new String(reader2.getLocation().getSystemId()));
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        StaxUtils.readDocElements(doc, reader2, repairing);
        return doc;
    }

    private static Document getDocument(Node parent2) {
        return parent2 instanceof Document ? (Document)parent2 : parent2.getOwnerDocument();
    }

    private static boolean isDeclared(Element e2, String namespaceURI, String prefix2) {
        while (e2 != null) {
            Attr att = prefix2 != null && prefix2.length() > 0 ? e2.getAttributeNodeNS(XML_NS, prefix2) : e2.getAttributeNode("xmlns");
            if (att != null && att.getNodeValue().equals(namespaceURI)) {
                return true;
            }
            if (e2.getParentNode() instanceof Element) {
                e2 = (Element)e2.getParentNode();
                continue;
            }
            if (StringUtils.isEmpty(prefix2) && StringUtils.isEmpty(namespaceURI)) {
                return true;
            }
            e2 = null;
        }
        return false;
    }

    public static void readDocElements(Node parent2, XMLStreamReader reader2, boolean repairing) throws XMLStreamException {
        Document doc = StaxUtils.getDocument(parent2);
        StaxUtils.readDocElements(doc, parent2, reader2, repairing, false);
    }

    public static void readDocElements(Node parent2, XMLStreamReader reader2, boolean repairing, boolean isThreshold) throws XMLStreamException {
        Document doc = StaxUtils.getDocument(parent2);
        StaxUtils.readDocElements(doc, parent2, reader2, repairing, false, isThreshold);
    }

    public static void readDocElements(Document doc, Node parent2, XMLStreamReader reader2, boolean repairing, boolean recordLoc) throws XMLStreamException {
        StaxUtils.readDocElements(doc, parent2, reader2, repairing, recordLoc, false);
    }

    public static void readDocElements(Document doc, Node parent2, XMLStreamReader reader2, boolean repairing, boolean recordLoc, boolean isThreshold) throws XMLStreamException {
        Stack<Node> stack = new Stack<Node>();
        int event = reader2.getEventType();
        int elementCount = 0;
        while (reader2.hasNext()) {
            switch (event) {
                case 1: {
                    String prefix2;
                    ++elementCount;
                    Element e2 = doc.createElementNS(reader2.getNamespaceURI(), reader2.getLocalName());
                    if (!StringUtils.isEmpty(reader2.getPrefix())) {
                        e2.setPrefix(reader2.getPrefix());
                    }
                    e2 = (Element)parent2.appendChild(e2);
                    recordLoc = StaxUtils.addLocation(doc, e2, reader2, recordLoc);
                    for (int ns = 0; ns < reader2.getNamespaceCount(); ++ns) {
                        String uri = reader2.getNamespaceURI(ns);
                        prefix2 = reader2.getNamespacePrefix(ns);
                        StaxUtils.declare(e2, uri, prefix2);
                    }
                    for (int att = 0; att < reader2.getAttributeCount(); ++att) {
                        String name = reader2.getAttributeLocalName(att);
                        prefix2 = reader2.getAttributePrefix(att);
                        if (prefix2 != null && prefix2.length() > 0) {
                            name = prefix2 + ":" + name;
                        }
                        Attr attr = doc.createAttributeNS(reader2.getAttributeNamespace(att), name);
                        attr.setValue(reader2.getAttributeValue(att));
                        e2.setAttributeNode(attr);
                    }
                    if (repairing && !StaxUtils.isDeclared(e2, reader2.getNamespaceURI(), reader2.getPrefix())) {
                        StaxUtils.declare(e2, reader2.getNamespaceURI(), reader2.getPrefix());
                    }
                    stack.push(parent2);
                    if (isThreshold && innerElementLevelThreshold != -1 && stack.size() >= innerElementLevelThreshold) {
                        throw new RuntimeException("reach the innerElementLevelThreshold:" + innerElementLevelThreshold);
                    }
                    if (isThreshold && innerElementCountThreshold != -1 && elementCount >= innerElementCountThreshold) {
                        throw new RuntimeException("reach the innerElementCountThreshold:" + innerElementCountThreshold);
                    }
                    parent2 = e2;
                    break;
                }
                case 2: {
                    if (stack.isEmpty()) {
                        return;
                    }
                    parent2 = (Node)stack.pop();
                    if (!(parent2 instanceof Document)) break;
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent2 == null) break;
                    recordLoc = StaxUtils.addLocation(doc, parent2.appendChild(doc.createTextNode(reader2.getText())), reader2, recordLoc);
                    break;
                }
                case 5: {
                    if (parent2 == null) break;
                    parent2.appendChild(doc.createComment(reader2.getText()));
                    break;
                }
                case 12: {
                    recordLoc = StaxUtils.addLocation(doc, parent2.appendChild(doc.createCDATASection(reader2.getText())), reader2, recordLoc);
                    break;
                }
                case 3: {
                    parent2.appendChild(doc.createProcessingInstruction(reader2.getPITarget(), reader2.getPIData()));
                    break;
                }
                case 9: {
                    parent2.appendChild(doc.createProcessingInstruction(reader2.getPITarget(), reader2.getPIData()));
                    break;
                }
            }
            if (!reader2.hasNext()) continue;
            event = reader2.next();
        }
    }

    private static boolean addLocation(Document doc, Node node4, XMLStreamReader reader2, boolean recordLoc) {
        Location loc;
        if (recordLoc && (loc = reader2.getLocation()) != null && (loc.getColumnNumber() != 0 || loc.getLineNumber() != 0)) {
            try {
                final int charOffset = loc.getCharacterOffset();
                final int colNum = loc.getColumnNumber();
                final int linNum = loc.getLineNumber();
                final String pubId = loc.getPublicId() == null ? doc.getDocumentURI() : loc.getPublicId();
                final String sysId = loc.getSystemId() == null ? doc.getDocumentURI() : loc.getSystemId();
                Location loc2 = new Location(){

                    public int getCharacterOffset() {
                        return charOffset;
                    }

                    public int getColumnNumber() {
                        return colNum;
                    }

                    public int getLineNumber() {
                        return linNum;
                    }

                    public String getPublicId() {
                        return pubId;
                    }

                    public String getSystemId() {
                        return sysId;
                    }
                };
                node4.setUserData("location", loc2, new UserDataHandler(){

                    public void handle(short operation, String key, Object data2, Node src, Node dst) {
                        if (operation == 1) {
                            dst.setUserData(key, data2, this);
                        }
                    }
                });
            }
            catch (Exception ex2) {
                return false;
            }
        }
        return recordLoc;
    }

    private static void declare(Element node4, String uri, String prefix2) {
        String qualname = prefix2 != null && prefix2.length() > 0 ? "xmlns:" + prefix2 : "xmlns";
        Attr attr = node4.getOwnerDocument().createAttributeNS(XML_NS, qualname);
        attr.setValue(uri);
        node4.setAttributeNodeNS(attr);
    }

    public static XMLStreamReader createXMLStreamReader(InputSource src) {
        String pubId;
        String sysId = src.getSystemId() == null ? null : new String(src.getSystemId());
        String string2 = pubId = src.getPublicId() == null ? null : new String(src.getPublicId());
        if (src.getByteStream() != null) {
            if (src.getEncoding() == null) {
                StreamSource ss = new StreamSource(src.getByteStream(), sysId);
                ss.setPublicId(pubId);
                return StaxUtils.createXMLStreamReader(ss);
            }
            return StaxUtils.createXMLStreamReader(src.getByteStream(), src.getEncoding());
        }
        if (src.getCharacterStream() != null) {
            StreamSource ss = new StreamSource(src.getCharacterStream(), sysId);
            ss.setPublicId(pubId);
            return StaxUtils.createXMLStreamReader(ss);
        }
        try {
            URL url = new URL(sysId);
            StreamSource ss = new StreamSource(url.openStream(), sysId);
            ss.setPublicId(pubId);
            return StaxUtils.createXMLStreamReader(ss);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("InputSource must have a ByteStream or CharacterStream");
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in2, String encoding) {
        XMLStreamReader xMLStreamReader;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            xMLStreamReader = factory.createXMLStreamReader(in2, encoding);
            Object var5_5 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Couldn't parse stream.", e2);
            }
            catch (Throwable throwable2) {
                Object var5_6 = null;
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in2) {
        XMLStreamReader xMLStreamReader;
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            xMLStreamReader = factory.createXMLStreamReader(in2);
            Object var4_4 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Couldn't parse stream.", e2);
            }
            catch (Throwable throwable2) {
                Object var4_5 = null;
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    public static XMLStreamReader createXMLStreamReader(String systemId, InputStream in2) {
        XMLStreamReader xMLStreamReader;
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            xMLStreamReader = factory.createXMLStreamReader(systemId, in2);
            Object var5_5 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Couldn't parse stream.", e2);
            }
            catch (Throwable throwable2) {
                Object var5_6 = null;
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    public static XMLStreamReader createXMLStreamReader(Element el) {
        return new W3CDOMStreamReader(el);
    }

    public static XMLStreamReader createXMLStreamReader(Document doc) {
        return new W3CDOMStreamReader(doc.getDocumentElement());
    }

    public static XMLStreamReader createXMLStreamReader(Element el, String sysId) {
        return new W3CDOMStreamReader(el, sysId);
    }

    public static XMLStreamReader createXMLStreamReader(Document doc, String sysId) {
        return new W3CDOMStreamReader(doc.getDocumentElement(), sysId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMLStreamReader createXMLStreamReader(Source source) {
        try {
            XMLStreamReader xMLStreamReader;
            if (source instanceof DOMSource) {
                DOMSource ds = (DOMSource)source;
                Node nd = ds.getNode();
                Element el = null;
                if (nd instanceof Document) {
                    el = ((Document)nd).getDocumentElement();
                } else if (nd instanceof Element) {
                    el = (Element)nd;
                }
                if (null != el) {
                    return new W3CDOMStreamReader(el, source.getSystemId());
                }
            } else if ("javax.xml.transform.stax.StAXSource".equals(source.getClass().getName())) {
                try {
                    return (XMLStreamReader)source.getClass().getMethod("getXMLStreamReader", new Class[0]).invoke((Object)source, new Object[0]);
                }
                catch (Exception ex2) {
                }
            } else {
                if (source instanceof StaxSource) {
                    return ((StaxSource)source).getXMLStreamReader();
                }
                if (source instanceof SAXSource) {
                    return StaxUtils.createXMLStreamReader(((SAXSource)source).getInputSource());
                }
            }
            XMLInputFactory factory = StaxUtils.getXMLInputFactory();
            try {
                XMLStreamReader reader2 = null;
                try {
                    reader2 = factory.createXMLStreamReader(source);
                }
                catch (UnsupportedOperationException e2) {
                    // empty catch block
                }
                if (reader2 == null && source instanceof StreamSource) {
                    StreamSource ss = (StreamSource)source;
                    reader2 = ss.getInputStream() != null ? factory.createXMLStreamReader(ss.getSystemId(), ss.getInputStream()) : factory.createXMLStreamReader(ss.getSystemId(), ss.getReader());
                }
                xMLStreamReader = reader2;
                Object var5_7 = null;
            }
            catch (Throwable throwable2) {
                Object var5_8 = null;
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable2;
            }
            StaxUtils.returnXMLInputFactory(factory);
            return xMLStreamReader;
        }
        catch (XMLStreamException e3) {
            throw new RuntimeException("Couldn't parse stream.", e3);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader2) {
        XMLStreamReader xMLStreamReader;
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            xMLStreamReader = factory.createXMLStreamReader(reader2);
            Object var4_4 = null;
        }
        catch (XMLStreamException e2) {
            try {
                throw new RuntimeException("Couldn't parse stream.", e2);
            }
            catch (Throwable throwable2) {
                Object var4_5 = null;
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable2;
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    public static QName readQName(XMLStreamReader reader2) throws XMLStreamException {
        String value2 = reader2.getElementText();
        if (value2 == null) {
            return null;
        }
        int index2 = value2.indexOf(":");
        if (index2 == -1) {
            return new QName(value2);
        }
        String prefix2 = value2.substring(0, index2);
        String localName = value2.substring(index2 + 1);
        String ns = reader2.getNamespaceURI(prefix2);
        if (!StringUtils.isEmpty(prefix2) && ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value2);
        }
        if (ns == null) {
            return new QName(localName);
        }
        return new QName(ns, localName, prefix2);
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        String prefix2 = writer.getPrefix(namespaceURI);
        if (prefix2 == null) {
            prefix2 = StaxUtils.getUniquePrefix(writer);
            if (declare) {
                writer.setPrefix(prefix2, namespaceURI);
                writer.writeNamespace(prefix2, namespaceURI);
            }
        }
        return prefix2;
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI) throws XMLStreamException {
        return StaxUtils.getUniquePrefix(writer, namespaceURI, false);
    }

    public static String getUniquePrefix(XMLStreamWriter writer) {
        NamespaceContext nc = writer.getNamespaceContext();
        if (nc == null) {
            return DEF_PREFIXES[0];
        }
        for (String t2 : DEF_PREFIXES) {
            String uri = nc.getNamespaceURI(t2);
            if (!StringUtils.isEmpty(uri)) continue;
            return t2;
        }
        int n = 10;
        String nsPrefix;
        String uri;
        while (!StringUtils.isEmpty(uri = nc.getNamespaceURI(nsPrefix = "ns" + n))) {
            ++n;
        }
        return nsPrefix;
    }

    public static void printXmlFragment(XMLStreamReader reader2) {
        try {
            LOG.info(XMLUtils.toString(StaxUtils.read(reader2), 4));
        }
        catch (XMLStreamException e2) {
            LOG.severe(e2.getMessage());
        }
    }

    private static void writeStartElementEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        StartElement start2 = event.asStartElement();
        QName name = start2.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix2 = name.getPrefix();
        if (prefix2 != null) {
            writer.writeStartElement(prefix2, localName, nsURI);
        } else if (nsURI != null) {
            writer.writeStartElement(localName, nsURI);
        } else {
            writer.writeStartElement(localName);
        }
        Iterator it = start2.getNamespaces();
        while (it != null && it.hasNext()) {
            StaxUtils.writeEvent((XMLEvent)it.next(), writer);
        }
        it = start2.getAttributes();
        while (it != null && it.hasNext()) {
            StaxUtils.writeAttributeEvent((Attribute)it.next(), writer);
        }
    }

    private static void writeAttributeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        Attribute attr = (Attribute)event;
        QName name = attr.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix2 = name.getPrefix();
        String value2 = attr.getValue();
        if (prefix2 != null) {
            writer.writeAttribute(prefix2, nsURI, localName, value2);
        } else if (nsURI != null) {
            writer.writeAttribute(nsURI, localName, value2);
        } else {
            writer.writeAttribute(localName, value2);
        }
    }

    public static void writeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        switch (event.getEventType()) {
            case 1: {
                StaxUtils.writeStartElementEvent(event, writer);
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 10: {
                StaxUtils.writeAttributeEvent(event, writer);
                break;
            }
            case 9: {
                writer.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 11: {
                writer.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 3: {
                if (((javax.xml.stream.events.ProcessingInstruction)event).getData() != null) {
                    writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget(), ((javax.xml.stream.events.ProcessingInstruction)event).getData());
                    break;
                }
                writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget());
                break;
            }
            case 13: {
                if (((Namespace)event).isDefaultNamespaceDeclaration()) {
                    writer.writeDefaultNamespace(((Namespace)event).getNamespaceURI());
                    writer.setDefaultNamespace(((Namespace)event).getNamespaceURI());
                    break;
                }
                writer.writeNamespace(((Namespace)event).getPrefix(), ((Namespace)event).getNamespaceURI());
                writer.setPrefix(((Namespace)event).getPrefix(), ((Namespace)event).getNamespaceURI());
                break;
            }
            case 5: {
                writer.writeComment(((javax.xml.stream.events.Comment)event).getText());
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(event.asCharacters().getData());
                break;
            }
            case 12: {
                writer.writeCData(event.asCharacters().getData());
                break;
            }
            case 7: {
                if (((StartDocument)event).encodingSet()) {
                    writer.writeStartDocument(((StartDocument)event).getCharacterEncodingScheme(), ((StartDocument)event).getVersion());
                    break;
                }
                writer.writeStartDocument(((StartDocument)event).getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
        }
    }

    public static String toString(Document doc) throws XMLStreamException {
        StringWriter sw = new StringWriter(1024);
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(sw);
        StaxUtils.copy(doc, writer);
        writer.flush();
        return sw.toString();
    }

    public static String toString(Element el) throws XMLStreamException {
        StringWriter sw = new StringWriter(1024);
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(sw);
        StaxUtils.copy(el, writer);
        writer.flush();
        return sw.toString();
    }

    static {
        String s2;
        LOG = LogUtils.getL7dLogger(StaxUtils.class);
        DEF_PREFIXES = new String[]{"ns1".intern(), "ns2".intern(), "ns3".intern(), "ns4".intern(), "ns5".intern(), "ns6".intern(), "ns7".intern(), "ns8".intern(), "ns9".intern()};
        innerElementLevelThreshold = -1;
        innerElementCountThreshold = -1;
        int i = 20;
        try {
            s2 = System.getProperty("org.apache.cxf.staxutils.pool-size", "-1");
            i = Integer.parseInt(s2);
        }
        catch (Throwable t2) {
            i = 20;
        }
        if (i <= 0) {
            i = 20;
        }
        NS_AWARE_INPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLInputFactory>(i);
        OUTPUT_FACTORY_POOL = new LinkedBlockingQueue<XMLOutputFactory>(i);
        try {
            s2 = System.getProperty("org.apache.cxf.staxutils.innerElementLevelThreshold", "-1");
            innerElementLevelThreshold = Integer.parseInt(s2);
        }
        catch (Throwable t3) {
            innerElementLevelThreshold = -1;
        }
        if (innerElementLevelThreshold <= 0) {
            innerElementLevelThreshold = -1;
        }
        try {
            s2 = System.getProperty("org.apache.cxf.staxutils.innerElementCountThreshold", "-1");
            innerElementCountThreshold = Integer.parseInt(s2);
        }
        catch (Throwable t4) {
            innerElementCountThreshold = -1;
        }
        if (innerElementCountThreshold <= 0) {
            innerElementCountThreshold = -1;
        }
    }
}

