/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class StreamWriterContentHandler
implements ContentHandler {
    XMLStreamWriter writer;
    Map<String, String> mapping = new LinkedHashMap<String, String>();

    public StreamWriterContentHandler(XMLStreamWriter w) {
        this.writer = w;
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] ch, int start2, int length2) throws SAXException {
        try {
            this.writer.writeCharacters(ch, start2, length2);
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    public void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
    }

    public void endPrefixMapping(String prefix2) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target2, String data2) throws SAXException {
    }

    public void startPrefixMapping(String prefix2, String uri) throws SAXException {
        this.mapping.put(prefix2, uri);
        try {
            this.writer.setPrefix(prefix2, uri);
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    private String getPrefix(String ns, String namespaceURI) {
        int idx = ns.indexOf(58);
        if (idx != -1) {
            return ns.substring(0, idx);
        }
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return "";
        }
        return null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            String prefix2 = this.getPrefix(qName, namespaceURI);
            if (prefix2 == null) {
                this.writer.writeStartElement(namespaceURI, localName);
            } else {
                this.writer.writeStartElement(prefix2, localName, namespaceURI);
            }
            for (Map.Entry<String, String> e2 : this.mapping.entrySet()) {
                if ("".equals(e2.getKey())) {
                    this.writer.writeDefaultNamespace(e2.getValue());
                    continue;
                }
                this.writer.writeNamespace(e2.getKey(), e2.getValue());
            }
            this.mapping.clear();
            if (atts != null) {
                int attCount = atts.getLength();
                for (int i = 0; i < attCount; ++i) {
                    if (StringUtils.isEmpty(atts.getURI(i))) {
                        String s2 = atts.getLocalName(i);
                        if (StringUtils.isEmpty(s2)) {
                            s2 = atts.getQName(i);
                        }
                        this.writer.writeAttribute(s2, atts.getValue(i));
                        continue;
                    }
                    String pfx = atts.getQName(i);
                    if (pfx.indexOf(58) != -1) {
                        pfx = pfx.substring(0, pfx.indexOf(58));
                        this.writer.writeAttribute(pfx, atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                        continue;
                    }
                    this.writer.writeAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                }
            }
        }
        catch (XMLStreamException e3) {
            throw new SAXException(e3);
        }
    }
}

