/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class W3CNamespaceContext
implements NamespaceContext {
    private Element currentNode;

    public W3CNamespaceContext() {
    }

    public W3CNamespaceContext(Element el) {
        this.currentNode = el;
    }

    public String getNamespaceURI(String prefix2) {
        String name = prefix2;
        name = name.length() == 0 ? "xmlns" : "xmlns:" + prefix2;
        return this.getNamespaceURI(this.currentNode, name);
    }

    private String getNamespaceURI(Element e2, String name) {
        if (e2 == null) {
            return null;
        }
        Attr attr = e2.getAttributeNode(name);
        if (attr == null) {
            Node n = e2.getParentNode();
            if (n instanceof Element && n != e2) {
                return this.getNamespaceURI((Element)n, name);
            }
        } else {
            return attr.getValue();
        }
        return null;
    }

    public String getPrefix(String uri) {
        return this.getPrefix(this.currentNode, uri);
    }

    private String getPrefix(Element e2, String uri) {
        Node n;
        if (e2 == null) {
            return null;
        }
        NamedNodeMap attributes2 = e2.getAttributes();
        if (attributes2 != null) {
            for (int i = 0; i < attributes2.getLength(); ++i) {
                Attr a2 = (Attr)attributes2.item(i);
                String val = a2.getValue();
                if (val == null || !val.equals(uri)) continue;
                String name = a2.getNodeName();
                if ("xmlns".equals(name)) {
                    return "";
                }
                return name.substring(6);
            }
        }
        if ((n = e2.getParentNode()) instanceof Element && n != e2) {
            return this.getPrefix((Element)n, uri);
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        ArrayList<String> prefixes = new ArrayList<String>();
        String prefix2 = this.getPrefix(uri);
        if (prefix2 != null) {
            prefixes.add(prefix2);
        }
        return prefixes.iterator();
    }

    public Element getElement() {
        return this.currentNode;
    }

    public void setElement(Element node4) {
        this.currentNode = node4;
    }
}

