/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixes = new HashMap<String, String>();
    private NamespaceContext nc;
    private Map<String, String> nsMap;

    public DelegatingNamespaceContext(NamespaceContext nc, Map<String, String> nsMap) {
        this.nc = nc;
        this.nsMap = nsMap;
    }

    public void addPrefix(String prefix2, String namespace) {
        this.prefixes.put(namespace, prefix2);
    }

    public String findUniquePrefix(String namespace) {
        if (namespace.length() == 0) {
            return null;
        }
        String existingPrefix = this.prefixes.get(namespace);
        if (existingPrefix != null) {
            return existingPrefix;
        }
        int i = 0;
        while (this.prefixes.containsKey("ps" + ++i)) {
        }
        String prefix2 = "ps" + i;
        this.addPrefix(prefix2, namespace);
        return prefix2;
    }

    @Override
    public String getNamespaceURI(String prefix2) {
        for (Map.Entry<String, String> entry2 : this.prefixes.entrySet()) {
            if (!entry2.getValue().equals(prefix2)) continue;
            return entry2.getKey();
        }
        String ns = this.nc.getNamespaceURI(prefix2);
        this.addPrefix(prefix2, ns);
        return ns;
    }

    @Override
    public String getPrefix(String ns) {
        String actualNs;
        if (ns.length() == 0) {
            return null;
        }
        String value2 = this.nsMap.get(ns);
        if (value2 != null && value2.length() == 0) {
            return null;
        }
        String string2 = actualNs = value2 == null ? ns : value2;
        if (this.prefixes.containsKey(actualNs)) {
            return this.prefixes.get(actualNs);
        }
        String prefix2 = this.nc.getPrefix(actualNs);
        this.addPrefix(prefix2, actualNs);
        return prefix2;
    }

    public Iterator getPrefixes(String ns) {
        return this.nc.getPrefixes(ns);
    }
}

