/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.StaxStreamFilter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.InTransformReader;
import org.apache.cxf.staxutils.transform.OutTransformWriter;
import org.apache.cxf.staxutils.transform.QNamesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformUtils {
    private TransformUtils() {
    }

    public static XMLStreamReader createNewReaderIfNeeded(XMLStreamReader reader2, InputStream is2) {
        return reader2 == null ? StaxUtils.createXMLStreamReader(is2) : reader2;
    }

    public static XMLStreamWriter createNewWriterIfNeeded(XMLStreamWriter writer, OutputStream os2) {
        return writer == null ? StaxUtils.createXMLStreamWriter(os2) : writer;
    }

    public static XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os2, Map<String, String> outElementsMap, List<String> outDropElements, Map<String, String> outAppendMap, boolean attributesToElements) {
        if (outElementsMap != null || outDropElements != null || outAppendMap != null || attributesToElements) {
            writer = TransformUtils.createNewWriterIfNeeded(writer, os2);
            writer = new OutTransformWriter(writer, outElementsMap, outAppendMap, outDropElements, attributesToElements);
        }
        return writer;
    }

    public static XMLStreamReader createTransformReaderIfNeeded(XMLStreamReader reader2, InputStream is2, List<String> inDropElements, Map<String, String> inElementsMap, Map<String, String> inAppendMap, boolean blockOriginalReader) {
        if (inDropElements != null) {
            Set<QName> dropElements = XMLUtils.convertStringsToQNames(inDropElements);
            reader2 = StaxUtils.createFilteredReader(TransformUtils.createNewReaderIfNeeded(reader2, is2), new StaxStreamFilter(dropElements.toArray(new QName[0])));
        }
        if (inElementsMap != null || inAppendMap != null) {
            reader2 = new InTransformReader(TransformUtils.createNewReaderIfNeeded(reader2, is2), inElementsMap, inAppendMap, blockOriginalReader);
        }
        return reader2;
    }

    protected static void convertToQNamesMap(Map<String, String> map3, QNamesMap elementsMap, Map<String, String> nsMap) {
        if (map3 != null) {
            for (Map.Entry<String, String> entry2 : map3.entrySet()) {
                QName lname = XMLUtils.convertStringToQName(entry2.getKey());
                QName rname = XMLUtils.convertStringToQName(entry2.getValue());
                elementsMap.put(lname, rname);
                if (nsMap == null) continue;
                nsMap.put(lname.getNamespaceURI(), rname.getNamespaceURI());
            }
        }
    }

    protected static void convertToMapOfQNames(Map<String, String> map3, Map<QName, QName> elementsMap) {
        if (map3 != null) {
            for (Map.Entry<String, String> entry2 : map3.entrySet()) {
                QName lname = XMLUtils.convertStringToQName(entry2.getKey());
                QName rname = XMLUtils.convertStringToQName(entry2.getValue());
                elementsMap.put(lname, rname);
            }
        }
    }
}

