/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathAssert {
    private XPathAssert() {
    }

    public static NodeList assertValid(String xpath, Node node4, Map<String, String> namespaces) throws Exception {
        if (node4 == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        NodeList nodes2 = (NodeList)XPathAssert.createXPath(namespaces).evaluate(xpath, node4, XPathConstants.NODESET);
        if (nodes2.getLength() == 0) {
            throw new AssertionFailedError("Failed to select any nodes for expression:\n" + xpath + " from document:\n" + XPathAssert.writeNodeToString(node4));
        }
        return nodes2;
    }

    public static void assertValidBoolean(String xpath, Node node4, Map<String, String> namespaces) throws Exception {
        if (node4 == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        Boolean b = (Boolean)XPathAssert.createXPath(namespaces).evaluate(xpath, node4, XPathConstants.BOOLEAN);
        if (b == null) {
            throw new AssertionFailedError("Failed to select any nodes for expression:\n" + xpath + " from document:\n" + XPathAssert.writeNodeToString(node4));
        }
        if (!b.booleanValue()) {
            throw new AssertionFailedError("Boolean XPath assertion evaluated to false:\n" + xpath + " from document:\n" + XPathAssert.writeNodeToString(node4));
        }
    }

    private static String writeNodeToString(Node node4) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DOMUtils.writeXml(node4, bos);
        }
        catch (TransformerException e2) {
            throw new RuntimeException(e2);
        }
        return bos.toString();
    }

    public static NodeList assertInvalid(String xpath, Node node4, Map<String, String> namespaces) throws Exception {
        if (node4 == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        NodeList nodes2 = (NodeList)XPathAssert.createXPath(namespaces).evaluate(xpath, node4, XPathConstants.NODESET);
        if (nodes2.getLength() > 0) {
            String value2 = XPathAssert.writeNodeToString(node4);
            throw new AssertionFailedError("Found multiple nodes for expression:\n" + xpath + "\n" + value2);
        }
        return nodes2;
    }

    public static void assertXPathEquals(String xpath, String value2, Node node4, Map<String, String> namespaces) throws Exception {
        Node result2 = (Node)XPathAssert.createXPath(namespaces).evaluate(xpath, node4, XPathConstants.NODE);
        if (result2 == null) {
            throw new AssertionFailedError("No nodes were found for expression: " + xpath + " in document " + XPathAssert.writeNodeToString(node4));
        }
        String value22 = DOMUtils.getContent(result2);
        Assert.assertEquals((String)value2, (String)value22);
    }

    public static void assertNoFault(Node node4) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", "http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.put("s12", "http://www.w3.org/2003/05/soap-envelope");
        XPathAssert.assertInvalid("/s:Envelope/s:Body/s:Fault", node4, namespaces);
        XPathAssert.assertInvalid("/s12:Envelope/s12:Body/s12:Fault", node4, namespaces);
    }

    public static void assertFault(Node node4) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", "http://schemas.xmlsoap.org/soap/envelope/");
        namespaces.put("s12", "http://www.w3.org/2003/05/soap-envelope");
        XPathAssert.assertValid("/s:Envelope/s:Body/s:Fault", node4, namespaces);
        XPathAssert.assertValid("/s12:Envelope/s12:Body/s12:Fault", node4, namespaces);
    }

    public static XPath createXPath(Map<String, String> namespaces) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (namespaces != null) {
            xpath.setNamespaceContext(new MapNamespaceContext(namespaces));
        }
        return xpath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaces;

        public MapNamespaceContext(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix2) {
            return this.namespaces.get(prefix2);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (Map.Entry<String, String> e2 : this.namespaces.entrySet()) {
                if (!e2.getValue().equals(namespaceURI)) continue;
                return e2.getKey();
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

