/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.AbstractToolContainer;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineParser;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCXFToolContainer
extends AbstractToolContainer {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractCXFToolContainer.class);
    private final String name;
    private CommandDocument commandDocument;
    private boolean verbose;
    private String usage;
    private final ErrorVisitor errors = new ErrorVisitor();

    public AbstractCXFToolContainer(String nm, ToolSpec toolspec) throws Exception {
        super(toolspec);
        this.name = nm;
    }

    public boolean hasInfoOption() throws ToolException {
        this.commandDocument = this.getCommandDocument();
        if (this.commandDocument == null) {
            return false;
        }
        return this.commandDocument.hasParameter("help") || this.commandDocument.hasParameter("version");
    }

    @Override
    public void execute(boolean exitOnFinish) throws ToolException {
        super.execute(exitOnFinish);
        if (this.hasInfoOption()) {
            this.outputInfo();
        } else {
            if (this.commandDocument.hasParameter("verbose")) {
                this.verbose = true;
                this.outputFullCommandLine();
                this.outputVersion();
            }
            this.checkParams(this.errors);
        }
    }

    private void outputInfo() {
        CommandLineParser parser = this.getCommandLineParser();
        if (this.commandDocument.hasParameter("help")) {
            try {
                this.out.println(this.name + " " + this.getUsage());
                this.out.println();
                this.out.println("Options: ");
                this.out.println();
                this.out.println(parser.getFormattedDetailedUsage());
                String toolUsage = parser.getToolUsage();
                if (toolUsage != null) {
                    this.out.println(toolUsage);
                }
            }
            catch (Exception ex2) {
                this.err.println("Error: Could not output detailed usage");
                this.err.println();
            }
        }
        if (this.commandDocument.hasParameter("version")) {
            this.outputVersion();
        }
    }

    public void checkParams(ErrorVisitor err2) throws ToolException {
    }

    public boolean isVerboseOn() {
        if (this.context != null && this.context.isVerbose()) {
            return true;
        }
        return this.verbose;
    }

    public String getToolName() {
        return this.name;
    }

    public String getUsage() {
        if (this.usage == null) {
            try {
                CommandLineParser parser = this.getCommandLineParser();
                if (parser != null) {
                    this.usage = parser.getUsage();
                }
            }
            catch (Exception ex2) {
                this.usage = "Could not get usage for the tool";
            }
        }
        return this.usage;
    }

    public void outputVersion() {
        this.out.println(this.name + " - " + Version.getCompleteVersionString());
        this.out.println();
    }

    public void outputFullCommandLine() {
        this.out.print(this.name);
        for (int i = 0; i < this.getArgument().length; ++i) {
            this.out.print(" " + this.getArgument()[i]);
        }
        this.out.println();
    }

    public String getFileBase(String wsdlUrl) {
        String fileBase = wsdlUrl;
        StringTokenizer tok = new StringTokenizer(wsdlUrl, "\\/");
        while (tok.hasMoreTokens()) {
            fileBase = tok.nextToken();
        }
        if (fileBase.endsWith(".wsdl")) {
            fileBase = new String(fileBase.substring(0, fileBase.length() - 5));
        }
        return fileBase;
    }

    public void printUsageException(String toolName, BadUsageException ex2) {
        if (this.verbose) {
            this.outputFullCommandLine();
        }
        this.err.println(ex2.getMessage());
        this.err.println("Usage : " + toolName + " " + ex2.getUsage());
        if (this.verbose) {
            this.outputVersion();
        }
        this.err.println();
    }

    public String getFileName(String loc) {
        int idx = loc.lastIndexOf("/");
        if (idx != -1) {
            loc = loc.substring(idx + 1);
        }
        if ((idx = loc.lastIndexOf("\\")) != -1) {
            loc = loc.substring(idx + 1);
        }
        if ((idx = loc.lastIndexOf(".")) != -1) {
            loc = loc.substring(0, idx);
        }
        StringTokenizer strToken = new StringTokenizer(loc, "-.!~*'();?:@&=+$,");
        StringBuilder strBuf = new StringBuilder();
        if (!strToken.hasMoreTokens()) {
            strBuf.append(loc);
        }
        while (strToken.hasMoreTokens()) {
            strBuf.append(strToken.nextToken());
            if (strToken.countTokens() == 0) continue;
            strBuf.append("_");
        }
        return strBuf.toString();
    }

    private InputStream getResourceAsStream(String resource) {
        ClassLoader cl = AbstractCXFToolContainer.class.getClassLoader();
        InputStream ins2 = cl.getResourceAsStream(resource);
        if (ins2 == null && resource.startsWith("/")) {
            ins2 = cl.getResourceAsStream(resource.substring(1));
        }
        return ins2;
    }

    public Properties loadProperties(InputStream inputs) {
        Properties p = new Properties();
        try {
            p.load(inputs);
            inputs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    public Properties loadProperties(String propertyFile) {
        Properties p = new Properties();
        try {
            InputStream ins2 = this.getResourceAsStream(propertyFile);
            p.load(ins2);
            ins2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    protected String[] getDefaultExcludedNamespaces(String excludeProps) {
        ArrayList<String> result2 = new ArrayList<String>();
        Properties props = this.loadProperties(excludeProps);
        Enumeration<?> nexcludes = props.propertyNames();
        while (nexcludes.hasMoreElements()) {
            result2.add(props.getProperty((String)nexcludes.nextElement()));
        }
        return result2.toArray(new String[result2.size()]);
    }

    protected Map<String, Object> getParametersMap(Set stringArrayKeys) {
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        CommandDocument doc = this.getCommandDocument();
        if (doc == null) {
            return map3;
        }
        String[] keys2 = doc.getParameterNames();
        if (keys2 == null) {
            return map3;
        }
        for (int i = 0; i < keys2.length; ++i) {
            if (stringArrayKeys.contains(keys2[i])) {
                map3.put(keys2[i], doc.getParameters(keys2[i]));
                continue;
            }
            map3.put(keys2[i], doc.getParameter(keys2[i]));
        }
        return map3;
    }
}

