/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;

public class ClassUtils {
    protected static final Logger LOG = LogUtils.getL7dLogger(ClassUtils.class);

    public void compile(ToolContext context) throws ToolException {
        String javaClasspath;
        Compiler compiler = new Compiler();
        if (context.isVerbose()) {
            compiler.setVerbose(true);
        }
        if ("1.5".equals(System.getProperty("java.specification.version"))) {
            compiler.setTarget("1.5");
        }
        if (context.get("classdir") != null) {
            compiler.setOutputDir((String)context.get("classdir"));
        }
        if ((javaClasspath = System.getProperty("java.class.path")) != null) {
            if (context.get("outputdir") != null) {
                compiler.setClassPath(javaClasspath + File.pathSeparatorChar + context.get("outputdir"));
            } else {
                compiler.setClassPath(javaClasspath);
            }
        }
        String outPutDir = (String)context.get("outputdir");
        HashSet<String> dirSet = new HashSet<String>();
        ClassCollector classCollector = context.get(ClassCollector.class);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String fileName : classCollector.getGeneratedFileInfo()) {
            fileName = fileName.replace('.', File.separatorChar);
            String dirName = fileName.substring(0, fileName.lastIndexOf(File.separator) + 1);
            String path2 = outPutDir + File.separator + dirName;
            if (dirSet.contains(path2)) continue;
            dirSet.add(path2);
            File file = new File(path2);
            if (!file.isDirectory()) continue;
            for (String str : file.list()) {
                if (str.endsWith("java")) {
                    fileList.add(path2 + str);
                    continue;
                }
                File otherFile = new File(path2 + File.separator + str);
                if (!otherFile.isFile() || !str.toLowerCase().endsWith("xml") || context.get("classdir") == null) continue;
                String targetDir = (String)context.get("classdir");
                File targetFile = new File(targetDir + File.separator + dirName + File.separator + str);
                this.copyXmlFile(otherFile, targetFile);
            }
            File jaxbRuntime = new File(path2, "runtime");
            if (!jaxbRuntime.isDirectory() || !jaxbRuntime.exists()) continue;
            List<File> files2 = FileUtils.getFiles(jaxbRuntime, ".+\\.java$");
            for (File f2 : files2) {
                fileList.add(f2.toString());
            }
        }
        if (!compiler.compileFiles(fileList.toArray(new String[fileList.size()]))) {
            Message msg = new Message("FAIL_TO_COMPILE_GENERATE_CODES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void copyXmlFile(File from2, File to2) throws ToolException {
        try {
            String dir = to2.getCanonicalPath().substring(0, to2.getCanonicalPath().lastIndexOf(File.separator));
            File dirFile = new File(dir);
            dirFile.mkdirs();
            FileInputStream input2 = new FileInputStream(from2);
            FileOutputStream output = new FileOutputStream(to2);
            byte[] b = new byte[3072];
            int len2 = 0;
            while (len2 != -1) {
                len2 = input2.read(b);
                if (len2 == -1) continue;
                output.write(b, 0, len2);
            }
            output.flush();
            output.close();
            input2.close();
        }
        catch (Exception e2) {
            Message msg = new Message("FAIL_TO_COPY_GENERATED_RESOURCE_FILE", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e2);
        }
    }
}

