/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag {
    QName name;
    Map<QName, String> attributes;
    String text;
    List<Tag> tags;
    Tag parent;
    List<String> ignoreAttr;

    public List<String> getIgnoreAttr() {
        if (this.ignoreAttr == null) {
            this.ignoreAttr = new ArrayList<String>();
        }
        return this.ignoreAttr;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag nTag) {
        this.parent = nTag;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String nText) {
        this.text = nText;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName nName) {
        this.name = nName;
    }

    public Map<QName, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<QName, String>();
        }
        return this.attributes;
    }

    private String createIndent(int size2) {
        String indent2 = "    ";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size2; ++i) {
            sb.append(indent2);
        }
        return sb.toString();
    }

    private String formatAttribute(Tag tag2) {
        StringBuilder sb = new StringBuilder();
        sb.append(tag2.getName().getLocalPart());
        sb.append(" ");
        for (Map.Entry<QName, String> attr : tag2.getAttributes().entrySet()) {
            sb.append(attr.getKey());
            sb.append("=\"");
            sb.append(attr.getValue());
            sb.append("\" ");
        }
        return sb.toString().trim();
    }

    private String formatTag(Tag tag2, int indent2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createIndent(indent2));
        sb.append(indent2);
        sb.append("<");
        sb.append(this.formatAttribute(tag2));
        sb.append(">");
        if (tag2.getParent() != null) {
            sb.append(" (" + tag2.getParent().getName().getLocalPart() + ")");
        }
        if (this.text != null) {
            sb.append(this.text);
        }
        sb.append("\n");
        if (tag2.getTags().size() > 0) {
            ++indent2;
            for (Tag subTag : tag2.getTags()) {
                sb.append(this.formatTag(subTag, indent2));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatTag(this, 0));
        return sb.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + ((Object)this.getAttributes()).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Tag)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Tag tag2 = (Tag)object;
        if (!this.getName().equals(tag2.getName())) {
            return false;
        }
        for (QName attr : this.getAttributes().keySet()) {
            if (this.getIgnoreAttr().contains(attr.getLocalPart()) || this.getIgnoreAttr().contains(this.getName().getLocalPart() + "@" + attr.getLocalPart())) continue;
            if (!tag2.getAttributes().containsKey(attr)) {
                return false;
            }
            if (tag2.getAttributes().get(attr).equals(this.getAttributes().get(attr))) continue;
            return false;
        }
        return true;
    }
}

