/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExtendedDocumentBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(ExtendedDocumentBuilder.class);
    private final DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder parser;
    private SchemaFactory schemaFactory;
    private Schema schema;

    public ExtendedDocumentBuilder() {
        this.parserFactory.setNamespaceAware(true);
    }

    private InputStream getSchemaLocation() {
        String toolspec = "/org/apache/cxf/tools/common/toolspec/tool-specification.xsd";
        return this.getClass().getResourceAsStream(toolspec);
    }

    public void setValidating(boolean validate2) {
        if (validate2) {
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                this.schema = this.schemaFactory.newSchema(new StreamSource(this.getSchemaLocation()));
            }
            catch (SAXException e2) {
                LOG.log(Level.SEVERE, "SCHEMA_FACTORY_EXCEPTION_MSG");
            }
            try {
                this.parserFactory.setSchema(this.schema);
            }
            catch (UnsupportedOperationException e3) {
                LOG.log(Level.WARNING, "DOC_PARSER_NOT_SUPPORTED", e3);
            }
        }
    }

    private DocumentBuilder getParser() {
        if (this.parser == null) {
            try {
                this.parser = this.parserFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e2) {
                LOG.log(Level.SEVERE, "NEW_DOCUMENT_BUILDER_EXCEPTION_MSG");
            }
        }
        return this.parser;
    }

    public Document parse(InputStream in2) throws SAXException, IOException {
        if (in2 == null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("ExtendedDocumentBuilder trying to parse a null inputstream");
        }
        return this.getParser().parse(in2);
    }
}

