/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.dom;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.xml.sax.SAXException;

public final class SchemaValidatingSAXParser {
    private static final Logger LOG = LogUtils.getL7dLogger(SchemaValidatingSAXParser.class);
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private SchemaFactory schemaFactory;
    private Schema schema;

    public SchemaValidatingSAXParser() {
        try {
            this.parserFactory.setNamespaceAware(true);
            this.parser = this.parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e2) {
            LOG.log(Level.SEVERE, "SAX_PARSER_CONFIG_ERR_MSG");
        }
        catch (SAXException saxe) {
            LOG.log(Level.SEVERE, "SAX_PARSER_EXCEPTION_MSG");
        }
        this.setValidating(true);
    }

    private InputStream getSchemaLocation() {
        String toolspec = "/org/apache/cxf/tools/common/toolspec/tool-specification.xsd";
        return this.getClass().getResourceAsStream(toolspec);
    }

    public void setValidating(boolean validate2) {
        if (validate2) {
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                this.schema = this.schemaFactory.newSchema(new StreamSource(this.getSchemaLocation()));
            }
            catch (SAXException e2) {
                LOG.log(Level.SEVERE, "SCHEMA_FACTORY_EXCEPTION_MSG");
            }
            try {
                this.parserFactory.setSchema(this.schema);
            }
            catch (UnsupportedOperationException e3) {
                LOG.log(Level.WARNING, "SAX_PARSER_NOT_SUPPORTED", e3);
            }
        }
    }

    public SAXParser getSAXParser() {
        return this.parser;
    }
}

