/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.tools.common.model.JAnnotationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAnnotation {
    private Class type;
    private List<JAnnotationElement> elements = new ArrayList<JAnnotationElement>();
    private Set<String> imports = new HashSet<String>();

    public JAnnotation() {
    }

    public JAnnotation(Class t2) {
        this.setType(t2);
    }

    public Set<String> getImports() {
        this.prompt();
        for (JAnnotationElement element2 : this.elements) {
            this.imports.addAll(element2.getImports());
        }
        return this.imports;
    }

    private void prompt() {
        this.toString();
    }

    public List<JAnnotationElement> getElements() {
        return this.elements;
    }

    public void addElement(JAnnotationElement element2) {
        if (this.elements.contains(element2)) {
            return;
        }
        JAnnotationElement e2 = this.getElementByName(element2.getName());
        if (e2 != null) {
            this.elements.remove(e2);
        }
        this.elements.add(element2);
    }

    private JAnnotationElement getElementByName(String name) {
        if (name != null) {
            for (JAnnotationElement e2 : this.elements) {
                if (!name.equals(e2.getName())) continue;
                return e2;
            }
        }
        return null;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class newType) {
        this.type = newType;
        this.imports.add(this.type.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this.type.getSimpleName());
        if (this.getElements().isEmpty()) {
            return sb.toString();
        }
        sb.append("(");
        for (int i = 0; i < this.elements.size(); ++i) {
            sb.append(this.elements.get(i));
            if (i >= this.elements.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

