/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.JavaCodeBlock;
import org.apache.cxf.tools.common.model.JavaExpression;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
extends JavaInterface {
    private final List<JavaField> jfield = new ArrayList<JavaField>();

    public JavaClass() {
    }

    public JavaClass(JavaModel model) {
        super(model);
    }

    public void addField(JavaField f2) {
        this.jfield.add(f2);
    }

    public List<JavaField> getFields() {
        return this.jfield;
    }

    public JavaMethod appendGetter(JavaField field2) {
        String getterName = "get" + StringUtils.capitalize(field2.getName());
        JavaMethod jMethod = new JavaMethod(this);
        jMethod.setName(getterName);
        jMethod.setReturn(new JavaReturn(field2.getParaName(), field2.getType(), field2.getTargetNamespace()));
        JavaCodeBlock block = new JavaCodeBlock();
        JavaExpression exp = new JavaExpression();
        exp.setValue("return this." + field2.getParaName());
        block.getExpressions().add(exp);
        jMethod.setJavaCodeBlock(block);
        this.addMethod(jMethod);
        return jMethod;
    }

    public JavaMethod appendSetter(JavaField field2) {
        String setterName = "set" + StringUtils.capitalize(field2.getName());
        JavaMethod jMethod = new JavaMethod(this);
        jMethod.setReturn(new JavaReturn("return", "void", null));
        String paramName = this.getSetterParamName(field2.getParaName());
        jMethod.addParameter(new JavaParameter(paramName, field2.getType(), field2.getTargetNamespace()));
        JavaCodeBlock block = new JavaCodeBlock();
        JavaExpression exp = new JavaExpression();
        exp.setValue("this." + field2.getParaName() + " = " + paramName);
        block.getExpressions().add(exp);
        jMethod.setJavaCodeBlock(block);
        jMethod.setName(setterName);
        this.addMethod(jMethod);
        return jMethod;
    }

    private String getSetterParamName(String fieldName) {
        return "new" + StringUtils.capitalize(fieldName);
    }
}

