/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolContainer;
import org.apache.cxf.tools.common.toolspec.ToolSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolRunner {
    private static final Logger LOG = LogUtils.getL7dLogger(ToolRunner.class);

    private ToolRunner() {
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate2, String[] args2) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate2, args2, true);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate2, String[] args2, OutputStream os2) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate2, args2, true, null, os2);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate2, String[] args2, ToolContext context) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate2, args2, true, context, null);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate2, String[] args2, boolean exitOnFinish) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate2, args2, true, null, null);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate2, String[] args2, boolean exitOnFinish, ToolContext context) throws Exception {
        ToolRunner.runTool(clz, toolspecStream, validate2, args2, exitOnFinish, context, null);
    }

    public static void runTool(Class<? extends ToolContainer> clz, InputStream toolspecStream, boolean validate2, String[] args2, boolean exitOnFinish, ToolContext context, OutputStream os2) throws Exception {
        ToolContainer container = null;
        try {
            Constructor<? extends ToolContainer> cons2 = clz.getConstructor(ToolSpec.class);
            container = cons2.newInstance(new ToolSpec(toolspecStream, validate2));
        }
        catch (Exception ex2) {
            Message message = new Message("CLZ_CANNOT_BE_CONSTRUCTED", LOG, clz.getName());
            LOG.log(Level.SEVERE, message.toString());
            throw new ToolException(message, (Throwable)ex2);
        }
        container.setArguments(args2);
        if (os2 != null) {
            container.setErrOutputStream(os2);
            container.setOutOutputStream(os2);
        }
        container.setContext(context);
        container.execute(exitOnFinish);
    }
}

