/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.dom.ExtendedDocumentBuilder;
import org.apache.cxf.tools.common.toolspec.Tool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolSpec {
    private static final Logger LOG = LogUtils.getL7dLogger(ToolSpec.class);
    private final ExtendedDocumentBuilder builder = new ExtendedDocumentBuilder();
    private Document doc;
    private Tool handler;

    public ToolSpec() {
    }

    public ToolSpec(InputStream in2) throws ToolException {
        this(in2, true);
    }

    public ToolSpec(InputStream in2, boolean validate2) throws ToolException {
        if (in2 == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null stream");
        }
        try {
            this.builder.setValidating(validate2);
            this.doc = this.builder.parse(in2);
        }
        catch (Exception ex2) {
            Message message = new Message("FAIL_TO_PARSING_TOOLSPCE_STREAM", LOG, new Object[0]);
            throw new ToolException(message, (Throwable)ex2);
        }
    }

    public ToolSpec(Document d) {
        if (d == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null org.w3c.dom.Document");
        }
        this.doc = d;
    }

    public ExtendedDocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public boolean isValidInputStream(String id2) {
        Element streams = this.getStreams();
        if (streams == null) {
            return false;
        }
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(streams, "http://cxf.apache.org/Xutil/ToolSpecification", "instream");
        for (Element elem2 : elemList) {
            if (!elem2.getAttribute("id").equals(id2)) continue;
            return true;
        }
        return false;
    }

    public Element getElementById(String id2) {
        Element ele = this.doc.getElementById(id2);
        if (ele != null) {
            return ele;
        }
        XPathUtils xpather = new XPathUtils(new HashMap<String, String>());
        NodeList nl = (NodeList)xpather.getValue("//*[@id='" + id2 + "']", this.doc, XPathConstants.NODESET);
        if (nl != null && nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public boolean hasHandler() {
        return this.doc.getDocumentElement().hasAttribute("handler");
    }

    public Tool getHandler() throws ToolException {
        if (!this.hasHandler()) {
            return null;
        }
        if (this.handler == null) {
            String handlerClz = this.doc.getDocumentElement().getAttribute("handler");
            try {
                this.handler = (Tool)Class.forName(handlerClz).newInstance();
            }
            catch (Exception ex2) {
                Message message = new Message("FAIL_TO_INSTANTIATE_HANDLER", LOG, handlerClz);
                throw new ToolException(message, (Throwable)ex2);
            }
        }
        return this.handler;
    }

    public Tool getHandler(ClassLoader loader) throws ToolException {
        if (!this.hasHandler()) {
            return null;
        }
        if (this.handler == null) {
            String handlerClz = this.doc.getDocumentElement().getAttribute("handler");
            try {
                this.handler = (Tool)Class.forName(handlerClz, true, loader).newInstance();
            }
            catch (Exception ex2) {
                Message message = new Message("FAIL_TO_INSTANTIATE_HANDLER", LOG, handlerClz);
                throw new ToolException(message, (Throwable)ex2);
            }
        }
        return this.handler;
    }

    public Element getStreams() {
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(this.doc.getDocumentElement(), "http://cxf.apache.org/Xutil/ToolSpecification", "streams");
        if (elemList.size() > 0) {
            return elemList.get(0);
        }
        return null;
    }

    public List getInstreamIds() {
        ArrayList<String> res = new ArrayList<String>();
        Element streams = this.getStreams();
        if (streams != null) {
            List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(streams, "http://cxf.apache.org/Xutil/ToolSpecification", "instream");
            for (Element elem2 : elemList) {
                res.add(elem2.getAttribute("id"));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public List getOutstreamIds() {
        ArrayList<String> res = new ArrayList<String>();
        Element streams = this.getStreams();
        if (streams != null) {
            List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(streams, "http://cxf.apache.org/Xutil/ToolSpecification", "outstream");
            for (Element elem2 : elemList) {
                res.add(elem2.getAttribute("id"));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public Element getUsage() {
        return DOMUtils.findAllElementsByTagNameNS(this.doc.getDocumentElement(), "http://cxf.apache.org/Xutil/ToolSpecification", "usage").get(0);
    }

    public void transform(InputStream stylesheet, OutputStream out) throws TransformerException {
        Transformer trans2 = TransformerFactory.newInstance().newTransformer(new StreamSource(stylesheet));
        trans2.transform(new DOMSource(this.doc), new StreamResult(out));
    }

    public Element getPipeline() {
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(this.doc.getDocumentElement(), "http://cxf.apache.org/Xutil/ToolSpecification", "pipeline");
        if (elemList.size() > 0) {
            return elemList.get(0);
        }
        return null;
    }

    public List<Element> getUsageForms() {
        return DOMUtils.findAllElementsByTagNameNS(this.getUsage(), "http://cxf.apache.org/Xutil/ToolSpecification", "form");
    }

    public String getStreamRefName(String streamId) {
        if (this.getUsage() != null) {
            List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(this.getUsage(), "http://cxf.apache.org/Xutil/ToolSpecification", "associatedArgument");
            for (Element elem2 : elemList) {
                if (!elem2.getAttribute("streamref").equals(streamId)) continue;
                return ((Element)elem2.getParentNode()).getAttribute("id");
            }
            elemList = DOMUtils.findAllElementsByTagNameNS(this.getUsage(), "http://cxf.apache.org/Xutil/ToolSpecification", "argument");
            for (Element elem2 : elemList) {
                if (!elem2.getAttribute("streamref").equals(streamId)) continue;
                return elem2.getAttribute("id");
            }
        }
        return null;
    }

    public String getParameterDefault(String name) {
        Element el = this.getElementById(name);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Element with id " + name + " is " + el);
        }
        if (el != null) {
            Element assArg;
            List<Element> elemList;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("local name is " + el.getLocalName());
            }
            if ("argument".equals(el.getLocalName())) {
                if (el.hasAttribute("default")) {
                    return el.getAttribute("default");
                }
            } else if ("option".equals(el.getLocalName()) && (elemList = DOMUtils.findAllElementsByTagNameNS(el, "http://cxf.apache.org/Xpipe/ToolSpecification", "associatedArgument")).size() > 0 && (assArg = elemList.get(0)).hasAttribute("default")) {
                return assArg.getAttribute("default");
            }
        }
        return null;
    }

    public String getAnnotation() {
        String result2 = null;
        Element element2 = this.doc.getDocumentElement();
        for (Node node4 = element2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (node4.getNodeType() != 1 || !"annotation".equals(node4.getNodeName())) continue;
            result2 = node4.getNodeValue();
            break;
        }
        return result2;
    }
}

