/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;

public class Argument
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Argument.class);
    protected ToolSpec toolspec;
    private final Element element;
    private int numMatches;

    public Argument(Element el) {
        this.element = el;
    }

    public boolean accept(TokenInputStream args2, Element result2, ErrorVisitor errors) {
        int minOccurs;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Accepting token stream for argument: " + this);
        }
        if ((minOccurs = "unbounded".equals(this.element.getAttribute("minOccurs")) ? 0 : Integer.parseInt(this.element.getAttribute("minOccurs"))) == 0) {
            this.addElement(args2, result2);
            return true;
        }
        if (minOccurs > args2.available()) {
            return false;
        }
        if (args2.peekPre().endsWith(",") && args2.peekPre().startsWith("-")) {
            if (args2.hasNext()) {
                args2.readNext();
            } else {
                return false;
            }
        }
        for (int i = 0; i < minOccurs; ++i) {
            if (args2.peek().startsWith("-")) {
                errors.add(new ErrorVisitor.UnexpectedOption(args2.peek()));
                return false;
            }
            this.addElement(args2, result2);
        }
        return true;
    }

    private void addElement(TokenInputStream args2, Element result2) {
        Element argEl = result2.getOwnerDocument().createElementNS("http://cxf.apache.org/Xutil/Command", "argument");
        argEl.setAttribute("name", this.getName());
        if (!args2.isOutOfBound()) {
            argEl.appendChild(result2.getOwnerDocument().createTextNode(args2.read()));
        }
        result2.appendChild(argEl);
        ++this.numMatches;
    }

    private boolean isAtleastMinimum() {
        boolean result2 = true;
        int minOccurs = 0;
        result2 = !"".equals(this.element.getAttribute("minOccurs")) ? this.numMatches >= Integer.parseInt(this.element.getAttribute("minOccurs")) : this.numMatches >= minOccurs;
        return result2;
    }

    private boolean isNoGreaterThanMaximum() {
        boolean result2 = true;
        if ("unbounded".equals(this.element.getAttribute("maxOccurs")) || "".equals(this.element.getAttribute("maxOccurs"))) {
            return true;
        }
        if (!"".equals(this.element.getAttribute("maxOccurs"))) {
            result2 = this.numMatches <= Integer.parseInt(this.element.getAttribute("maxOccurs"));
        }
        return result2;
    }

    public boolean isSatisfied(ErrorVisitor errors) {
        if (errors.getErrors().size() > 0) {
            return false;
        }
        if (!this.isAtleastMinimum()) {
            errors.add(new ErrorVisitor.MissingArgument(this.getName()));
            return false;
        }
        if (!this.isNoGreaterThanMaximum()) {
            errors.add(new ErrorVisitor.DuplicateArgument(this.getName()));
            return false;
        }
        return true;
    }

    public void setToolSpec(ToolSpec toolSpec) {
        this.toolspec = toolSpec;
    }

    public String getName() {
        return this.element.getAttribute("id");
    }

    public String toString() {
        return this.getName();
    }
}

