/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.toolspec.parser.Argument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.Option;
import org.apache.cxf.tools.common.toolspec.parser.OptionGroup;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Form
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Form.class);
    private final Element element;
    private final List<Object> arguments = new ArrayList<Object>();
    private final List<Object> optionGroups = new ArrayList<Object>();
    private final List<Object> options = new ArrayList<Object>();

    public Form(Element el) {
        this.element = el;
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "optionGroup");
        for (Element elem2 : elemList) {
            this.optionGroups.add(new OptionGroup(elem2));
        }
        elemList = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "argument");
        for (Element elem2 : elemList) {
            this.arguments.add(new Argument(elem2));
        }
        this.getOptions(this.element);
    }

    private void getOptions(Element el) {
        for (Node node4 = el.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (!"option".equals(node4.getNodeName())) continue;
            this.options.add(new Option((Element)node4));
        }
    }

    public boolean accept(TokenInputStream args2, Element result2, ErrorVisitor errors) {
        int i;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Accepting token stream for form of usage: " + this + ", tokens are " + args2);
        }
        int oldpos = args2.getPosition();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Position is: " + oldpos);
        }
        boolean hasInfo = this.hasInfoOption(args2);
        args2.setPosition(oldpos);
        while (args2.available() > 0) {
            int i2;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Args is available");
            }
            boolean accepted = false;
            for (i2 = 0; i2 < this.optionGroups.size(); ++i2) {
                OptionGroup optionGroup = (OptionGroup)this.optionGroups.get(i2);
                if (!optionGroup.accept(args2, result2, errors)) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                for (i2 = 0; i2 < this.options.size(); ++i2) {
                    Option option = (Option)this.options.get(i2);
                    if (!option.accept(args2, result2, errors)) continue;
                    accepted = true;
                    break;
                }
            }
            if (accepted) continue;
            break;
        }
        for (i = 0; i < this.optionGroups.size(); ++i) {
            OptionGroup optionGroup = (OptionGroup)this.optionGroups.get(i);
            if (optionGroup.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        for (i = 0; i < this.options.size(); ++i) {
            Option option = (Option)this.options.get(i);
            if (option.isSatisfied(errors) || hasInfo) continue;
            return false;
        }
        if (this.arguments != null) {
            for (i = 0; i < this.arguments.size(); ++i) {
                Argument argument2 = (Argument)this.arguments.get(i);
                argument2.accept(args2, result2, errors);
                if (argument2.isSatisfied(errors) || hasInfo) continue;
                return false;
            }
        }
        if (args2.available() > 0) {
            String next2 = args2.peek();
            if (next2.startsWith("-")) {
                errors.add(new ErrorVisitor.UnexpectedOption(next2));
            } else {
                errors.add(new ErrorVisitor.UnexpectedArgument(next2));
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this + " form is returning false as there are more args available" + " that haven't been consumed");
            }
            args2.setPosition(oldpos);
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Form " + this + " is returning true");
        }
        return true;
    }

    public boolean hasInfoOption(TokenInputStream args2) {
        int pos = args2.getPosition();
        args2.setPosition(0);
        while (args2.available() > 0) {
            String optionValue = args2.read();
            if (!"-?".equals(optionValue) && !"-help".equals(optionValue) && !"-h".equals(optionValue) && !"-v".equals(optionValue)) continue;
            return true;
        }
        args2.setPosition(pos);
        return false;
    }

    public boolean isSatisfied(ErrorVisitor errors) {
        return true;
    }

    public String getName() {
        if (this.element.hasAttribute("value")) {
            return this.element.getAttribute("value");
        }
        return "default";
    }

    public String toString() {
        return this.getName();
    }
}

