/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;

public class Option
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Option.class);
    private static final String VALUE_ENUM_SEPARATOR = "|";
    protected Element argument;
    protected Element annotation;
    private final Element element;
    private Element valueType;
    private int numMatches;

    public Option(Element el) {
        this.element = el;
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "associatedArgument");
        if (elemList != null && elemList.size() > 0) {
            this.argument = elemList.get(0);
        }
        if ((elemList = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "annotation")) != null && elemList.size() > 0) {
            this.annotation = elemList.get(0);
        }
        if (this.annotation == null && this.argument != null && (elemList = DOMUtils.findAllElementsByTagNameNS(this.argument, "http://cxf.apache.org/Xutil/ToolSpecification", "annotation")) != null && elemList.size() > 0) {
            this.annotation = elemList.get(0);
        }
    }

    public boolean hasArgument() {
        return this.argument != null;
    }

    public boolean hasImmediateArgument() {
        return this.hasArgument() && "immediate".equals(this.argument.getAttribute("placement"));
    }

    public boolean accept(TokenInputStream args2, Element result2, ErrorVisitor errors) {
        if (args2.available() == 0) {
            return false;
        }
        String arg = args2.peek();
        if (arg == null) {
            LOG.severe("ARGUMENT_IS_NULL_MSG");
        }
        List<Element> switches = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "switch");
        boolean accepted = false;
        for (Element switchElem : switches) {
            String switchArg = "-" + switchElem.getFirstChild().getNodeValue();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("switchArg is " + switchArg);
            }
            if (!(this.hasImmediateArgument() ? arg.startsWith(switchArg) : arg.equals(switchArg))) continue;
            LOG.fine("Matches a switch!!!");
            args2.read();
            Element optionEl = result2.getOwnerDocument().createElementNS("http://cxf.apache.org/Xutil/Command", "option");
            optionEl.setAttribute("name", this.getName());
            if (this.hasArgument()) {
                String argValue = this.hasImmediateArgument() ? arg.substring(switchArg.length()) : this.readArgumentValue(args2, switchArg, errors);
                if (argValue == null) break;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Setting argument value of option to " + argValue);
                }
                optionEl.appendChild(result2.getOwnerDocument().createTextNode(argValue));
            }
            result2.appendChild(optionEl);
            ++this.numMatches;
            accepted = true;
        }
        return accepted;
    }

    private String readArgumentValue(TokenInputStream args2, String switchArg, ErrorVisitor errors) {
        String value2 = null;
        if (args2.available() > 0) {
            value2 = args2.read();
            if (value2.startsWith("-")) {
                errors.add(new ErrorVisitor.InvalidOption(switchArg));
                value2 = null;
            } else if (this.hasInvalidCharacter(value2)) {
                errors.add(new ErrorVisitor.UserError(switchArg + " has invalid character!"));
            }
            if (!this.isInEnumArgumentValue(value2)) {
                errors.add(new ErrorVisitor.UserError(switchArg + " " + value2 + " not in the enumeration value list!"));
            }
        } else {
            errors.add(new ErrorVisitor.InvalidOption(switchArg));
        }
        return value2;
    }

    private boolean hasInvalidCharacter(String argValue) {
        List<Element> list2 = DOMUtils.findAllElementsByTagNameNS(this.argument, "http://cxf.apache.org/Xutil/ToolSpecification", "valuetype");
        String valuetypeStr = null;
        if (list2 != null && list2.size() > 0) {
            this.valueType = list2.get(0);
            valuetypeStr = this.valueType.getFirstChild().getNodeValue();
            if ("IdentifyString".equals(valuetypeStr)) {
                return !this.isIdentifyString(argValue);
            }
            if ("NamingSpacePackageString".equals(valuetypeStr)) {
                return !this.isNamingSpacePackageString(argValue);
            }
            if ("Digital".equals(valuetypeStr)) {
                for (int i = 0; i < argValue.length(); ++i) {
                    if (Character.isDigit(argValue.charAt(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInEnumArgumentValue(String argValue) {
        boolean result2 = true;
        List<Element> list2 = DOMUtils.findAllElementsByTagNameNS(this.argument, "http://cxf.apache.org/Xutil/ToolSpecification", "valueenum");
        if (list2 != null && list2.size() == 1) {
            result2 = false;
            String enumValue = list2.get(0).getTextContent();
            StringTokenizer stk = new StringTokenizer(enumValue, VALUE_ENUM_SEPARATOR);
            if (stk.countTokens() <= 0) {
                return result2;
            }
            while (stk.hasMoreTokens()) {
                if (!argValue.equals(stk.nextToken())) continue;
                result2 = true;
            }
        }
        return result2;
    }

    private boolean isIdentifyString(String value2) {
        for (int i = 0; i < value2.length(); ++i) {
            if (value2.charAt(i) == '.' || Character.isJavaIdentifierPart(value2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isNamingSpacePackageString(String value2) {
        if (value2.indexOf("=") < 0) {
            return this.isIdentifyString(value2);
        }
        String packageName = value2.substring(value2.indexOf("=") + 1, value2.length());
        return this.isIdentifyString(packageName);
    }

    public boolean isSatisfied(ErrorVisitor errors) {
        if (errors.getErrors().size() > 0) {
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("For this option, minOccurs=" + this.element.getAttribute("minOccurs") + " and maxOccurs=" + this.element.getAttribute("maxOccurs") + ", numMatches currently " + this.numMatches);
        }
        boolean result2 = true;
        if (!this.isAtleastMinimum()) {
            errors.add(new ErrorVisitor.MissingOption(this));
            result2 = false;
        }
        if (result2 && !this.isNoGreaterThanMaximum()) {
            errors.add(new ErrorVisitor.DuplicateOption(this.getName()));
            result2 = false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("isSatisfied() returning " + result2);
        }
        return result2;
    }

    private boolean isAtleastMinimum() {
        boolean result2 = true;
        int minOccurs = 0;
        result2 = !"".equals(this.element.getAttribute("minOccurs")) ? this.numMatches >= Integer.parseInt(this.element.getAttribute("minOccurs")) : this.numMatches >= minOccurs;
        return result2;
    }

    private boolean isNoGreaterThanMaximum() {
        boolean result2 = true;
        int maxOccurs = 1;
        result2 = !"".equals(this.element.getAttribute("maxOccurs")) ? "unbounded".equals(this.element.getAttribute("maxOccurs")) || this.numMatches <= Integer.parseInt(this.element.getAttribute("maxOccurs")) : this.numMatches <= maxOccurs;
        return result2;
    }

    public String getName() {
        return this.element.getAttribute("id");
    }

    public String getAnnotation() {
        return this.annotation.getFirstChild().getNodeValue();
    }

    public String getPrimarySwitch() {
        List<Element> switches = DOMUtils.findAllElementsByTagNameNS(this.element, "http://cxf.apache.org/Xutil/ToolSpecification", "switch");
        return switches.get(0).getFirstChild().getNodeValue();
    }

    public String toString() {
        return this.getName();
    }
}

