/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolsStaxUtils {
    private ToolsStaxUtils() {
    }

    public static List<Tag> getTags(File source) throws Exception {
        ArrayList<Tag> tags2 = new ArrayList<Tag>();
        List<String> ignoreEmptyTags = Arrays.asList("sequence");
        BufferedInputStream is2 = new BufferedInputStream(new FileInputStream(source));
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(is2);
        Tag newTag = null;
        int count2 = 0;
        QName checkingPoint = null;
        Stack<Tag> stack = new Stack<Tag>();
        while (reader2.hasNext()) {
            int event = reader2.next();
            if (checkingPoint != null) {
                ++count2;
            }
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader2.getName());
                if (ignoreEmptyTags.contains(reader2.getLocalName())) {
                    checkingPoint = reader2.getName();
                }
                for (int i = 0; i < reader2.getAttributeCount(); ++i) {
                    newTag.getAttributes().put(reader2.getAttributeName(i), reader2.getAttributeValue(i));
                }
                stack.push(newTag);
            }
            if (event == 4) {
                newTag.setText(reader2.getText());
            }
            if (event != 2) continue;
            Tag startTag2 = (Tag)stack.pop();
            if (checkingPoint != null && checkingPoint.equals(reader2.getName())) {
                if (count2 != 1) {
                    tags2.add(startTag2);
                }
                count2 = 0;
                checkingPoint = null;
                continue;
            }
            tags2.add(startTag2);
        }
        reader2.close();
        return tags2;
    }

    public static Tag getTagTree(File source) throws Exception {
        return ToolsStaxUtils.getTagTree(source, new ArrayList<String>());
    }

    public static Tag getTagTree(File source, List<String> ignoreAttr) throws Exception {
        BufferedInputStream is2 = new BufferedInputStream(new FileInputStream(source));
        return ToolsStaxUtils.getTagTree(is2, ignoreAttr);
    }

    public static Tag getTagTree(InputStream is2, List<String> ignoreAttr) throws Exception {
        Tag root2 = new Tag();
        root2.setName(new QName("root", "root"));
        XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(is2);
        Tag newTag = null;
        Tag currentTag = root2;
        while (reader2.hasNext()) {
            int event = reader2.next();
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader2.getName());
                if (!ignoreAttr.isEmpty()) {
                    newTag.getIgnoreAttr().addAll(ignoreAttr);
                }
                for (int i = 0; i < reader2.getAttributeCount(); ++i) {
                    if ("type".equals(reader2.getAttributeLocalName(i)) && "element".equals(reader2.getLocalName())) {
                        String tp = reader2.getAttributeValue(i);
                        if (tp.contains(":")) {
                            String ns = tp.substring(0, tp.indexOf(":"));
                            if ("tns".equals(ns)) {
                                tp = tp.substring(tp.indexOf(":") + 1);
                            } else {
                                ns = reader2.getNamespaceURI(ns);
                                tp = "{" + ns + "}" + tp.substring(tp.indexOf(":") + 1);
                            }
                        }
                        newTag.getAttributes().put(reader2.getAttributeName(i), tp);
                        continue;
                    }
                    newTag.getAttributes().put(reader2.getAttributeName(i), reader2.getAttributeValue(i));
                }
                newTag.setParent(currentTag);
                currentTag.getTags().add(newTag);
                currentTag = newTag;
            }
            if (event == 4) {
                newTag.setText(reader2.getText());
            }
            if (event != 2) continue;
            currentTag = currentTag.getParent();
        }
        reader2.close();
        return root2;
    }

    public Tag getLastTag(Tag tag2) {
        int lastIndex = tag2.getTags().size() - 1;
        return tag2.getTags().get(lastIndex);
    }
}

