/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.cxf.common.classloader.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URIParserUtil {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"));
    private static final String EXCLUDED_CHARS = "<>\"{}|\\^`";
    private static final String HEX_DIGITS = "0123456789abcdef";

    private URIParserUtil() {
    }

    private static boolean isExcluded(char ch) {
        return ch <= ' ' || ch >= '\u007f' || EXCLUDED_CHARS.indexOf(ch) != -1;
    }

    public static URL[] pathToURLs(String path2) {
        StringTokenizer st = new StringTokenizer(path2, File.pathSeparator);
        URL[] urls2 = new URL[st.countTokens()];
        int count2 = 0;
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            URL url = null;
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
            if (url == null) continue;
            urls2[count2++] = url;
        }
        if (urls2.length != count2) {
            URL[] tmp = new URL[count2];
            System.arraycopy(urls2, 0, tmp, 0, count2);
            urls2 = tmp;
        }
        return urls2;
    }

    public static String parsePackageName(String namespace, String defaultPackageName) {
        String packageName;
        String string2 = packageName = defaultPackageName != null && defaultPackageName.trim().length() > 0 ? defaultPackageName : null;
        if (packageName == null) {
            packageName = URIParserUtil.getPackageName(namespace);
        }
        return packageName;
    }

    public static String getPackageName(String nameSpaceURI) {
        List<String> r;
        String domain;
        String lastToken;
        List<String> tokens;
        int idx = nameSpaceURI.indexOf(58);
        String scheme = "";
        if (idx >= 0 && ("http".equalsIgnoreCase(scheme = nameSpaceURI.substring(0, idx)) || "urn".equalsIgnoreCase(scheme))) {
            nameSpaceURI = nameSpaceURI.substring(idx + 1);
        }
        if ((tokens = URIParserUtil.tokenize(nameSpaceURI, "/: ")).size() == 0) {
            return "cxf";
        }
        if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
            lastToken = lastToken.replace('.', '_');
            tokens.set(tokens.size() - 1, lastToken);
        }
        if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
            domain = domain.substring(0, idx);
        }
        if ("www".equalsIgnoreCase((r = URIParserUtil.reverse(URIParserUtil.tokenize(domain, "urn".equals(scheme) ? ".-" : "."))).get(r.size() - 1))) {
            r.remove(r.size() - 1);
        }
        tokens.addAll(1, r);
        tokens.remove(0);
        for (int i = 0; i < tokens.size(); ++i) {
            String token2 = tokens.get(i);
            if (URIParserUtil.containsReservedKeywords(token2 = URIParserUtil.removeIllegalIdentifierChars(token2))) {
                token2 = '_' + token2;
            }
            tokens.set(i, token2.toLowerCase());
        }
        return URIParserUtil.combine(tokens, '.');
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuilder namespace = new StringBuilder("http://");
        String dot = "";
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(dot + tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    private static List<String> tokenize(String str, String sep) {
        StringTokenizer tokens = new StringTokenizer(str, sep);
        ArrayList<String> r = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken());
        }
        return r;
    }

    private static String removeIllegalIdentifierChars(String token2) {
        StringBuilder newToken = new StringBuilder();
        for (int i = 0; i < token2.length(); ++i) {
            char c2 = token2.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c2)) {
                newToken.append("_" + c2);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c2)) {
                newToken.append('_');
                continue;
            }
            newToken.append(c2);
        }
        return newToken.toString();
    }

    private static String combine(List r, char sep) {
        StringBuilder buf = new StringBuilder(r.get(0).toString());
        for (int i = 1; i < r.size(); ++i) {
            buf.append(sep);
            buf.append(r.get(i));
        }
        return buf.toString();
    }

    private static <T> List<T> reverse(List<T> a2) {
        ArrayList<T> r = new ArrayList<T>();
        for (int i = a2.size() - 1; i >= 0; --i) {
            r.add(a2.get(i));
        }
        return r;
    }

    public static boolean containsReservedKeywords(String token2) {
        return KEYWORDS.contains(token2);
    }

    public static String escapeChars(String s2) {
        StringBuilder b = new StringBuilder(s2);
        int x = 0;
        do {
            char ch;
            if (!URIParserUtil.isExcluded(ch = b.charAt(x))) continue;
            try {
                byte[] bytes2 = Character.toString(ch).getBytes("UTF-8");
                b.setCharAt(x++, '%');
                for (int y = 0; y < bytes2.length; ++y) {
                    b.insert(x++, HEX_DIGITS.charAt((bytes2[y] & 0xFF) >> 4));
                    b.insert(x, HEX_DIGITS.charAt(bytes2[y] & 0xF));
                }
            }
            catch (UnsupportedEncodingException e2) {
                // empty catch block
            }
        } while (++x < b.length());
        return b.toString();
    }

    public static String normalize(String uri) {
        String result2;
        block7: {
            URL url = null;
            result2 = null;
            try {
                url = new URL(uri);
                result2 = URIParserUtil.escapeChars(url.toURI().normalize().toString().replace("\\", "/"));
            }
            catch (MalformedURLException e1) {
                try {
                    if (uri.startsWith("classpath:")) {
                        url = ClassLoaderUtils.getResource(uri.substring(10), URIParserUtil.class);
                        return url != null ? url.toExternalForm() : uri;
                    }
                    File file = new File(uri);
                    if (file.exists()) {
                        return file.toURI().normalize().toString();
                    }
                    String f2 = null;
                    f2 = uri.indexOf(":") != -1 && !uri.startsWith("/") ? "file:/" + uri : "file:" + uri;
                    url = new URL(f2);
                    return URIParserUtil.escapeChars(url.toString().replace("\\", "/"));
                }
                catch (Exception e2) {
                    return URIParserUtil.escapeChars(uri.replace("\\", "/"));
                }
            }
            catch (URISyntaxException e2) {
                if (url == null) break block7;
                result2 = URIParserUtil.escapeChars(url.toString().replace("\\", "/"));
            }
        }
        return result2;
    }

    public static String getAbsoluteURI(String arg) {
        if (arg == null) {
            return null;
        }
        try {
            URL url = new URL(URIParserUtil.normalize(arg));
            if (url.toURI().isOpaque() && "file".equalsIgnoreCase(url.getProtocol())) {
                return new File("").toURI().resolve(url.getPath()).toString();
            }
            return URIParserUtil.normalize(arg);
        }
        catch (MalformedURLException e1) {
            return URIParserUtil.normalize(arg);
        }
        catch (URISyntaxException e2) {
            return URIParserUtil.normalize(arg);
        }
    }
}

