/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.common.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(GZIPInInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(GZIPInInterceptor.class);

    public GZIPInInterceptor() {
        super("receive");
        this.addBefore(AttachmentInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Map<String, List<String>> protocolHeaders = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (protocolHeaders != null) {
            List<String> contentEncoding = HttpHeaderHelper.getHeader(protocolHeaders, "Content-Encoding");
            if (contentEncoding == null) {
                contentEncoding = protocolHeaders.get("SOAPJMS_contentEncoding");
            }
            if (contentEncoding != null && (contentEncoding.contains("gzip") || contentEncoding.contains("x-gzip"))) {
                try {
                    LOG.fine("Uncompressing response");
                    InputStream is2 = message.getContent(InputStream.class);
                    if (is2 == null) {
                        return;
                    }
                    GZIPInputStream zipInput = new GZIPInputStream(is2);
                    message.setContent(InputStream.class, zipInput);
                    for (String key : protocolHeaders.keySet()) {
                        if (!key.equalsIgnoreCase("Content-Encoding")) continue;
                        protocolHeaders.remove(key);
                        break;
                    }
                }
                catch (IOException ex2) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_UNZIP", BUNDLE, new Object[0]), (Throwable)ex2);
                }
            }
        }
    }
}

